/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.automation.test.utils.generic;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;

public class MutualSSLClient {
    private static KeyStore keyStore;
    private static KeyStore trustStore;
    private static FileInputStream keyStoreFIS;
    private static FileInputStream trustStoreFIS;
    private static String keyStorePassword;
    private static String KEY_STORE_TYPE;
    private static String TRUST_STORE_TYPE;
    private static String KEY_MANAGER_TYPE;
    private static String TRUST_MANAGER_TYPE;
    private static String PROTOCOL;
    private static HttpsURLConnection httpsURLConnection;
    private static SSLSocketFactory sslSocketFactory;

    public static void loadKeyStore(String keyStorePath, String keyStorePassoword) throws KeyStoreException, IOException, CertificateException, NoSuchAlgorithmException {
        keyStorePassword = keyStorePassoword;
        keyStore = KeyStore.getInstance(KEY_STORE_TYPE);
        keyStoreFIS = new FileInputStream(keyStorePath);
        keyStore.load(keyStoreFIS, keyStorePassoword.toCharArray());
    }

    public static void loadTrustStore(String trustStorePath, String trustStorePassoword) throws KeyStoreException, IOException, CertificateException, NoSuchAlgorithmException {
        trustStore = KeyStore.getInstance(TRUST_STORE_TYPE);
        trustStoreFIS = new FileInputStream(trustStorePath);
        trustStore.load(trustStoreFIS, trustStorePassoword.toCharArray());
    }

    public static void initMutualSSLConnection() throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException, IOException, UnrecoverableKeyException {
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KEY_MANAGER_TYPE);
        keyManagerFactory.init(keyStore, keyStorePassword.toCharArray());
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TRUST_MANAGER_TYPE);
        trustManagerFactory.init(trustStore);
        SSLContext sslContext = SSLContext.getInstance(PROTOCOL);
        sslContext.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), null);
        sslSocketFactory = sslContext.getSocketFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String sendPostRequest(String backendURL, String message, Map<String, String> requestProps) throws IOException {
        String result = "";
        URL url = new URL(backendURL);
        httpsURLConnection = (HttpsURLConnection)url.openConnection();
        httpsURLConnection.setSSLSocketFactory(sslSocketFactory);
        httpsURLConnection.setDoOutput(true);
        httpsURLConnection.setDoInput(true);
        httpsURLConnection.setRequestMethod("POST");
        if (requestProps != null && requestProps.size() > 0) {
            for (Map.Entry<String, String> entry : requestProps.entrySet()) {
                httpsURLConnection.setRequestProperty(entry.getKey(), entry.getValue());
            }
        }
        OutputStream outputStream = null;
        InputStream inputStream = null;
        BufferedReader bufferedReader = null;
        StringBuilder response = null;
        try {
            String line;
            outputStream = httpsURLConnection.getOutputStream();
            outputStream.write(message.getBytes(Charset.defaultCharset()));
            inputStream = httpsURLConnection.getInputStream();
            InputStreamReader reader = new InputStreamReader(inputStream, Charset.defaultCharset());
            bufferedReader = new BufferedReader(reader);
            response = new StringBuilder();
            while ((line = bufferedReader.readLine()) != null) {
                response.append(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (bufferedReader != null) {
                bufferedReader.close();
            }
            if (inputStream != null) {
                inputStream.close();
            }
            if (outputStream != null) {
                outputStream.close();
            }
        }
        if (response != null) {
            result = response.toString();
        }
        return result;
    }

    public static void unloadKeyStores() {
        try {
            keyStoreFIS.close();
            trustStoreFIS.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String getKeyStoreType() {
        return KEY_STORE_TYPE;
    }

    public static void setKeyStoreType(String KEY_STORE_TYPE) {
        MutualSSLClient.KEY_STORE_TYPE = KEY_STORE_TYPE;
    }

    public static String getTrustStoreType() {
        return TRUST_STORE_TYPE;
    }

    public static void setTrustStoreType(String TRUST_STORE_TYPE) {
        MutualSSLClient.TRUST_STORE_TYPE = TRUST_STORE_TYPE;
    }

    public static String getKeyManagerType() {
        return KEY_MANAGER_TYPE;
    }

    public static void settKeyManagerType(String KEY_MANAGER_TYPE) {
        MutualSSLClient.KEY_MANAGER_TYPE = KEY_MANAGER_TYPE;
    }

    public static String getTrustManagerType() {
        return TRUST_MANAGER_TYPE;
    }

    public static void getTrustManagerType(String TRUST_MANAGER_TYPE) {
        MutualSSLClient.TRUST_MANAGER_TYPE = TRUST_MANAGER_TYPE;
    }

    public static HttpsURLConnection getHttpsURLConnection() {
        return httpsURLConnection;
    }

    public static void setProtocol(String PROTOCOL) {
        MutualSSLClient.PROTOCOL = PROTOCOL;
    }

    static {
        KEY_STORE_TYPE = "JKS";
        TRUST_STORE_TYPE = "JKS";
        KEY_MANAGER_TYPE = "SunX509";
        TRUST_MANAGER_TYPE = "SunX509";
        PROTOCOL = "SSLv3";
    }
}

