/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.automation.test.utils.http.client;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.Charset;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSession;
import org.apache.commons.codec.binary.Base64;
import org.wso2.carbon.automation.test.utils.http.client.HttpsResponse;

public class HttpsURLConnectionClient {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpsResponse getRequest(String Uri, String requestParameters) throws IOException {
        if (Uri.startsWith("https://")) {
            String urlStr = Uri;
            if (requestParameters != null && requestParameters.length() > 0) {
                urlStr = urlStr + "?" + requestParameters;
            }
            URL url = new URL(urlStr);
            HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            conn.setDoOutput(true);
            conn.setHostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            });
            conn.setReadTimeout(30000);
            conn.connect();
            StringBuilder sb = new StringBuilder();
            BufferedReader rd = null;
            try {
                String line;
                rd = new BufferedReader(new InputStreamReader(conn.getInputStream(), Charset.defaultCharset()));
                while ((line = rd.readLine()) != null) {
                    sb.append(line);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {
            }
            finally {
                if (rd != null) {
                    rd.close();
                }
                conn.disconnect();
            }
            return new HttpsResponse(sb.toString(), conn.getResponseCode());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpsResponse getWithBasicAuth(String Uri, String requestParameters, String userName, String password) throws IOException {
        if (Uri.startsWith("https://")) {
            String urlStr = Uri;
            if (requestParameters != null && requestParameters.length() > 0) {
                urlStr = urlStr + "?" + requestParameters;
            }
            URL url = new URL(urlStr);
            HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
            conn.setRequestMethod("GET");
            String encode = new String(new Base64().encode((userName + ":" + password).getBytes(Charset.defaultCharset())), Charset.defaultCharset()).replaceAll("\n", "");
            conn.setRequestProperty("Authorization", "Basic " + encode);
            conn.setDoOutput(true);
            conn.setHostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            });
            conn.setReadTimeout(30000);
            conn.connect();
            StringBuilder sb = new StringBuilder();
            BufferedReader rd = null;
            try {
                String line;
                rd = new BufferedReader(new InputStreamReader(conn.getInputStream(), Charset.defaultCharset()));
                while ((line = rd.readLine()) != null) {
                    sb.append(line);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            finally {
                if (rd != null) {
                    rd.close();
                }
                conn.disconnect();
            }
            return new HttpsResponse(sb.toString(), conn.getResponseCode());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpsResponse postWithBasicAuth(String uri, String requestQuery, String userName, String password) throws IOException {
        if (uri.startsWith("https://")) {
            URL url = new URL(uri);
            HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
            conn.setRequestMethod("POST");
            String encode = new String(new Base64().encode((userName + ":" + password).getBytes(Charset.defaultCharset())), Charset.defaultCharset()).replaceAll("\n", "");
            conn.setRequestProperty("Authorization", "Basic " + encode);
            conn.setDoOutput(true);
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            conn.setRequestProperty("charset", "utf-8");
            conn.setRequestProperty("Content-Length", "" + Integer.toString(requestQuery.getBytes(Charset.defaultCharset()).length));
            conn.setUseCaches(false);
            conn.setHostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            });
            DataOutputStream wr = new DataOutputStream(conn.getOutputStream());
            wr.writeBytes(requestQuery);
            conn.setReadTimeout(10000);
            conn.connect();
            System.out.println(conn.getRequestMethod());
            StringBuilder sb = new StringBuilder();
            BufferedReader rd = null;
            try {
                String line;
                rd = new BufferedReader(new InputStreamReader(conn.getInputStream(), Charset.defaultCharset()));
                while ((line = rd.readLine()) != null) {
                    sb.append(line);
                }
                HttpsResponse httpsResponse = new HttpsResponse(sb.toString(), conn.getResponseCode());
                return httpsResponse;
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            finally {
                if (rd != null) {
                    rd.close();
                }
                wr.flush();
                wr.close();
                conn.disconnect();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpsResponse postWithBasicAuth(String uri, String requestQuery, String contentType, String userName, String password) throws IOException {
        if (uri.startsWith("https://")) {
            URL url = new URL(uri);
            HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
            conn.setRequestMethod("POST");
            String encode = new String(new Base64().encode((userName + ":" + password).getBytes(Charset.defaultCharset())), Charset.defaultCharset()).replaceAll("\n", "");
            conn.setRequestProperty("Authorization", "Basic " + encode);
            conn.setDoOutput(true);
            conn.setRequestProperty("Content-Type", contentType);
            conn.setRequestProperty("charset", "utf-8");
            conn.setRequestProperty("Content-Length", "" + Integer.toString(requestQuery.getBytes(Charset.defaultCharset()).length));
            conn.setUseCaches(false);
            conn.setHostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            });
            DataOutputStream wr = new DataOutputStream(conn.getOutputStream());
            wr.writeBytes(requestQuery);
            conn.setReadTimeout(10000);
            conn.connect();
            System.out.println(conn.getRequestMethod());
            StringBuilder sb = new StringBuilder();
            BufferedReader rd = null;
            try {
                String line;
                rd = new BufferedReader(new InputStreamReader(conn.getInputStream(), Charset.defaultCharset()));
                while ((line = rd.readLine()) != null) {
                    sb.append(line);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            finally {
                if (rd != null) {
                    rd.close();
                }
                wr.flush();
                wr.close();
                conn.disconnect();
            }
            return new HttpsResponse(sb.toString(), conn.getResponseCode());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpsResponse putWithBasicAuth(String uri, String requestQuery, String contentType, String userName, String password) throws IOException {
        if (uri.startsWith("https://")) {
            URL url = new URL(uri);
            HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
            conn.setRequestMethod("POST");
            String encode = new String(new Base64().encode((userName + ":" + password).getBytes(Charset.defaultCharset())), Charset.defaultCharset()).replaceAll("\n", "");
            conn.setRequestProperty("Authorization", "Basic " + encode);
            conn.setDoOutput(true);
            conn.setRequestProperty("Content-Type", contentType);
            conn.setRequestProperty("charset", "utf-8");
            conn.setRequestProperty("Content-Length", "" + Integer.toString(requestQuery.getBytes(Charset.defaultCharset()).length));
            conn.setUseCaches(false);
            conn.setHostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            });
            DataOutputStream wr = new DataOutputStream(conn.getOutputStream());
            wr.writeBytes(requestQuery);
            conn.setReadTimeout(10000);
            conn.connect();
            StringBuilder sb = new StringBuilder();
            BufferedReader rd = null;
            try {
                String line;
                rd = new BufferedReader(new InputStreamReader(conn.getInputStream(), Charset.defaultCharset()));
                while ((line = rd.readLine()) != null) {
                    sb.append(line);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            finally {
                if (rd != null) {
                    rd.close();
                }
                wr.flush();
                wr.close();
                conn.disconnect();
            }
            return new HttpsResponse(sb.toString(), conn.getResponseCode());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpsResponse deleteWithBasicAuth(String uri, String contentType, String userName, String password) throws IOException {
        if (uri.startsWith("https://")) {
            URL url = new URL(uri);
            HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
            conn.setRequestMethod("DELETE");
            String encode = new String(new Base64().encode((userName + ":" + password).getBytes(Charset.defaultCharset())), Charset.defaultCharset()).replaceAll("\n", "");
            conn.setRequestProperty("Authorization", "Basic " + encode);
            if (contentType != null) {
                conn.setRequestProperty("Content-Type", contentType);
            }
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setUseCaches(false);
            conn.setAllowUserInteraction(false);
            conn.setHostnameVerifier(new HostnameVerifier(){

                @Override
                public boolean verify(String hostname, SSLSession session) {
                    return true;
                }
            });
            conn.connect();
            StringBuilder sb = new StringBuilder();
            BufferedReader rd = null;
            try {
                String line;
                rd = new BufferedReader(new InputStreamReader(conn.getInputStream(), Charset.defaultCharset()));
                while ((line = rd.readLine()) != null) {
                    sb.append(line);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            finally {
                if (rd != null) {
                    rd.close();
                }
                conn.disconnect();
            }
            return new HttpsResponse(sb.toString(), conn.getResponseCode());
        }
        return null;
    }
}

