/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.automation.test.utils.jmxclient.generic;

import java.io.IOException;
import java.util.Hashtable;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXConnectorFactory;
import javax.management.remote.JMXServiceURL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JMXClient {
    private MBeanServerConnection mbsc = null;
    private String userName;
    private String password;
    private ObjectName objectName;
    private JMXConnector jmxc;
    private static final Log log = LogFactory.getLog(JMXClient.class);

    public JMXClient(String serviceConnectionName, String userName, String password) throws MalformedObjectNameException {
        this.objectName = new ObjectName(serviceConnectionName);
        this.userName = userName;
        this.password = password;
    }

    public MBeanServerConnection connect(String jmxServerURL) throws IOException, MalformedObjectNameException {
        JMXServiceURL url = new JMXServiceURL(jmxServerURL);
        Hashtable<String, String[]> hashT = new Hashtable<String, String[]>();
        String[] credentials = new String[]{this.userName, this.password};
        hashT.put("jmx.remote.credentials", credentials);
        this.jmxc = JMXConnectorFactory.connect(url, hashT);
        this.mbsc = this.jmxc.getMBeanServerConnection();
        if (this.mbsc != null) {
            return this.mbsc;
        }
        return null;
    }

    public void disconnect() {
        if (this.jmxc != null) {
            log.info((Object)"Closing jmx client connection...............");
            try {
                this.jmxc.close();
            }
            catch (IOException e) {
                log.warn((Object)"Unable to close the connection");
            }
        }
        if (this.mbsc != null) {
            this.mbsc = null;
        }
    }

    public Object invoke(String operationName, Object[] params) throws ReflectionException, MBeanException, InstanceNotFoundException, IOException {
        return this.mbsc.invoke(this.objectName, operationName, params, new String[]{String.class.getName()});
    }

    public Object getAttribute(String attribute) throws AttributeNotFoundException, MBeanException, ReflectionException, InstanceNotFoundException, IOException {
        return this.mbsc.getAttribute(this.objectName, attribute);
    }
}

