/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.automation.test.utils.jmxclient.threadinfo;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.nio.charset.Charset;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.wso2.carbon.automation.test.utils.jmxclient.utils.AnalyzerUtils;

public class ThreadInformationProvider {
    public ThreadMXBean filterThreadMXBeanObjects(ObjectName nameOfThreadMXBeanObject, MBeanServerConnection mBeanServerConnection) throws IOException {
        return ManagementFactory.newPlatformMXBeanProxy(mBeanServerConnection, nameOfThreadMXBeanObject.toString(), ThreadMXBean.class);
    }

    public long[] getAllThreadIds(ThreadMXBean threadMXBean) {
        return threadMXBean.getAllThreadIds();
    }

    public ThreadInfo getThreadInfo(ThreadMXBean threadMXBean, long id) throws IndexOutOfBoundsException {
        return threadMXBean.getThreadInfo(id);
    }

    public int getThreadCount(ThreadMXBean threadMXBean, long[] allThreadIds, String threadName) throws IndexOutOfBoundsException {
        int count = 0;
        for (long allThreadId : allThreadIds) {
            if (!threadMXBean.getThreadInfo(allThreadId).getThreadName().equals(threadName)) continue;
            ++count;
        }
        return count;
    }

    public int getThreadCountUsingRegex(ThreadMXBean threadMXBean, long[] allThreadIds, String regex) throws IndexOutOfBoundsException {
        int count = 0;
        for (long threadId : allThreadIds) {
            String threadName = threadMXBean.getThreadInfo(threadId).getThreadName();
            if (!threadName.contains(regex)) continue;
            ++count;
        }
        return count;
    }

    public ThreadInfo[] getAllThreadInfo(ThreadMXBean threadMXBean) {
        ThreadInfo[] allThreadInfo = threadMXBean.dumpAllThreads(true, true);
        return allThreadInfo;
    }

    public ThreadInfo[] getDeadlockedThreads(ThreadMXBean threadMXBean) {
        ThreadInfo[] deadlockedThreadInfo = null;
        long[] deadlockedThreads = threadMXBean.findDeadlockedThreads();
        if (deadlockedThreads != null) {
            deadlockedThreadInfo = threadMXBean.getThreadInfo(deadlockedThreads);
        }
        return deadlockedThreadInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createThreadDumpFile(ThreadInfo[] allThreadInfo, String path) throws IOException {
        AnalyzerUtils analyzerUtils = new AnalyzerUtils();
        File threadDumpFile = new File(analyzerUtils.getAbsoluteFilePath(path, "hprof"));
        if (!threadDumpFile.exists() && !threadDumpFile.createNewFile()) {
            return;
        }
        try (BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(threadDumpFile), Charset.defaultCharset()));){
            if (allThreadInfo != null) {
                for (ThreadInfo threadInfo : allThreadInfo) {
                    bufferedWriter.write(analyzerUtils.buildDumpMessage(threadInfo));
                    bufferedWriter.newLine();
                }
            } else if (!threadDumpFile.delete()) {
                // empty if block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createThreadDumpFileOfSingleThread(ThreadInfo threadInfo, String path) throws IOException {
        AnalyzerUtils analyzerUtils = new AnalyzerUtils();
        File threadDumpFile = new File(analyzerUtils.getAbsoluteFilePath(path, "hprof"));
        if (!threadDumpFile.exists() && !threadDumpFile.createNewFile()) {
            return;
        }
        try (BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(threadDumpFile), Charset.defaultCharset()));){
            if (threadInfo != null) {
                bufferedWriter.write(analyzerUtils.buildDumpMessage(threadInfo));
                bufferedWriter.newLine();
            } else if (!threadDumpFile.delete()) {
                // empty if block
            }
        }
    }
}

