/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.automation.test.utils.tcpmon.client;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.Socket;
import java.net.URL;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.automation.test.utils.tcpmon.client.ConnectionData;
import org.wso2.carbon.automation.test.utils.tcpmon.client.SlowLinkSimulator;
import org.wso2.carbon.automation.test.utils.tcpmon.client.SocketRR;
import org.wso2.carbon.automation.test.utils.tcpmon.client.TCPMonListener;

class Connection
extends Thread {
    private static final Log log = LogFactory.getLog(Connection.class);
    private TCPMonListener listener;
    private boolean active;
    private String fromHost;
    private String time;
    private StringBuffer inputText = null;
    private StringBuffer outputText = null;
    private Socket inSocket = null;
    private Socket outSocket = null;
    private SocketRR rr1 = null;
    private SocketRR rr2 = null;
    private InputStream inputStream = null;
    private String HTTPProxyHost = null;
    private int HTTPProxyPort = 80;
    private SlowLinkSimulator slowLink;

    public Connection(TCPMonListener listener) {
        this.listener = listener;
        this.HTTPProxyHost = listener.getHTTPProxyHost();
        this.HTTPProxyPort = listener.getHTTPProxyPort();
        this.slowLink = listener.getSlowLink();
    }

    public Connection(TCPMonListener listener, Socket socket) {
        this(listener);
        this.inSocket = socket;
        this.start();
    }

    public Connection(TCPMonListener listener, InputStream in) {
        this(listener);
        this.inputStream = in;
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            byte[] b;
            this.active = true;
            this.HTTPProxyHost = System.getProperty("http.proxyHost");
            if (this.HTTPProxyHost != null && this.HTTPProxyHost.equals("")) {
                this.HTTPProxyHost = null;
            }
            if (this.HTTPProxyHost != null) {
                String tmp = System.getProperty("http.proxyPort");
                if (tmp != null && tmp.equals("")) {
                    tmp = null;
                }
                this.HTTPProxyPort = tmp == null ? 80 : Integer.parseInt(tmp);
            }
            this.fromHost = this.inSocket != null ? this.inSocket.getInetAddress().getHostName() : "resend";
            String dateformat = "yyyy-MM-dd HH:mm:ss";
            SimpleDateFormat df = new SimpleDateFormat(dateformat);
            this.time = df.format(new Date());
            int count = this.listener.getConnections().size();
            this.listener.getConnectionData().put(count + 1, new ConnectionData("Active", this.time, this.fromHost, this.listener.getTargetHost(), "", ""));
            this.listener.getConnections().add(this);
            this.inputText = new StringBuffer();
            this.outputText = new StringBuffer();
            String targetHost = this.listener.getTargetHost();
            int targetPort = this.listener.getTargetPort();
            int listenPort = this.listener.getListenPort();
            InputStream tmpIn1 = this.inputStream;
            OutputStream tmpOut1 = null;
            InputStream tmpIn2 = null;
            OutputStream tmpOut2 = null;
            if (tmpIn1 == null) {
                tmpIn1 = this.inSocket.getInputStream();
            }
            if (this.inSocket != null) {
                tmpOut1 = this.inSocket.getOutputStream();
            }
            String bufferedData = null;
            StringBuffer buf = null;
            int index = this.listener.getConnections().indexOf(this);
            this.listener.getConnectionData().get(index + 1).setInputText(this.inputText);
            this.listener.getConnectionData().get(index + 1).setOutputText(this.outputText);
            if (this.listener.isProxy() || this.HTTPProxyHost != null) {
                int len;
                b = new byte[1];
                buf = new StringBuffer();
                while ((len = tmpIn1.read(b, 0, 1)) != -1) {
                    String s = new String(b, Charset.defaultCharset());
                    buf.append(s);
                    if (b[0] != 10) continue;
                }
                bufferedData = buf.toString();
                this.inputText.append(bufferedData);
                if (bufferedData.startsWith("GET ") || bufferedData.startsWith("POST ") || bufferedData.startsWith("PUT ") || bufferedData.startsWith("DELETE ")) {
                    URL url;
                    int start = bufferedData.indexOf(32) + 1;
                    while (bufferedData.charAt(start) == ' ') {
                        ++start;
                    }
                    int end = bufferedData.indexOf(32, start);
                    String urlString = bufferedData.substring(start, end);
                    if (urlString.charAt(0) == '/') {
                        urlString = urlString.substring(1);
                    }
                    if (this.listener.isProxy()) {
                        url = new URL(urlString);
                        targetHost = url.getHost();
                        targetPort = url.getPort();
                        if (targetPort == -1) {
                            targetPort = 80;
                        }
                        this.listener.getConnectionData().get(index + 1).setTargetHost(targetHost);
                        bufferedData = bufferedData.substring(0, start) + url.getFile() + bufferedData.substring(end);
                    } else {
                        url = new URL("http://" + targetHost + ":" + targetPort + "/" + urlString);
                        this.listener.getConnectionData().get(index + 1).setTargetHost(targetHost);
                        bufferedData = bufferedData.substring(0, start) + url.toExternalForm() + bufferedData.substring(end);
                        targetHost = this.HTTPProxyHost;
                        targetPort = this.HTTPProxyPort;
                    }
                }
            } else {
                String s1;
                int len;
                byte[] b1 = new byte[1];
                buf = new StringBuffer();
                String lastLine = null;
                while ((len = tmpIn1.read(b1, 0, 1)) != -1) {
                    s1 = new String(b1, Charset.defaultCharset());
                    buf.append(s1);
                    if (b1[0] != 10) continue;
                    String line = buf.toString();
                    buf.setLength(0);
                    if (line.startsWith("Host: ")) {
                        String newHost = "Host: " + targetHost + ":" + listenPort + "\r\n";
                        bufferedData = bufferedData.concat(newHost);
                        break;
                    }
                    bufferedData = bufferedData == null ? line : bufferedData.concat(line);
                    if (line.equals("\r\n") || "\n".equals(lastLine) && line.equals("\n")) break;
                    lastLine = line;
                }
                if (bufferedData != null) {
                    this.inputText.append(bufferedData);
                    int idx = bufferedData.length() < 50 ? bufferedData.length() : 50;
                    s1 = bufferedData.substring(0, idx);
                    int i = s1.indexOf(10);
                    if (i > 0) {
                        s1 = s1.substring(0, i - 1);
                    }
                    s1 = s1 + "                                                  ";
                    s1 = s1.substring(0, 51);
                    this.listener.getConnectionData().get(index + 1).setRequest(s1);
                }
            }
            if (targetPort == -1) {
                targetPort = 80;
            }
            this.outSocket = new Socket(targetHost, targetPort);
            tmpIn2 = this.outSocket.getInputStream();
            tmpOut2 = this.outSocket.getOutputStream();
            if (bufferedData != null) {
                b = bufferedData.getBytes(Charset.defaultCharset());
                tmpOut2.write(b);
                this.slowLink.pump(b.length);
            }
            boolean format = this.listener.isXmlFormatBox();
            this.rr1 = new SocketRR(this, this.inSocket, tmpIn1, this.outSocket, tmpOut2, this.inputText, format, this.listener.getConnectionData(), index + 1, "request:", this.slowLink);
            SlowLinkSimulator responseLink = new SlowLinkSimulator(this.slowLink);
            this.rr2 = new SocketRR(this, this.outSocket, tmpIn2, this.inSocket, tmpOut1, this.outputText, format, null, 0, "response:", responseLink);
            while (this.rr1 != null || this.rr2 != null) {
                if (this.rr2 != null) {
                    this.listener.getConnectionData().get(1 + index).setElapsedTime(this.rr2.getElapsed());
                }
                if (null != this.rr1 && this.rr1.isDone()) {
                    if (index >= 0 && this.rr2 != null) {
                        this.listener.getConnectionData().get(1 + index).setState("Resp");
                    }
                    this.rr1 = null;
                }
                if (null != this.rr2 && this.rr2.isDone()) {
                    if (index >= 0 && this.rr1 != null) {
                        this.listener.getConnectionData().get(1 + index).setState("Req");
                    }
                    this.rr2 = null;
                }
                Connection connection = this;
                synchronized (connection) {
                    this.wait(100L);
                }
            }
            this.active = false;
            if (index >= 0) {
                this.listener.getConnectionData().get(1 + index).setState("Done");
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            StringWriter st = new StringWriter();
            PrintWriter wr = new PrintWriter(st);
            int index = this.listener.getConnections().indexOf(this);
            if (index >= 0) {
                this.listener.getConnectionData().get(1 + index).setState("Error");
            }
            e.printStackTrace(wr);
            wr.close();
            if (this.outputText != null) {
                this.outputText.append(st.toString());
            } else {
                log.error((Object)("Something went wring : " + st.toString()));
            }
            this.halt();
        }
    }

    synchronized void wakeUp() {
        this.notifyAll();
    }

    public void halt() {
        try {
            if (this.rr1 != null) {
                this.rr1.halt();
            }
            if (this.rr2 != null) {
                this.rr2.halt();
            }
            if (this.inSocket != null) {
                this.inSocket.close();
            }
            this.inSocket = null;
            if (this.outSocket != null) {
                this.outSocket.close();
            }
            this.outSocket = null;
        }
        catch (Exception e) {
            log.error((Object)("Error while closing connection : " + e.getMessage()));
        }
    }
}

