/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.automation.test.utils.tcpmon.client;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.charset.Charset;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.automation.test.utils.tcpmon.client.Connection;
import org.wso2.carbon.automation.test.utils.tcpmon.client.ConnectionData;
import org.wso2.carbon.automation.test.utils.tcpmon.client.SlowLinkSimulator;

class SocketRR
extends Thread {
    private static final Log log = LogFactory.getLog(SocketRR.class);
    private Socket inSocket = null;
    private Socket outSocket = null;
    private StringBuffer message;
    private InputStream inputStream = null;
    private OutputStream outputStream = null;
    private boolean xmlFormat;
    private volatile boolean done = false;
    private volatile long elapsed = 0L;
    private Map<Integer, ConnectionData> connectionData = null;
    private int index = 0;
    private String type = null;
    private Connection connection = null;
    private SlowLinkSimulator slowLink;

    public SocketRR(Connection connection, Socket inputSocket, InputStream inputStream, Socket outputSocket, OutputStream outputStream, StringBuffer message, boolean format, Map<Integer, ConnectionData> connectionData, int index, String type, SlowLinkSimulator slowLink) {
        this.inSocket = inputSocket;
        this.inputStream = inputStream;
        this.outSocket = outputSocket;
        this.outputStream = outputStream;
        this.message = message;
        this.xmlFormat = format;
        this.connectionData = connectionData;
        this.index = index;
        this.type = type;
        this.connection = connection;
        this.slowLink = slowLink;
        this.start();
    }

    public boolean isDone() {
        return this.done;
    }

    public String getElapsed() {
        return String.valueOf(this.elapsed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block50: {
            try {
                String tmpStr;
                byte[] buffer = new byte[4096];
                byte[] tmpbuffer = new byte[8192];
                int saved = 0;
                int reqSaved = 0;
                int tabWidth = 3;
                boolean atMargin = true;
                int thisIndent = -1;
                int nextIndent = -1;
                int previousIndent = -1;
                if (this.connectionData != null && !"".equals(tmpStr = this.connectionData.get(this.index).getRequest())) {
                    reqSaved = tmpStr.length();
                }
                long start = System.currentTimeMillis();
                block19: while (true) {
                    int i;
                    this.elapsed = System.currentTimeMillis() - start;
                    if (this.done) {
                        break;
                    }
                    int len = buffer.length;
                    if (len == 0) {
                        len = buffer.length;
                    }
                    if (saved + len > buffer.length) {
                        len = buffer.length - saved;
                    }
                    int len1 = 0;
                    while (len1 == 0) {
                        try {
                            len1 = this.inputStream.read(buffer, saved, len);
                        }
                        catch (Exception ex) {
                            if (this.done && saved == 0) {
                                break block50;
                            }
                            len1 = -1;
                            break;
                        }
                    }
                    if ((len = len1) == -1 && saved == 0) {
                        break;
                    }
                    if (len == -1) {
                        this.done = true;
                    }
                    if (this.outputStream != null && len > 0) {
                        this.slowLink.pump(len);
                        this.outputStream.write(buffer, saved, len);
                    }
                    if (this.connectionData != null && reqSaved < 50) {
                        String old = this.connectionData.get(this.index).getRequest();
                        if ((old = old + new String(buffer, saved, len, Charset.defaultCharset())).length() > 50) {
                            old = old.substring(0, 50);
                        }
                        reqSaved = old.length();
                        i = old.indexOf(10);
                        if (i > 0) {
                            old = old.substring(0, i - 1);
                            reqSaved = 50;
                        }
                        this.connectionData.get(this.index).setRequest(old);
                    }
                    if (this.xmlFormat) {
                        boolean inXML = false;
                        int bufferLen = saved;
                        if (len != -1) {
                            bufferLen += len;
                        }
                        int i2 = 0;
                        saved = 0;
                        for (int i1 = 0; i1 < bufferLen; ++i1) {
                            if (len != -1 && i1 + 1 == bufferLen) {
                                saved = 1;
                                break;
                            }
                            thisIndent = -1;
                            if (buffer[i1] == 60 && buffer[i1 + 1] != 47) {
                                previousIndent = nextIndent++;
                                thisIndent = nextIndent;
                                inXML = true;
                            }
                            if (buffer[i1] == 60 && buffer[i1 + 1] == 47) {
                                if (previousIndent > nextIndent) {
                                    thisIndent = nextIndent;
                                }
                                previousIndent = nextIndent--;
                                inXML = true;
                            }
                            if (buffer[i1] == 47 && buffer[i1 + 1] == 62) {
                                previousIndent = nextIndent--;
                                inXML = true;
                            }
                            if (thisIndent != -1) {
                                if (thisIndent > 0) {
                                    tmpbuffer[i2++] = 10;
                                }
                                for (i = tabWidth * thisIndent; i > 0; --i) {
                                    tmpbuffer[i2++] = 32;
                                }
                            }
                            boolean bl = atMargin = buffer[i1] == 10 || buffer[i1] == 13;
                            if (inXML && atMargin) continue;
                            tmpbuffer[i2++] = buffer[i1];
                        }
                        this.message.append(new String(tmpbuffer, 0, i2, Charset.defaultCharset()));
                        i = 0;
                        while (true) {
                            if (i >= saved) continue block19;
                            buffer[i] = buffer[bufferLen - saved + i];
                            ++i;
                        }
                    }
                    this.message.append(new String(buffer, 0, len, Charset.defaultCharset()));
                }
            }
            catch (Exception e) {
                log.error((Object)("Error while SocketRR.run() : " + e.getMessage()));
            }
            finally {
                this.done = true;
                try {
                    if (this.outputStream != null) {
                        this.outputStream.flush();
                        if (null != this.outSocket) {
                            this.outSocket.shutdownOutput();
                        } else {
                            this.outputStream.close();
                        }
                        this.outputStream = null;
                    }
                }
                catch (Exception e) {
                    log.error((Object)("Error while closing outSocket and outputStream : " + e.getMessage()));
                }
                try {
                    if (this.inputStream != null) {
                        if (this.inSocket != null) {
                            this.inSocket.shutdownInput();
                        } else {
                            this.inputStream.close();
                        }
                        this.inputStream = null;
                    }
                }
                catch (Exception e) {
                    log.error((Object)("Error while closing inSocket and inputStream : " + e.getMessage()));
                }
                this.connection.wakeUp();
            }
        }
    }

    public void halt() {
        try {
            if (this.inSocket != null) {
                this.inSocket.close();
            }
            if (this.outSocket != null) {
                this.outSocket.close();
            }
            this.inSocket = null;
            this.outSocket = null;
            if (this.inputStream != null) {
                this.inputStream.close();
            }
            if (this.outputStream != null) {
                this.outputStream.close();
            }
            this.inputStream = null;
            this.outputStream = null;
            this.done = true;
        }
        catch (Exception e) {
            log.error((Object)("Error while closing SocketRR : " + e.getMessage()));
        }
    }
}

