/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.automation.test.utils.tcpmon.client;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.automation.test.utils.tcpmon.client.Connection;
import org.wso2.carbon.automation.test.utils.tcpmon.client.ConnectionData;
import org.wso2.carbon.automation.test.utils.tcpmon.client.SlowLinkSimulator;
import org.wso2.carbon.automation.test.utils.tcpmon.client.SocketWaiter;

public class TCPMonListener {
    private static final Log log = LogFactory.getLog(TCPMonListener.class);
    private int listenPort;
    private String targetHost;
    private int targetPort;
    private boolean isProxy = false;
    private boolean xmlFormatBox = true;
    private Map<Integer, ConnectionData> connectionData = new HashMap<Integer, ConnectionData>(0);
    private SocketWaiter socketWaiter = null;
    private String HTTPProxyHost = null;
    private int HTTPProxyPort = 80;
    private SlowLinkSimulator slowLink;
    private final List<Connection> connections = new ArrayList<Connection>(0);

    public TCPMonListener(int listenPort, String targetHost, int targetPort) {
        this(listenPort, targetHost, targetPort, false, null);
    }

    public TCPMonListener(int listenPort, String targetHost, int targetPort, boolean isProxy, int delayBytes, int delayTime) {
        this(listenPort, targetHost, targetPort, isProxy, new SlowLinkSimulator(delayBytes, delayTime));
    }

    public TCPMonListener(int listenPort, String targetHost, int targetPort, boolean isProxy, SlowLinkSimulator slowLink) {
        this.slowLink = slowLink != null ? slowLink : new SlowLinkSimulator(0, 0);
        this.listenPort = listenPort;
        this.targetHost = targetHost;
        this.targetPort = targetPort;
        this.isProxy = isProxy;
    }

    public void start() {
        log.info((Object)"TCPMon listener starting....");
        this.socketWaiter = new SocketWaiter(this, this.listenPort);
    }

    public void stop() {
        try {
            for (Connection connection : this.connections) {
                connection.halt();
            }
            this.socketWaiter.halt();
            log.info((Object)"TCPMon listener stopped....");
        }
        catch (Exception e) {
            log.error((Object)("Error while TCPMon listener stopping : " + e.getMessage()));
        }
    }

    public void clear() {
        try {
            for (Connection connection : this.connections) {
                connection.halt();
            }
            this.connections.clear();
            this.connectionData.clear();
            log.info((Object)"TCPMon listener stopped....");
        }
        catch (Exception e) {
            log.error((Object)("Error while TCPMon listener stopping : " + e.getMessage()));
        }
    }

    public Map<Integer, ConnectionData> getConnectionData() {
        return this.connectionData;
    }

    List<Connection> getConnections() {
        return this.connections;
    }

    int getListenPort() {
        return this.listenPort;
    }

    String getTargetHost() {
        return this.targetHost;
    }

    int getTargetPort() {
        return this.targetPort;
    }

    boolean isProxy() {
        return this.isProxy;
    }

    boolean isXmlFormatBox() {
        return this.xmlFormatBox;
    }

    SocketWaiter getSocketWaiter() {
        return this.socketWaiter;
    }

    String getHTTPProxyHost() {
        return this.HTTPProxyHost;
    }

    int getHTTPProxyPort() {
        return this.HTTPProxyPort;
    }

    SlowLinkSimulator getSlowLink() {
        return this.slowLink;
    }
}

