/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.deployment.synchronizer.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.deployment.synchronizer.DeploymentSynchronizationManager;
import org.wso2.carbon.deployment.synchronizer.DeploymentSynchronizer;
import org.wso2.carbon.deployment.synchronizer.DeploymentSynchronizerException;
import org.wso2.carbon.deployment.synchronizer.repository.CarbonRepositoryUtils;
import org.wso2.carbon.deployment.synchronizer.services.DeploymentSynchronizerService;
import org.wso2.carbon.deployment.synchronizer.util.DeploymentSynchronizerConfiguration;
import org.wso2.carbon.utils.CarbonUtils;
import org.wso2.carbon.utils.deployment.GhostDeployerUtils;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class DeploymentSynchronizerServiceImpl
implements DeploymentSynchronizerService,
org.wso2.carbon.core.deployment.DeploymentSynchronizer {
    private static final Log log = LogFactory.getLog(DeploymentSynchronizerServiceImpl.class);
    private DeploymentSynchronizationManager syncManager = DeploymentSynchronizationManager.getInstance();

    @Override
    public boolean synchronizerExists(String filePath) {
        return this.syncManager.getSynchronizer(filePath) != null;
    }

    @Override
    public boolean isAutoCommitOn(String filePath) throws DeploymentSynchronizerException {
        DeploymentSynchronizer synchronizer = this.getSynchronizer(filePath);
        return synchronizer.isAutoCommit();
    }

    @Override
    public boolean isAutoCheckoutOn(String filePath) throws DeploymentSynchronizerException {
        DeploymentSynchronizer synchronizer = this.getSynchronizer(filePath);
        return synchronizer.isAutoCheckout();
    }

    @Override
    public long getLastCommitTime(String filePath) throws DeploymentSynchronizerException {
        DeploymentSynchronizer synchronizer = this.getSynchronizer(filePath);
        return synchronizer.getLastCommitTime();
    }

    @Override
    public long getLastCheckoutTime(String filePath) throws DeploymentSynchronizerException {
        DeploymentSynchronizer synchronizer = this.getSynchronizer(filePath);
        return synchronizer.getLastCheckoutTime();
    }

    public boolean update(int tenantId) {
        try {
            DeploymentSynchronizerConfiguration configuration = CarbonRepositoryUtils.getActiveSynchronizerConfiguration(tenantId);
            if (!configuration.isEnabled() || !configuration.isAutoCheckout()) {
                return false;
            }
            DeploymentSynchronizer synchronizer = this.getSynchronizer(MultitenantUtils.getAxis2RepositoryPath((int)tenantId));
            if (synchronizer == null) {
                synchronizer = CarbonRepositoryUtils.newCarbonRepositorySynchronizer(tenantId);
                if (synchronizer == null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Repository Deployment Synchronizer creation failed for tenant - " + tenantId));
                    }
                    return false;
                }
                if (GhostDeployerUtils.isGhostOn() && GhostDeployerUtils.isPartialUpdateEnabled() && CarbonUtils.isWorkerNode() && tenantId > 0) {
                    synchronizer.syncGhostMetaArtifacts();
                } else {
                    synchronizer.doInitialSyncUp();
                }
            } else if (GhostDeployerUtils.isGhostOn() && GhostDeployerUtils.isPartialUpdateEnabled() && CarbonUtils.isWorkerNode() && tenantId > 0) {
                return synchronizer.syncGhostMetaArtifacts();
            }
            return synchronizer.checkout();
        }
        catch (DeploymentSynchronizerException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean commit(int tenantId) {
        try {
            DeploymentSynchronizerConfiguration configuration = CarbonRepositoryUtils.getActiveSynchronizerConfiguration(tenantId);
            if (!configuration.isEnabled() || !configuration.isAutoCommit()) {
                return false;
            }
            DeploymentSynchronizer synchronizer = this.getSynchronizer(MultitenantUtils.getAxis2RepositoryPath((int)tenantId));
            if (synchronizer == null) {
                synchronizer = CarbonRepositoryUtils.newCarbonRepositorySynchronizer(tenantId);
                if (synchronizer == null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Repository Deployment Synchronizer creation failed for tenant - " + tenantId));
                    }
                    return false;
                }
                synchronizer.doInitialSyncUp();
            }
            return synchronizer.commit();
        }
        catch (DeploymentSynchronizerException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean checkout(String filePath) throws DeploymentSynchronizerException {
        DeploymentSynchronizer synchronizer = this.getSynchronizer(filePath);
        return synchronizer.checkout();
    }

    @Override
    @Deprecated
    public boolean checkout(String filePath, int depth) throws DeploymentSynchronizerException {
        DeploymentSynchronizer synchronizer = this.getSynchronizer(filePath);
        return synchronizer.checkout(filePath, depth);
    }

    @Override
    @Deprecated
    public boolean update(String rootPath, String filePath, int depth) throws DeploymentSynchronizerException {
        DeploymentSynchronizer synchronizer = this.getSynchronizer(rootPath);
        return synchronizer.update(rootPath, filePath, depth);
    }

    @Override
    public boolean commit(String filePath) throws DeploymentSynchronizerException {
        DeploymentSynchronizer synchronizer = this.getSynchronizer(filePath);
        return synchronizer.commit();
    }

    @Override
    public boolean commit(String rootPath, String filePath) throws DeploymentSynchronizerException {
        DeploymentSynchronizer synchronizer = this.getSynchronizer(rootPath);
        return synchronizer.commit(filePath);
    }

    private DeploymentSynchronizer getSynchronizer(String filePath) throws DeploymentSynchronizerException {
        DeploymentSynchronizer synchronizer = this.syncManager.getSynchronizer(filePath);
        if (synchronizer == null) {
            log.warn((Object)("A repository synchronizer has not been engaged for the file path: " + filePath));
            return null;
        }
        return synchronizer;
    }
}

