/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.core.internal.builder;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.event.core.EventBroker;
import org.wso2.carbon.utils.AbstractAxis2ConfigurationContextObserver;

public class EventAxis2ConfigurationContextObserver
extends AbstractAxis2ConfigurationContextObserver {
    private static Log log = LogFactory.getLog(EventAxis2ConfigurationContextObserver.class);
    private EventBroker eventBroker;
    private Set<Integer> loadedTenants = new HashSet<Integer>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void creatingConfigurationContext(int tenantId) {
        try {
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(tenantId, true);
            if (!this.loadedTenants.contains(tenantId)) {
                this.eventBroker.initializeTenant();
                this.loadedTenants.add(tenantId);
            }
        }
        catch (Exception e) {
            log.error((Object)"Error in setting tenant information", (Throwable)e);
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    public void setEventBroker(EventBroker eventBroker) {
        this.eventBroker = eventBroker;
    }
}

