/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.core.internal.builder;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.event.core.EventBundleNotificationService;
import org.wso2.carbon.event.core.internal.builder.EventBrokerHandler;
import org.wso2.carbon.event.core.internal.util.EventBrokerHolder;
import org.wso2.carbon.registry.core.service.RegistryService;
import org.wso2.carbon.user.api.UserRealmService;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.ConfigurationContextService;

public class EventBrokerBuilderDS {
    private static final Log log = LogFactory.getLog(EventBrokerBuilderDS.class);
    private EventBrokerHandler eventBrokerHandler;

    protected void activate(ComponentContext context) {
        this.eventBrokerHandler = new EventBrokerHandler(context);
        boolean isQpidBundlePresent = false;
        BundleContext bundleContext = context.getBundleContext();
        for (Bundle bundle : bundleContext.getBundles()) {
            if (!bundle.getSymbolicName().equals("org.wso2.carbon.andes") && !bundle.getSymbolicName().equals("org.wso2.carbon.qpid")) continue;
            isQpidBundlePresent = true;
            break;
        }
        if (isQpidBundlePresent) {
            context.getBundleContext().registerService(EventBundleNotificationService.class.getName(), (Object)this.eventBrokerHandler, null);
        } else {
            this.eventBrokerHandler.startEventBroker();
        }
    }

    protected void deactivate(ComponentContext context) {
    }

    protected void setRegistryService(RegistryService registryService) {
        EventBrokerHolder.getInstance().registerRegistryService(registryService);
    }

    protected void unsetRegistryService(RegistryService registryService) {
    }

    protected void setRealmService(RealmService realmService) {
        EventBrokerHolder.getInstance().registerRealmService((UserRealmService)realmService);
    }

    protected void unsetRealmService(RealmService realmService) {
    }

    protected void setConfigurationContextService(ConfigurationContextService configurationContextService) {
        EventBrokerHolder.getInstance().registerConfigurationContextService(configurationContextService);
    }

    protected void unsetConfigurationContextService(ConfigurationContextService configurationContextService) {
    }
}

