/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.core.internal.delivery.inmemory;

import java.util.List;
import java.util.concurrent.ExecutorService;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.event.core.Message;
import org.wso2.carbon.event.core.delivery.DeliveryManager;
import org.wso2.carbon.event.core.delivery.MatchingManager;
import org.wso2.carbon.event.core.exception.EventBrokerException;
import org.wso2.carbon.event.core.internal.delivery.Worker;
import org.wso2.carbon.event.core.internal.util.EventBrokerHolder;
import org.wso2.carbon.event.core.internal.util.JavaUtil;
import org.wso2.carbon.event.core.notify.NotificationManager;
import org.wso2.carbon.event.core.subscription.Subscription;
import org.wso2.carbon.user.api.UserRealm;
import org.wso2.carbon.user.api.UserStoreException;

public class InMemoryDeliveryManager
implements DeliveryManager {
    private ExecutorService executor;
    private NotificationManager notificationManager;
    private MatchingManager matchingManager;
    private String topicStoragePath;

    public InMemoryDeliveryManager(ExecutorService executor, String topicStoragePath) {
        this.executor = executor;
        this.topicStoragePath = topicStoragePath;
    }

    @Override
    public void subscribe(Subscription subscription) throws EventBrokerException {
        String resoucePath = JavaUtil.getResourcePath(subscription.getTopicName(), this.topicStoragePath);
        try {
            UserRealm userRealm = EventBrokerHolder.getInstance().getRealmService().getTenantUserRealm(CarbonContext.getThreadLocalCarbonContext().getTenantId());
            String userName = subscription.getOwner();
            if (userName.indexOf("@") != -1) {
                userName = userName.substring(0, userName.indexOf("@"));
            }
            if (!userName.equals("wso2.system.user") && !userRealm.getAuthorizationManager().isUserAuthorized(userName, resoucePath, "subscribe")) {
                throw new EventBrokerException("User " + CarbonContext.getThreadLocalCarbonContext().getUsername() + " is not allowed to subscribes to " + subscription.getTopicName());
            }
            this.matchingManager.addSubscription(subscription);
        }
        catch (UserStoreException e) {
            throw new EventBrokerException("Can not access the user store manager");
        }
    }

    @Override
    public void setNotificationManager(NotificationManager notificationManager) {
        this.notificationManager = notificationManager;
    }

    @Override
    public void publish(Message message, String topicName, int deliveryMode) throws EventBrokerException {
        block5: {
            String resoucePath = JavaUtil.getResourcePath(topicName, this.topicStoragePath);
            try {
                UserRealm userRealm = EventBrokerHolder.getInstance().getRealmService().getTenantUserRealm(CarbonContext.getThreadLocalCarbonContext().getTenantId());
                String userName = CarbonContext.getThreadLocalCarbonContext().getUsername();
                if (userName == null) {
                    userName = "wso2.system.user";
                }
                if (userName.equals("wso2.system.user") || userRealm.getAuthorizationManager().isUserAuthorized(userName, resoucePath, "publish")) {
                    List<Subscription> subscriptions = this.matchingManager.getMatchingSubscriptions(topicName);
                    for (Subscription subscription : subscriptions) {
                        this.executor.submit(new Worker(this.notificationManager, message, subscription));
                    }
                    break block5;
                }
                throw new EventBrokerException("User " + CarbonContext.getThreadLocalCarbonContext().getUsername() + " is not allowed to publish to " + topicName);
            }
            catch (UserStoreException e) {
                throw new EventBrokerException("Can not access the user store manager");
            }
        }
    }

    public void setMatchingManager(MatchingManager matchingManager) {
        this.matchingManager = matchingManager;
    }

    @Override
    public void unSubscribe(String id) throws EventBrokerException {
        this.matchingManager.unSubscribe(id);
    }

    @Override
    public void cleanUp() {
    }

    @Override
    public void renewSubscription(Subscription subscription) throws EventBrokerException {
        this.matchingManager.renewSubscription(subscription);
    }

    @Override
    public void initializeTenant() throws EventBrokerException {
        this.matchingManager.initializeTenant();
    }
}

