/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.core.internal.delivery.inmemory;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.event.core.delivery.MatchingManager;
import org.wso2.carbon.event.core.exception.EventBrokerException;
import org.wso2.carbon.event.core.internal.delivery.inmemory.InMemorySubscriptionStorage;
import org.wso2.carbon.event.core.subscription.Subscription;

public class InMemoryMatchingManager
implements MatchingManager {
    private static final Log log = LogFactory.getLog(InMemoryMatchingManager.class);
    private Map<Integer, InMemorySubscriptionStorage> tenantIDInMemorySubscriptionStorageMap = new ConcurrentHashMap<Integer, InMemorySubscriptionStorage>();

    @Override
    public void addSubscription(Subscription subscription) {
        InMemorySubscriptionStorage inMemorySubscriptionStorage = this.tenantIDInMemorySubscriptionStorageMap.get(CarbonContext.getThreadLocalCarbonContext().getTenantId());
        inMemorySubscriptionStorage.addSubscription(subscription);
    }

    @Override
    public List<Subscription> getMatchingSubscriptions(String topicName) {
        InMemorySubscriptionStorage inMemorySubscriptionStorage = this.tenantIDInMemorySubscriptionStorageMap.get(CarbonContext.getThreadLocalCarbonContext().getTenantId());
        if (inMemorySubscriptionStorage != null) {
            return inMemorySubscriptionStorage.getMatchingSubscriptions(topicName);
        }
        return new ArrayList<Subscription>();
    }

    @Override
    public void unSubscribe(String subscriptionID) throws EventBrokerException {
        InMemorySubscriptionStorage inMemorySubscriptionStorage = this.tenantIDInMemorySubscriptionStorageMap.get(CarbonContext.getThreadLocalCarbonContext().getTenantId());
        inMemorySubscriptionStorage.unSubscribe(subscriptionID);
    }

    @Override
    public void renewSubscription(Subscription subscription) throws EventBrokerException {
        InMemorySubscriptionStorage inMemorySubscriptionStorage = this.tenantIDInMemorySubscriptionStorageMap.get(CarbonContext.getThreadLocalCarbonContext().getTenantId());
        inMemorySubscriptionStorage.renewSubscription(subscription);
    }

    @Override
    public void initializeTenant() throws EventBrokerException {
        if (this.tenantIDInMemorySubscriptionStorageMap.get(CarbonContext.getThreadLocalCarbonContext().getTenantId()) == null) {
            this.tenantIDInMemorySubscriptionStorageMap.put(CarbonContext.getThreadLocalCarbonContext().getTenantId(), new InMemorySubscriptionStorage());
        } else {
            log.warn((Object)("There is an InMemorySubscription for tenant with id " + CarbonContext.getThreadLocalCarbonContext().getTenantId() + " exists "));
        }
    }
}

