/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.core.internal.delivery.jms;

import java.util.Properties;
import javax.jms.TopicConnectionFactory;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.wso2.carbon.event.core.exception.EventBrokerException;
import org.wso2.carbon.event.core.internal.delivery.jms.JMSDeliveryManager;
import org.wso2.carbon.event.core.internal.util.EventBrokerHolder;
import org.wso2.carbon.event.core.qpid.QpidServerDetails;

public class QpidJMSDeliveryManager
extends JMSDeliveryManager {
    public static final String QPID_ICF = "org.wso2.andes.jndi.PropertiesFileInitialContextFactory";
    public static final String CF_NAME_PREFIX = "connectionfactory.";
    public static final String CF_NAME = "qpidConnectionfactory";
    public static final String MB_TYPE_LOCAL = "local";
    public static final String MB_TYPE_REMOTE = "remote";
    private String type;
    private String hostName;
    private String qpidPort;
    private String clientID;
    private String virtualHostName;
    private String accessKey;

    public QpidJMSDeliveryManager(String type) {
        this.type = type;
    }

    @Override
    protected Properties getInitialContextProperties(String userName, String password) {
        Properties initialContextProperties = new Properties();
        QpidServerDetails qpidServerDetails = EventBrokerHolder.getInstance().getQpidServerDetails();
        initialContextProperties.put("java.naming.factory.initial", QPID_ICF);
        initialContextProperties.put("org.wso2.carbon.context.RequestBaseContext", "true");
        String connectionURL = null;
        connectionURL = MB_TYPE_LOCAL.equals(this.type) ? qpidServerDetails.getTCPConnectionURL(userName, qpidServerDetails.getAccessKey()) : "amqp://" + userName + ":" + this.accessKey + "@" + this.clientID + "/" + this.virtualHostName + "?brokerlist='tcp://" + this.hostName + ":" + this.qpidPort + "'";
        initialContextProperties.put("connectionfactory.qpidConnectionfactory", connectionURL);
        return initialContextProperties;
    }

    @Override
    protected TopicConnectionFactory getTopicConnectionFactory(InitialContext initialContext) throws EventBrokerException {
        try {
            return (TopicConnectionFactory)initialContext.lookup(CF_NAME);
        }
        catch (NamingException e) {
            throw new EventBrokerException("Can not look up the connection factory ", e);
        }
    }

    @Override
    protected String getTopicName(String topicName) {
        if (topicName.startsWith("/")) {
            topicName = topicName.substring(1);
        }
        topicName = topicName.replaceAll("/", ".");
        topicName = topicName.replaceAll("~", "_");
        topicName = topicName.replaceAll("&", "_");
        topicName = topicName.replaceAll(" ", "_");
        return topicName;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public String getQpidPort() {
        return this.qpidPort;
    }

    public void setQpidPort(String qpidPort) {
        this.qpidPort = qpidPort;
    }

    public String getClientID() {
        return this.clientID;
    }

    public void setClientID(String clientID) {
        this.clientID = clientID;
    }

    public String getVirtualHostName() {
        return this.virtualHostName;
    }

    public void setVirtualHostName(String virtualHostName) {
        this.virtualHostName = virtualHostName;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }
}

