/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.event.core.sharedmemory.util;

import java.io.Serializable;
import org.apache.axis2.clustering.ClusteringCommand;
import org.apache.axis2.clustering.ClusteringFault;
import org.apache.axis2.clustering.ClusteringMessage;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.event.core.sharedmemory.SharedMemorySubscriptionStorage;
import org.wso2.carbon.event.core.sharedmemory.SubscriptionContainer;

public class SubscriptionClusterMessage
extends ClusteringMessage
implements Serializable {
    private static final Log log = LogFactory.getLog(SubscriptionClusterMessage.class);
    private String topicName;
    private String subscriptionID;
    private Integer tenantID;
    private String tenantDomain;
    private static final long serialVersionUID = -4585980192987552283L;

    SubscriptionClusterMessage(String topicName, String subscriptionID, Integer tenantID, String tenantDomain) {
        this.topicName = topicName;
        this.subscriptionID = subscriptionID;
        this.tenantID = tenantID;
        this.tenantDomain = tenantDomain;
    }

    public ClusteringCommand getResponse() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ConfigurationContext arg0) throws ClusteringFault {
        try {
            PrivilegedCarbonContext.startTenantFlow();
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(this.tenantID.intValue());
            PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantDomain(this.tenantDomain);
            PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain(true);
            SubscriptionContainer subscriptionsContainer = (SubscriptionContainer)SharedMemorySubscriptionStorage.getTopicSubscriptionCache().get((Object)this.topicName);
            if (subscriptionsContainer != null) {
                subscriptionsContainer.getSubscriptionsCache().get((Object)this.subscriptionID);
                log.info((Object)("Subscription ID: " + this.subscriptionID + " for the topic: " + this.topicName + " is received."));
            }
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }
}

