/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.ndatasource.capp.deployer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.axis2.deployment.DeploymentException;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.wso2.carbon.application.deployer.CarbonApplication;
import org.wso2.carbon.application.deployer.config.ApplicationConfiguration;
import org.wso2.carbon.application.deployer.config.Artifact;
import org.wso2.carbon.application.deployer.config.CappFile;
import org.wso2.carbon.application.deployer.handler.AppDeploymentHandler;
import org.wso2.carbon.ndatasource.common.DataSourceException;
import org.wso2.carbon.ndatasource.core.DataSourceManager;
import org.wso2.carbon.ndatasource.core.DataSourceMetaInfo;
import org.wso2.carbon.ndatasource.core.utils.DataSourceUtils;

public class DataSourceCappDeployer
implements AppDeploymentHandler {
    private static final Log log = LogFactory.getLog(DataSourceCappDeployer.class);
    public static final String DATA_SOURCE_TYPE = "datasource/datasource";

    public void deployArtifacts(CarbonApplication carbonApp, AxisConfiguration axisConfig) throws DeploymentException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Deploying carbon application - " + carbonApp.getAppName()));
        }
        ApplicationConfiguration appConfig = carbonApp.getAppConfig();
        List deps = appConfig.getApplicationArtifact().getDependencies();
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
        for (Artifact.Dependency dep : deps) {
            if (dep.getArtifact() == null) continue;
            artifacts.add(dep.getArtifact());
        }
        this.deployUnDeployDataSources(true, artifacts);
    }

    public void undeployArtifacts(CarbonApplication carbonApp, AxisConfiguration axisConfig) throws DeploymentException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Un-Deploying carbon application - " + carbonApp.getAppName()));
        }
        ApplicationConfiguration appConfig = carbonApp.getAppConfig();
        List deps = appConfig.getApplicationArtifact().getDependencies();
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
        for (Artifact.Dependency dep : deps) {
            if (dep.getArtifact() == null) continue;
            artifacts.add(dep.getArtifact());
        }
        this.deployUnDeployDataSources(false, artifacts);
    }

    private void deployUnDeployDataSources(boolean deploy, List<Artifact> artifacts) throws DeploymentException {
        for (Artifact artifact : artifacts) {
            if (!DATA_SOURCE_TYPE.equals(artifact.getType())) continue;
            List files = artifact.getFiles();
            if (files == null || files.isEmpty()) {
                throw new DeploymentException("DataSourceCappDeployer::deployUnDeployDataSources --> Error No data sources found in the artifact to deploy");
            }
            for (CappFile cappFile : files) {
                String fileName = cappFile.getName();
                String dataSourceConfigPath = artifact.getExtractedPath() + File.separator + fileName;
                File file = new File(dataSourceConfigPath);
                if (!file.exists()) {
                    throw new DeploymentException("DataSourceCappDeployer::deployUnDeployDataSources --> Error Data source file cannot be found in artifact, file name - " + fileName);
                }
                DataSourceMetaInfo dataSourceMetaInfo = this.readDataSourceFile(file);
                if (deploy) {
                    try {
                        if (DataSourceManager.getInstance().getDataSourceRepository().getDataSource(dataSourceMetaInfo.getName()) != null) {
                            artifact.setDeploymentStatus("Failed");
                            throw new DeploymentException("DataSourceCappDeployer::deployUnDeployDataSources --> Error in deploying data source: data source with same name already exist, data source name - " + dataSourceMetaInfo.getName());
                        }
                        dataSourceMetaInfo.setCarbonApplicationDeployed(true);
                        DataSourceManager.getInstance().getDataSourceRepository().addDataSource(dataSourceMetaInfo);
                        artifact.setDeploymentStatus("Deployed");
                        continue;
                    }
                    catch (DataSourceException e) {
                        throw new DeploymentException("DataSourceCappDeployer::deployUnDeployDataSources --> Error in deploying data source: " + e.getMessage(), (Throwable)e);
                    }
                }
                try {
                    if (DataSourceManager.getInstance().getDataSourceRepository().getDataSource(dataSourceMetaInfo.getName()) == null || !artifact.getDeploymentStatus().equals("Deployed")) continue;
                    DataSourceManager.getInstance().getDataSourceRepository().deleteDataSource(dataSourceMetaInfo.getName());
                }
                catch (DataSourceException e) {
                    throw new DeploymentException("DataSourceCappDeployer::deployUnDeployDataSources --> Error in undeploying data source: " + e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private DataSourceMetaInfo readDataSourceFile(File file) throws DeploymentException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Reading data source file from car file - " + file.getName()));
        }
        try {
            FileInputStream in = new FileInputStream(file);
            Document doc = DataSourceUtils.convertToDocument((InputStream)in);
            DataSourceUtils.secureResolveDocument((Document)doc, (boolean)false);
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{DataSourceMetaInfo.class});
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            DataSourceMetaInfo dataSourceMetaInfo = (DataSourceMetaInfo)jaxbUnmarshaller.unmarshal((Node)doc);
            return dataSourceMetaInfo;
        }
        catch (JAXBException e) {
            throw new DeploymentException("DataSourceCappDeployer::readDataSourceFile --> Error in reading data source file: " + e.getMessage(), (Throwable)e);
        }
        catch (FileNotFoundException e) {
            throw new DeploymentException("DataSourceCappDeployer::readDataSourceFile --> Error data source file not found: " + e.getMessage(), (Throwable)e);
        }
        catch (DataSourceException e) {
            throw new DeploymentException("DataSourceCappDeployer::readDataSourceFile --> Error in decrypting data source file: " + e.getMessage(), (Throwable)e);
        }
    }
}

