/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.transaction.manager;

import java.util.ArrayList;
import java.util.List;
import javax.naming.Context;
import javax.naming.NameNotFoundException;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.transaction.manager.TransactionManagerAxis2ConfigurationContextObserver;
import org.wso2.carbon.transaction.manager.TransactionManagerDummyService;
import org.wso2.carbon.transaction.manager.exception.TransactionManagerException;
import org.wso2.carbon.user.api.Tenant;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.utils.Axis2ConfigurationContextObserver;

public class TransactionManagerComponent {
    private static Log log = LogFactory.getLog(TransactionManagerComponent.class);
    private static TransactionManager txManager;
    private static UserTransaction userTransaction;
    private static RealmService realmService;
    private static Object txManagerComponentLock;

    protected void activate(ComponentContext ctxt) throws TransactionManagerException {
        BundleContext bundleContext = ctxt.getBundleContext();
        bundleContext.registerService(Axis2ConfigurationContextObserver.class.getName(), (Object)new TransactionManagerAxis2ConfigurationContextObserver(), null);
        List<Integer> tenants = this.getAllTenantIds();
        for (int tid : tenants) {
            TransactionManagerComponent.bindTransactionManagerWithJNDIForTenant(tid);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Transaction Manager bundle is activated ");
        }
        bundleContext.registerService(TransactionManagerDummyService.class.getName(), (Object)new TransactionManagerDummyService(), null);
    }

    protected void deactivate(ComponentContext ctxt) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Transaction Manager bundle is deactivated ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setTransactionManager(TransactionManager txManager) {
        Object object = txManagerComponentLock;
        synchronized (object) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Setting the Transaction Manager Service");
            }
            TransactionManagerComponent.txManager = txManager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unsetTransactionManager(TransactionManager txManager) {
        Object object = txManagerComponentLock;
        synchronized (object) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Unsetting the Transaction Manager Service");
            }
            TransactionManagerComponent.txManager = null;
        }
    }

    public static TransactionManager getTransactionManager() {
        return txManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setUserTransaction(UserTransaction userTransaction) {
        Object object = txManagerComponentLock;
        synchronized (object) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Setting the UserTransaction Service");
            }
            TransactionManagerComponent.userTransaction = userTransaction;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unsetUserTransaction(UserTransaction userTransaction) {
        Object object = txManagerComponentLock;
        synchronized (object) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Unsetting the UserTransaction Service");
            }
            TransactionManagerComponent.userTransaction = null;
        }
    }

    public static UserTransaction getUserTransaction() {
        return userTransaction;
    }

    private List<Integer> getAllTenantIds() throws TransactionManagerException {
        try {
            ArrayList<Integer> tids = new ArrayList<Integer>();
            RealmService realmService = TransactionManagerComponent.getRealmService();
            if (realmService != null) {
                Tenant[] tenants;
                for (Tenant tenant : tenants = TransactionManagerComponent.getRealmService().getTenantManager().getAllTenants()) {
                    tids.add(tenant.getId());
                }
                tids.add(-1234);
                return tids;
            }
            tids.add(-1234);
            return tids;
        }
        catch (UserStoreException e) {
            log.error((Object)e);
            throw new TransactionManagerException("Error in listing all the tenants", (Exception)((Object)e));
        }
    }

    protected void setRealmService(RealmService realmService) {
        TransactionManagerComponent.realmService = realmService;
    }

    protected void unsetRealmService(RealmService realmService) {
        TransactionManagerComponent.realmService = null;
    }

    public static RealmService getRealmService() {
        return realmService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void bindTransactionManagerWithJNDIForTenant(int tid) {
        PrivilegedCarbonContext.startTenantFlow();
        PrivilegedCarbonContext.getThreadLocalCarbonContext().setTenantId(tid);
        try {
            Context currentCtx = PrivilegedCarbonContext.getThreadLocalCarbonContext().getJNDIContext();
            Context javaCtx = null;
            try {
                javaCtx = (Context)currentCtx.lookup("java:comp");
            }
            catch (NameNotFoundException nameNotFoundException) {
                // empty catch block
            }
            if (javaCtx == null) {
                currentCtx = currentCtx.createSubcontext("java:comp");
            }
            Object txManager = null;
            Object userTx = null;
            try {
                txManager = currentCtx.lookup("java:comp/TransactionManager");
            }
            catch (NameNotFoundException nameNotFoundException) {
                // empty catch block
            }
            try {
                userTx = currentCtx.lookup("java:comp/UserTransaction");
            }
            catch (NameNotFoundException nameNotFoundException) {
                // empty catch block
            }
            if (txManager == null) {
                currentCtx.bind("TransactionManager", (Object)TransactionManagerComponent.getTransactionManager());
            }
            if (userTx == null) {
                currentCtx.bind("UserTransaction", (Object)TransactionManagerComponent.getUserTransaction());
            }
        }
        catch (Exception e) {
            log.error((Object)("Error in binding transaction manager for tenant: " + tid), (Throwable)e);
        }
        finally {
            PrivilegedCarbonContext.endTenantFlow();
        }
    }

    static {
        txManagerComponentLock = new Object();
    }
}

