/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.consent.mgt.core;

import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.apache.axiom.om.util.Base64;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONObject;
import org.wso2.carbon.consent.mgt.core.ConsentManager;
import org.wso2.carbon.consent.mgt.core.connector.PIIController;
import org.wso2.carbon.consent.mgt.core.constant.ConsentConstants;
import org.wso2.carbon.consent.mgt.core.dao.PIICategoryDAO;
import org.wso2.carbon.consent.mgt.core.dao.PurposeCategoryDAO;
import org.wso2.carbon.consent.mgt.core.dao.PurposeDAO;
import org.wso2.carbon.consent.mgt.core.dao.ReceiptDAO;
import org.wso2.carbon.consent.mgt.core.exception.ConsentManagementClientException;
import org.wso2.carbon.consent.mgt.core.exception.ConsentManagementException;
import org.wso2.carbon.consent.mgt.core.exception.ConsentManagementServerException;
import org.wso2.carbon.consent.mgt.core.model.AddReceiptResponse;
import org.wso2.carbon.consent.mgt.core.model.Address;
import org.wso2.carbon.consent.mgt.core.model.ConsentManagerConfigurationHolder;
import org.wso2.carbon.consent.mgt.core.model.PIICategory;
import org.wso2.carbon.consent.mgt.core.model.PiiController;
import org.wso2.carbon.consent.mgt.core.model.Purpose;
import org.wso2.carbon.consent.mgt.core.model.PurposeCategory;
import org.wso2.carbon.consent.mgt.core.model.PurposePIICategory;
import org.wso2.carbon.consent.mgt.core.model.Receipt;
import org.wso2.carbon.consent.mgt.core.model.ReceiptInput;
import org.wso2.carbon.consent.mgt.core.model.ReceiptListResponse;
import org.wso2.carbon.consent.mgt.core.model.ReceiptPurposeInput;
import org.wso2.carbon.consent.mgt.core.model.ReceiptServiceInput;
import org.wso2.carbon.consent.mgt.core.util.ConsentConfigParser;
import org.wso2.carbon.consent.mgt.core.util.ConsentUtils;
import org.wso2.carbon.consent.mgt.core.util.LambdaExceptionUtils;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.core.util.KeyStoreManager;
import org.wso2.carbon.user.api.UserRealm;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.UserStoreManager;
import org.wso2.carbon.user.core.common.AbstractUserStoreManager;
import org.wso2.carbon.user.core.service.RealmService;
import org.wso2.carbon.user.core.util.UserCoreUtil;

public class ConsentManagerImpl
implements ConsentManager {
    private static final Log log = LogFactory.getLog(ConsentManagerImpl.class);
    private static final int DEFAULT_SEARCH_LIMIT = 100;
    private static final String PII_CONTROLLER = "piiControllers";
    private static final String RECEIPT_DAO = "receiptDAOs";
    private static final String PII_CATEGORY_DAO = "piiCategoryDAOs";
    private static final String PURPOSE_CATEGORY_DAO = "purposedCategoryDAOs";
    private static final String PURPOSE_DAO = "purposedDAOs";
    private static final String USE_CASE_SENSITIVE_USERNAME_FOR_CACHE_KEYS = "UseCaseSensitiveUsernameForCacheKeys";
    private Boolean isCaseSensitiveUserName;
    private List<PurposeDAO> purposeDAOs;
    private List<PurposeCategoryDAO> purposeCategoryDAOs;
    private List<PIICategoryDAO> piiCategoryDAOs;
    private List<ReceiptDAO> receiptDAOs;
    private ConsentConfigParser configParser;
    private List<PIIController> piiControllers;
    private RealmService realmService;

    public ConsentManagerImpl(ConsentManagerConfigurationHolder configHolder) {
        this.purposeDAOs = configHolder.getPurposeDAOs();
        this.purposeCategoryDAOs = configHolder.getPurposeCategoryDAOs();
        this.piiCategoryDAOs = configHolder.getPiiCategoryDAOs();
        this.receiptDAOs = configHolder.getReceiptDAOs();
        this.piiControllers = configHolder.getPiiControllers();
        this.configParser = configHolder.getConfigParser();
        this.realmService = configHolder.getRealmService();
    }

    @Override
    public Purpose addPurpose(Purpose purpose) throws ConsentManagementException {
        this.validateInputParameters(purpose);
        Purpose purposeResponse = this.getPurposeDAO(this.purposeDAOs).addPurpose(purpose);
        return this.populatePiiCategories(purposeResponse);
    }

    @Override
    public Purpose getPurpose(int purposeId) throws ConsentManagementException {
        Purpose purpose = this.getPurposeById(purposeId);
        if (purpose == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("No purpose found for the Id: " + purposeId));
            }
            throw ConsentUtils.handleClientException(ConsentConstants.ErrorMessages.ERROR_CODE_PURPOSE_ID_INVALID, String.valueOf(purposeId));
        }
        ArrayList<PurposePIICategory> purposePIICategories = new ArrayList<PurposePIICategory>();
        purpose.getPurposePIICategories().forEach(LambdaExceptionUtils.rethrowConsumer(piiCategory -> purposePIICategories.add(this.getPurposePIICategory((PurposePIICategory)piiCategory))));
        purpose.setPurposePIICategories(purposePIICategories);
        return purpose;
    }

    @Override
    public Purpose getPurposeByName(String name, String group, String groupType) throws ConsentManagementException {
        Purpose purposeByName = this.getPurposeFromName(name, group, groupType);
        if (purposeByName == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("No purpose found as the name: " + name + " in tenant domain: " + ConsentUtils.getTenantDomainFromCarbonContext()));
            }
            throw ConsentUtils.handleClientException(ConsentConstants.ErrorMessages.ERROR_CODE_PURPOSE_NAME_INVALID, name);
        }
        return this.getPurposeById(purposeByName.getId());
    }

    @Override
    public List<Purpose> listPurposes(int limit, int offset) throws ConsentManagementException {
        this.validatePaginationParameters(limit, offset);
        if (limit == 0) {
            limit = this.getDefaultLimitFromConfig();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Limit is not defied the request, default to: " + limit));
            }
        }
        return this.getPurposeDAO(this.purposeDAOs).listPurposes(limit, offset, ConsentUtils.getTenantIdFromCarbonContext());
    }

    @Override
    public List<Purpose> listPurposes(String group, String groupType, int limit, int offset) throws ConsentManagementException {
        this.validatePaginationParameters(limit, offset);
        if (limit == 0) {
            limit = this.getDefaultLimitFromConfig();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Limit is not defied the request, default to: " + limit));
            }
        }
        return this.getPurposeDAO(this.purposeDAOs).listPurposes(group, groupType, limit, offset, ConsentUtils.getTenantIdFromCarbonContext());
    }

    @Override
    public void deletePurpose(int purposeId) throws ConsentManagementException {
        if (purposeId <= 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Purpose Id is not found in the request or invalid purpose Id: " + purposeId));
            }
            throw ConsentUtils.handleClientException(ConsentConstants.ErrorMessages.ERROR_CODE_PURPOSE_ID_REQUIRED, null);
        }
        if (this.getPurposeById(purposeId) == null) {
            throw ConsentUtils.handleClientException(ConsentConstants.ErrorMessages.ERROR_CODE_PURPOSE_ID_INVALID, String.valueOf(purposeId));
        }
        if (this.getPurposeDAO(this.purposeDAOs).isPurposeUsed(purposeId)) {
            throw ConsentUtils.handleClientException(ConsentConstants.ErrorMessages.ERROR_CODE_PURPOSE_IS_ASSOCIATED, String.valueOf(purposeId));
        }
        int id = this.getPurposeDAO(this.purposeDAOs).deletePurpose(purposeId);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Purpose deleted successfully. ID: " + id));
        }
    }

    @Override
    public void deletePurposes(int tenantId) throws ConsentManagementException {
        if (tenantId <= 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Tenant id is not found in the request or invalid tenant id: " + tenantId));
            }
            throw ConsentUtils.handleClientException(ConsentConstants.ErrorMessages.ERROR_CODE_TENANT_ID_REQUIRED, null);
        }
        this.getPurposeDAO(this.purposeDAOs).deletePurposesByTenantId(tenantId);
        if (log.isDebugEnabled()) {
            log.debug((Object)("All purposes deleted successfully for tenant: " + tenantId));
        }
    }

    @Override
    public boolean isPurposeExists(String name, String group, String groupType) throws ConsentManagementException {
        return this.getPurposeFromName(name, group, groupType) != null;
    }

    @Override
    public PurposeCategory addPurposeCategory(PurposeCategory purposeCategory) throws ConsentManagementException {
        this.validateInputParameters(purposeCategory);
        PurposeCategory category = this.getPurposeCategoryDAO(this.purposeCategoryDAOs).addPurposeCategory(purposeCategory);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Purpose category created successfully with the name: " + category.getName()));
        }
        return category;
    }

    @Override
    public PurposeCategory getPurposeCategory(int purposeCategoryId) throws ConsentManagementException {
        PurposeCategory category = this.getPurposeCategoryById(purposeCategoryId);
        if (category == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("No purpose category found for the Id: " + purposeCategoryId));
            }
            throw ConsentUtils.handleClientException(ConsentConstants.ErrorMessages.ERROR_CODE_PURPOSE_CATEGORY_ID_INVALID, String.valueOf(purposeCategoryId));
        }
        return category;
    }

    @Override
    public PurposeCategory getPurposeCategoryByName(String name) throws ConsentManagementException {
        PurposeCategory purposeCategoryByName = this.getPurposeCategoryFromName(name);
        if (purposeCategoryByName == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("No purpose category found for the name: " + name));
            }
            throw ConsentUtils.handleClientException(ConsentConstants.ErrorMessages.ERROR_CODE_PURPOSE_CAT_NAME_INVALID, name);
        }
        return purposeCategoryByName;
    }

    @Override
    public List<PurposeCategory> listPurposeCategories(int limit, int offset) throws ConsentManagementException {
        this.validatePaginationParameters(limit, offset);
        if (limit == 0) {
            limit = this.getDefaultLimitFromConfig();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Limit is not defied the request, default to: " + limit));
            }
        }
        return this.getPurposeCategoryDAO(this.purposeCategoryDAOs).listPurposeCategories(limit, offset, ConsentUtils.getTenantIdFromCarbonContext());
    }

    @Override
    public void deletePurposeCategory(int purposeCategoryId) throws ConsentManagementException {
        if (purposeCategoryId <= 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Purpose Category Id is not found in the request or invalid Id: " + purposeCategoryId));
            }
            throw ConsentUtils.handleClientException(ConsentConstants.ErrorMessages.ERROR_CODE_PURPOSE_CATEGORY_ID_REQUIRED, null);
        }
        if (this.getPurposeCategoryById(purposeCategoryId) == null) {
            throw ConsentUtils.handleClientException(ConsentConstants.ErrorMessages.ERROR_CODE_PURPOSE_CATEGORY_ID_INVALID, String.valueOf(purposeCategoryId));
        }
        int id = this.getPurposeCategoryDAO(this.purposeCategoryDAOs).deletePurposeCategory(purposeCategoryId);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Purpose category deleted successfully. ID: " + id));
        }
    }

    @Override
    public void deletePurposeCategories(int tenantId) throws ConsentManagementException {
        if (tenantId <= 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Tenant id is not found in the request or invalid tenant id: " + tenantId));
            }
            throw ConsentUtils.handleClientException(ConsentConstants.ErrorMessages.ERROR_CODE_TENANT_ID_REQUIRED, null);
        }
        this.getPurposeCategoryDAO(this.purposeCategoryDAOs).deletePurposeCategoriesByTenantId(tenantId);
        if (log.isDebugEnabled()) {
            log.debug((Object)("All purpose categories deleted successfully for tenant: " + tenantId));
        }
    }

    @Override
    public boolean isPurposeCategoryExists(String name) throws ConsentManagementException {
        return this.getPurposeCategoryFromName(name) != null;
    }

    @Override
    public PIICategory addPIICategory(PIICategory piiCategory) throws ConsentManagementException {
        this.validateInputParameters(piiCategory);
        PIICategory category = this.getPiiCategoryDAO(this.piiCategoryDAOs).addPIICategory(piiCategory);
        if (log.isDebugEnabled()) {
            log.debug((Object)("PII category added successfully with the name: " + category.getName()));
        }
        return category;
    }

    @Override
    public PIICategory getPIICategoryByName(String name) throws ConsentManagementException {
        PIICategory piiCategoryByName = this.getPiiCategoryFromName(name);
        if (piiCategoryByName == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("No PII category found with the name: " + name));
            }
            throw ConsentUtils.handleClientException(ConsentConstants.ErrorMessages.ERROR_CODE_PII_CAT_NAME_INVALID, name);
        }
        return piiCategoryByName;
    }

    @Override
    public PIICategory getPIICategory(int piiCategoryId) throws ConsentManagementException {
        PIICategory piiCategory = this.getPiiCategoryById(piiCategoryId);
        if (piiCategory == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("No PII category found with the Id: " + piiCategoryId));
            }
            throw ConsentUtils.handleClientException(ConsentConstants.ErrorMessages.ERROR_CODE_PII_CATEGORY_ID_INVALID, String.valueOf(piiCategoryId));
        }
        return piiCategory;
    }

    @Override
    public List<PIICategory> listPIICategories(int limit, int offset) throws ConsentManagementException {
        this.validatePaginationParameters(limit, offset);
        if (limit == 0) {
            limit = this.getDefaultLimitFromConfig();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Limit is not defied the request, default to: " + limit));
            }
        }
        return this.getPiiCategoryDAO(this.piiCategoryDAOs).listPIICategories(limit, offset, ConsentUtils.getTenantIdFromCarbonContext());
    }

    @Override
    public void deletePIICategory(int piiCategoryId) throws ConsentManagementException {
        if (piiCategoryId <= 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("PII Category Id is not found in the request or invalid PII category Id: " + piiCategoryId));
            }
            throw ConsentUtils.handleClientException(ConsentConstants.ErrorMessages.ERROR_CODE_PII_CATEGORY_ID_REQUIRED, null);
        }
        if (this.getPiiCategoryById(piiCategoryId) == null) {
            throw ConsentUtils.handleClientException(ConsentConstants.ErrorMessages.ERROR_CODE_PII_CATEGORY_ID_INVALID, String.valueOf(piiCategoryId));
        }
        if (this.getPiiCategoryDAO(this.piiCategoryDAOs).isPIICategoryUsed(piiCategoryId)) {
            throw ConsentUtils.handleClientException(ConsentConstants.ErrorMessages.ERROR_CODE_PII_CATEGORY_IS_ASSOCIATED, String.valueOf(piiCategoryId));
        }
        int id = this.getPiiCategoryDAO(this.piiCategoryDAOs).deletePIICategory(piiCategoryId);
        if (log.isDebugEnabled()) {
            log.debug((Object)("PII Category deleted successfully. ID: " + id));
        }
    }

    @Override
    public void deletePIICategories(int tenantId) throws ConsentManagementException {
        if (tenantId <= 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Tenant id is not found in the request or invalid tenant id: " + tenantId));
            }
            throw ConsentUtils.handleClientException(ConsentConstants.ErrorMessages.ERROR_CODE_TENANT_ID_REQUIRED, null);
        }
        this.getPiiCategoryDAO(this.piiCategoryDAOs).deletePIICategoriesByTenantId(tenantId);
        if (log.isDebugEnabled()) {
            log.debug((Object)("All PII categories deleted successfully for tenant: " + tenantId));
        }
    }

    @Override
    public boolean isPIICategoryExists(String name) throws ConsentManagementException {
        return this.getPiiCategoryFromName(name) != null;
    }

    @Override
    public AddReceiptResponse addConsent(ReceiptInput receiptInput) throws ConsentManagementException {
        this.validateInputParameters(receiptInput);
        receiptInput.setConsentReceiptId(this.generateConsentReceiptId());
        this.setAPIVersion(receiptInput);
        this.setPIIControllerInfo(receiptInput);
        if (!this.isUserNameCaseSensitive(receiptInput.getPiiPrincipalId())) {
            receiptInput.setPiiPrincipalId(this.getLowerCaseUserName(receiptInput.getPiiPrincipalId()));
        }
        this.getReceiptsDAO(this.receiptDAOs).addReceipt(receiptInput);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Consent stored successfully with the Id: " + receiptInput.getConsentReceiptId()));
        }
        return new AddReceiptResponse(receiptInput.getConsentReceiptId(), receiptInput.getCollectionMethod(), receiptInput.getLanguage(), receiptInput.getPiiPrincipalId(), receiptInput.getTenantDomain());
    }

    @Override
    public Receipt getReceipt(String receiptId) throws ConsentManagementException {
        Receipt receipt = this.getReceiptsDAO(this.receiptDAOs).getReceipt(receiptId);
        if (receipt == null || receipt.getConsentReceiptId() == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("No receipt found with the Id: " + receiptId));
            }
            String message = String.format(ConsentConstants.ErrorMessages.ERROR_CODE_RECEIPT_ID_INVALID.getMessage(), receiptId) + " in tenant: " + ConsentUtils.getTenantDomainFromCarbonContext();
            throw new ConsentManagementClientException(message, ConsentConstants.ErrorMessages.ERROR_CODE_RECEIPT_ID_INVALID.getCode());
        }
        this.populateTenantDomain(receipt);
        this.setPIIControllerInfo(receipt);
        this.setPublicKey(receipt);
        return receipt;
    }

    @Override
    public List<ReceiptListResponse> searchReceipts(int limit, int offset, String piiPrincipalId, String spTenantDomain, String service, String state) throws ConsentManagementException {
        this.validatePaginationParameters(limit, offset);
        if (limit == 0) {
            limit = this.getDefaultLimitFromConfig();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Limit is not defied the request, default to: " + limit));
            }
        }
        String piiPrincipalTenantId = ConsentUtils.getTenantDomainFromCarbonContext();
        List<ReceiptListResponse> receiptListResponses = this.searchReceipts(limit, offset, piiPrincipalId, spTenantDomain, service, state, piiPrincipalTenantId);
        receiptListResponses.forEach(LambdaExceptionUtils.rethrowConsumer(receiptListResponse -> receiptListResponse.setTenantDomain(ConsentUtils.getTenantDomain(this.realmService, receiptListResponse.getTenantId()))));
        return receiptListResponses;
    }

    @Override
    public List<ReceiptListResponse> searchReceipts(int limit, int offset, String piiPrincipalId, String spTenantDomain, String service, String state, String principleTenantDomain) throws ConsentManagementException {
        int spTenantId = 0;
        int principalTenantId = 0;
        if (StringUtils.isNotBlank((String)spTenantDomain)) {
            spTenantId = ConsentUtils.getTenantId(this.realmService, spTenantDomain);
        }
        if (StringUtils.isNotBlank((String)principleTenantDomain)) {
            principalTenantId = ConsentUtils.getTenantId(this.realmService, principleTenantDomain);
        }
        this.validatePaginationParameters(limit, offset);
        if (limit == 0) {
            limit = this.getDefaultLimitFromConfig();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Limit is not defied the request, default to: " + limit));
            }
        }
        if (!this.isUserNameCaseSensitive(piiPrincipalId)) {
            piiPrincipalId = this.getLowerCaseUserName(piiPrincipalId);
        }
        List<ReceiptListResponse> receiptListResponses = this.getReceiptsDAO(this.receiptDAOs).searchReceipts(limit, offset, piiPrincipalId, spTenantId, service, state, principalTenantId);
        receiptListResponses.forEach(LambdaExceptionUtils.rethrowConsumer(receiptListResponse -> receiptListResponse.setTenantDomain(ConsentUtils.getTenantDomain(this.realmService, receiptListResponse.getTenantId()))));
        return receiptListResponses;
    }

    @Override
    public void revokeReceipt(String receiptId) throws ConsentManagementException {
        this.getReceiptsDAO(this.receiptDAOs).revokeReceipt(receiptId);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Receipt revoked successfully with the Id: " + receiptId));
        }
    }

    @Override
    public void deleteReceipt(String receiptId) throws ConsentManagementException {
        this.getReceiptsDAO(this.receiptDAOs).deleteReceipt(receiptId);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Receipt deleted successfully with the Id: " + receiptId));
        }
    }

    @Override
    public void deleteReceipts(int tenantId) throws ConsentManagementException {
        if (tenantId <= 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Tenant id is not found in the request or invalid tenant id: " + tenantId));
            }
            throw ConsentUtils.handleClientException(ConsentConstants.ErrorMessages.ERROR_CODE_TENANT_ID_REQUIRED, null);
        }
        this.getReceiptsDAO(this.receiptDAOs).deleteReceiptsByTenantId(tenantId);
        if (log.isDebugEnabled()) {
            log.debug((Object)("All receipts deleted successfully for tenant: " + tenantId));
        }
    }

    @Override
    public boolean isReceiptExist(String receiptId, String tenantAwareUsername, int tenantId) throws ConsentManagementException {
        if (!this.isUserNameCaseSensitive(tenantAwareUsername)) {
            tenantAwareUsername = this.getLowerCaseUserName(tenantAwareUsername);
        }
        return this.getReceiptsDAO(this.receiptDAOs).isReceiptExist(receiptId, tenantAwareUsername, tenantId);
    }

    private Purpose getPurposeFromName(String name, String group, String groupType) throws ConsentManagementException {
        return this.getPurposeDAO(this.purposeDAOs).getPurposeByName(name, group, groupType, ConsentUtils.getTenantIdFromCarbonContext());
    }

    private PIIController getPIIController(List<PIIController> piiControllers) throws ConsentManagementServerException {
        if (CollectionUtils.isNotEmpty(piiControllers)) {
            return piiControllers.get(piiControllers.size() - 1);
        }
        throw ConsentUtils.handleServerException(ConsentConstants.ErrorMessages.ERROR_CODE_GET_DAO, PII_CONTROLLER);
    }

    private void setPublicKey(Receipt receipt) throws ConsentManagementException {
        String publicKey = this.getPublicKey(receipt.getTenantDomain());
        receipt.setPublicKey(publicKey);
    }

    private PIICategory getPiiCategoryById(int piiCategoryId) throws ConsentManagementException {
        return this.getPiiCategoryDAO(this.piiCategoryDAOs).getPIICategoryById(piiCategoryId);
    }

    private PurposeCategory getPurposeCategoryFromName(String name) throws ConsentManagementException {
        return this.getPurposeCategoryDAO(this.purposeCategoryDAOs).getPurposeCategoryByName(name, ConsentUtils.getTenantIdFromCarbonContext());
    }

    private PurposeCategory getPurposeCategoryById(int purposeCategoryId) throws ConsentManagementException {
        return this.getPurposeCategoryDAO(this.purposeCategoryDAOs).getPurposeCategoryById(purposeCategoryId);
    }

    private PIICategory getPiiCategoryFromName(String name) throws ConsentManagementException {
        return this.getPiiCategoryDAO(this.piiCategoryDAOs).getPIICategoryByName(name, ConsentUtils.getTenantIdFromCarbonContext());
    }

    private ReceiptDAO getReceiptsDAO(List<ReceiptDAO> receiptDAOs) throws ConsentManagementServerException {
        if (CollectionUtils.isNotEmpty(receiptDAOs)) {
            return receiptDAOs.get(receiptDAOs.size() - 1);
        }
        throw ConsentUtils.handleServerException(ConsentConstants.ErrorMessages.ERROR_CODE_GET_DAO, RECEIPT_DAO);
    }

    private Purpose getPurposeById(int purposeId) throws ConsentManagementException {
        return this.getPurposeDAO(this.purposeDAOs).getPurposeById(purposeId);
    }

    private PIICategoryDAO getPiiCategoryDAO(List<PIICategoryDAO> piiCategoryDAOs) throws ConsentManagementServerException {
        if (CollectionUtils.isNotEmpty(piiCategoryDAOs)) {
            return piiCategoryDAOs.get(piiCategoryDAOs.size() - 1);
        }
        throw ConsentUtils.handleServerException(ConsentConstants.ErrorMessages.ERROR_CODE_GET_DAO, PII_CATEGORY_DAO);
    }

    private PurposeCategoryDAO getPurposeCategoryDAO(List<PurposeCategoryDAO> purposeCategoryDAOs) throws ConsentManagementServerException {
        if (CollectionUtils.isNotEmpty(purposeCategoryDAOs)) {
            return purposeCategoryDAOs.get(purposeCategoryDAOs.size() - 1);
        }
        throw ConsentUtils.handleServerException(ConsentConstants.ErrorMessages.ERROR_CODE_GET_DAO, PURPOSE_CATEGORY_DAO);
    }

    private PurposeDAO getPurposeDAO(List<PurposeDAO> purposeDAOs) throws ConsentManagementServerException {
        if (CollectionUtils.isNotEmpty(purposeDAOs)) {
            return purposeDAOs.get(purposeDAOs.size() - 1);
        }
        throw ConsentUtils.handleServerException(ConsentConstants.ErrorMessages.ERROR_CODE_GET_DAO, PURPOSE_DAO);
    }

    protected void setAPIVersion(ReceiptInput receiptInput) {
        receiptInput.setVersion("KI-CR-v1.1.0");
    }

    protected String generateConsentReceiptId() {
        String consentId = UUID.randomUUID().toString();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Consent receipt Id generated: " + consentId));
        }
        return consentId;
    }

    private void setPIIControllerInfo(Receipt receipt) {
        JSONObject controller = new JSONObject(receipt.getPiiController());
        Address piiAddress = this.getAddress(controller);
        PiiController piiController = this.getPiiController(controller, piiAddress);
        List<PiiController> piiControllers = Arrays.asList(piiController);
        receipt.setPiiControllers(piiControllers);
    }

    private PiiController getPiiController(JSONObject controller, Address piiAddress) {
        String piiControllerName = controller.optString("piiController");
        boolean piiControllerOnBehalf = controller.getBoolean("onBehalf");
        String piiControllerContact = controller.optString("contact");
        String piiControllerEmail = controller.optString("email");
        String piiControllerPhone = controller.optString("phone");
        String piiControllerURL = controller.optString("piiControllerUrl");
        return new PiiController(piiControllerName, piiControllerOnBehalf, piiControllerContact, piiControllerEmail, piiControllerPhone, piiControllerURL, piiAddress);
    }

    private Address getAddress(JSONObject controller) {
        JSONObject address = controller.optJSONObject("Address");
        String addressCountry = address.optString("addressCountry");
        String addressLocality = address.optString("addressLocality");
        String addressRegion = address.optString("addressRegion");
        String addressPostOfficeBoxNumber = address.optString("postOfficeBoxNumber");
        String addressPostCode = address.optString("postalCode");
        String addressStreetAddress = address.optString("streetAddress");
        return new Address(addressCountry, addressLocality, addressRegion, addressPostOfficeBoxNumber, addressPostCode, addressStreetAddress);
    }

    private void setPIIControllerInfo(ReceiptInput receipt) throws ConsentManagementException {
        PiiController controllerInfo = this.getPIIController(this.piiControllers).getControllerInfo(receipt.getTenantDomain());
        JSONObject controller = new JSONObject();
        controller.put("piiController", (Object)controllerInfo.getPiiController());
        controller.put("onBehalf", controllerInfo.isOnBehalf());
        controller.put("contact", (Object)controllerInfo.getContact());
        controller.put("email", (Object)controllerInfo.getEmail());
        controller.put("phone", (Object)controllerInfo.getPhone());
        controller.put("piiControllerUrl", (Object)controllerInfo.getPiiControllerUrl());
        Address piiAddress = controllerInfo.getAddress();
        if (piiAddress != null) {
            JSONObject address = new JSONObject();
            address.put("addressCountry", (Object)piiAddress.getAddressCountry());
            address.put("addressLocality", (Object)piiAddress.getAddressLocality());
            address.put("addressRegion", (Object)piiAddress.getAddressRegion());
            address.put("postOfficeBoxNumber", (Object)piiAddress.getPostOfficeBoxNumber());
            address.put("postalCode", (Object)piiAddress.getPostalCode());
            address.put("streetAddress", (Object)piiAddress.getStreetAddress());
            controller.put("Address", (Object)address);
        }
        receipt.setPiiControllerInfo(controller.toString());
    }

    private String getPublicKey(String tenantDomain) throws ConsentManagementException {
        int tenantId = ConsentUtils.getTenantId(this.realmService, tenantDomain);
        try {
            PublicKey publicKey;
            KeyStoreManager keyStoreManager = KeyStoreManager.getInstance((int)tenantId);
            if (this.isNotSuperTenant(tenantDomain)) {
                String jksName = this.getJKSName(tenantDomain);
                publicKey = this.getPublicKey(tenantDomain, keyStoreManager, jksName);
            } else {
                publicKey = keyStoreManager.getDefaultPublicKey();
            }
            byte[] data = publicKey.getEncoded();
            return Base64.encode((byte[])data);
        }
        catch (Exception e) {
            throw ConsentUtils.handleServerException(ConsentConstants.ErrorMessages.ERROR_CODE_GETTING_PUBLIC_CERT, tenantDomain);
        }
    }

    private PublicKey getPublicKey(String tenantDomain, KeyStoreManager keyStoreManager, String jksName) throws Exception {
        return keyStoreManager.getKeyStore(jksName).getCertificate(tenantDomain).getPublicKey();
    }

    private String getJKSName(String tenantDomain) {
        String ksName = tenantDomain.trim().replace(".", "-");
        return ksName + ".jks";
    }

    private boolean isNotSuperTenant(String tenantDomain) {
        return !"carbon.super".equals(tenantDomain);
    }

    private void validateInputParameters(ReceiptInput receiptInput) throws ConsentManagementException {
        if (StringUtils.isBlank((String)receiptInput.getPiiPrincipalId())) {
            receiptInput.setPiiPrincipalId(PrivilegedCarbonContext.getThreadLocalCarbonContext().getUsername());
        }
        if (StringUtils.isBlank((String)receiptInput.getTenantDomain())) {
            receiptInput.setTenantId(ConsentUtils.getTenantIdFromCarbonContext());
            receiptInput.setTenantDomain(ConsentUtils.getTenantDomainFromCarbonContext());
        } else {
            receiptInput.setTenantId(ConsentUtils.getTenantId(this.realmService, receiptInput.getTenantDomain()));
        }
        this.validateRequiredParametersInConsent(receiptInput);
        receiptInput.getServices().forEach(LambdaExceptionUtils.rethrowConsumer(receiptServiceInput -> {
            this.validateRequiredParametersInService((ReceiptServiceInput)receiptServiceInput);
            receiptServiceInput.getPurposes().forEach(LambdaExceptionUtils.rethrowConsumer(receiptPurposeInput -> this.validateRequiredParametersInPurpose((ReceiptServiceInput)receiptServiceInput, (ReceiptPurposeInput)receiptPurposeInput)));
        }));
        if (log.isDebugEnabled()) {
            log.debug((Object)"Consent adding request validation success");
        }
    }

    private void validateRequiredParametersInConsent(ReceiptInput receiptInput) throws ConsentManagementClientException {
        if (StringUtils.isBlank((String)receiptInput.getPiiPrincipalId())) {
            throw ConsentUtils.handleClientException(ConsentConstants.ErrorMessages.ERROR_CODE_PII_PRINCIPAL_ID_REQUIRED, null);
        }
        if (StringUtils.isBlank((String)receiptInput.getCollectionMethod())) {
            throw ConsentUtils.handleClientException(ConsentConstants.ErrorMessages.ERROR_CODE_PII_COLLECTION_METHOD_REQUIRED, null);
        }
        if (CollectionUtils.isEmpty(receiptInput.getServices())) {
            throw ConsentUtils.handleClientException(ConsentConstants.ErrorMessages.ERROR_CODE_AT_LEAST_ONE_SERVICE_REQUIRED, null);
        }
    }

    private void validateRequiredParametersInService(ReceiptServiceInput receiptServiceInput) throws ConsentManagementException {
        if (StringUtils.isBlank((String)receiptServiceInput.getService())) {
            throw ConsentUtils.handleClientException(ConsentConstants.ErrorMessages.ERROR_CODE_SERVICE_NAME_REQUIRED, null);
        }
        if (CollectionUtils.isEmpty(receiptServiceInput.getPurposes())) {
            throw ConsentUtils.handleClientException(ConsentConstants.ErrorMessages.ERROR_CODE_AT_LEAST_ONE_PURPOSE_REQUIRED, null);
        }
        if (StringUtils.isBlank((String)receiptServiceInput.getTenantDomain())) {
            receiptServiceInput.setTenantId(ConsentUtils.getTenantIdFromCarbonContext());
            receiptServiceInput.setTenantDomain(ConsentUtils.getTenantDomainFromCarbonContext());
        } else {
            receiptServiceInput.setTenantId(ConsentUtils.getTenantId(this.realmService, receiptServiceInput.getTenantDomain()));
        }
    }

    private void validateRequiredParametersInPurpose(ReceiptServiceInput receiptServiceInput, ReceiptPurposeInput receiptPurposeInput) throws ConsentManagementException {
        String serviceName = receiptServiceInput.getService();
        if (receiptPurposeInput.getPurposeId() == null) {
            throw ConsentUtils.handleClientException(ConsentConstants.ErrorMessages.ERROR_CODE_PURPOSE_ID_MANDATORY, serviceName);
        }
        Purpose purpose = this.getPurpose(receiptPurposeInput.getPurposeId());
        receiptPurposeInput.setPurposeName(purpose.getName());
        if (StringUtils.isBlank((String)receiptPurposeInput.getConsentType())) {
            throw ConsentUtils.handleClientException(ConsentConstants.ErrorMessages.ERROR_CODE_CONSENT_TYPE_MANDATORY, serviceName);
        }
        if (CollectionUtils.isEmpty(receiptPurposeInput.getPurposeCategoryId())) {
            throw ConsentUtils.handleClientException(ConsentConstants.ErrorMessages.ERROR_CODE_AT_LEAST_ONE_CATEGORY_ID_REQUIRED, serviceName);
        }
        receiptPurposeInput.getPurposeCategoryId().forEach(LambdaExceptionUtils.rethrowConsumer(this::getPurposeCategory));
        if (CollectionUtils.isEmpty(receiptPurposeInput.getPiiCategory())) {
            throw ConsentUtils.handleClientException(ConsentConstants.ErrorMessages.ERROR_CODE_AT_LEAST_ONE_PII_CATEGORY_ID_REQUIRED, serviceName);
        }
        receiptPurposeInput.getPiiCategory().forEach(LambdaExceptionUtils.rethrowConsumer(piiCategoryValidity -> this.getPIICategory(piiCategoryValidity.getId())));
        if (receiptPurposeInput.isPrimaryPurpose() == null) {
            throw ConsentUtils.handleClientException(ConsentConstants.ErrorMessages.ERROR_CODE_IS_PRIMARY_PURPOSE_IS_REQUIRED, serviceName);
        }
        if (StringUtils.isBlank((String)receiptPurposeInput.getTermination())) {
            throw ConsentUtils.handleClientException(ConsentConstants.ErrorMessages.ERROR_CODE_TERMINATION_IS_REQUIRED, serviceName);
        }
        if (receiptPurposeInput.isThirdPartyDisclosure() == null) {
            throw ConsentUtils.handleClientException(ConsentConstants.ErrorMessages.ERROR_CODE_THIRD_PARTY_DISCLOSURE_IS_REQUIRED, serviceName);
        }
    }

    private int getDefaultLimitFromConfig() {
        int limit = 100;
        if (this.configParser.getConfiguration().get("SearchLimits.Purpose") != null) {
            limit = Integer.parseInt(this.configParser.getConfiguration().get("SearchLimits.Purpose").toString());
        }
        return limit;
    }

    private void validatePaginationParameters(int limit, int offset) throws ConsentManagementClientException {
        if (limit < 0 || offset < 0) {
            throw ConsentUtils.handleClientException(ConsentConstants.ErrorMessages.ERROR_CODE_INVALID_ARGUMENTS_FOR_LIM_OFFSET, null);
        }
    }

    private void validateInputParameters(PurposeCategory purposeCategory) throws ConsentManagementException {
        if (StringUtils.isBlank((String)purposeCategory.getName())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Purpose Category name cannot be empty");
            }
            throw ConsentUtils.handleClientException(ConsentConstants.ErrorMessages.ERROR_CODE_PURPOSE_CATEGORY_NAME_REQUIRED, null);
        }
        if (this.isPurposeCategoryExists(purposeCategory.getName())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("A purpose category already exists with name: " + purposeCategory.getName()));
            }
            throw ConsentUtils.handleClientException(ConsentConstants.ErrorMessages.ERROR_CODE_PURPOSE_CATEGORY_ALREADY_EXIST, purposeCategory.getName());
        }
        if (StringUtils.isBlank((String)purposeCategory.getTenantDomain())) {
            purposeCategory.setTenantId(ConsentUtils.getTenantIdFromCarbonContext());
            purposeCategory.setTenantDomain(ConsentUtils.getTenantDomainFromCarbonContext());
        } else {
            purposeCategory.setTenantId(ConsentUtils.getTenantId(this.realmService, purposeCategory.getTenantDomain()));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("PurposeCategory request validation success: " + purposeCategory.getName()));
        }
    }

    private void validateInputParameters(Purpose purpose) throws ConsentManagementException {
        if (StringUtils.isBlank((String)purpose.getName())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Purpose name cannot be empty");
            }
            throw ConsentUtils.handleClientException(ConsentConstants.ErrorMessages.ERROR_CODE_PURPOSE_NAME_REQUIRED, null);
        }
        if (this.isPurposeExists(purpose.getName(), purpose.getGroup(), purpose.getGroupType())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("A purpose already exists with name: " + purpose.getName()));
            }
            throw ConsentUtils.handleClientException(ConsentConstants.ErrorMessages.ERROR_CODE_PURPOSE_ALREADY_EXIST, purpose.getName());
        }
        if (StringUtils.isBlank((String)purpose.getGroup())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Purpose group is empty for: " + purpose.getName()));
            }
            throw ConsentUtils.handleClientException(ConsentConstants.ErrorMessages.ERROR_CODE_PURPOSE_GROUP_REQUIRED, null);
        }
        if (StringUtils.isBlank((String)purpose.getGroupType())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Purpose group type is empty for: " + purpose.getName()));
            }
            throw ConsentUtils.handleClientException(ConsentConstants.ErrorMessages.ERROR_CODE_PURPOSE_GROUP_TYPE_REQUIRED, null);
        }
        if (StringUtils.isBlank((String)purpose.getTenantDomain())) {
            purpose.setTenantId(ConsentUtils.getTenantIdFromCarbonContext());
            purpose.setTenantDomain(ConsentUtils.getTenantDomainFromCarbonContext());
        } else {
            purpose.setTenantId(ConsentUtils.getTenantId(this.realmService, purpose.getTenantDomain()));
        }
        if (CollectionUtils.isNotEmpty(purpose.getPurposePIICategories())) {
            purpose.getPurposePIICategories().forEach(LambdaExceptionUtils.rethrowConsumer(purposePIICategory -> {
                int id = purposePIICategory.getId();
                if (this.getPiiCategoryById(id) == null) {
                    throw ConsentUtils.handleClientException(ConsentConstants.ErrorMessages.ERROR_CODE_PII_CATEGORY_ID_INVALID, String.valueOf(id));
                }
                if (purposePIICategory.getMandatory() == null) {
                    throw ConsentUtils.handleClientException(ConsentConstants.ErrorMessages.ERROR_CODE_PURPOSE_PII_CONSTRAINT_REQUIRED, String.valueOf(id));
                }
            }));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Purpose request validation success: " + purpose.getName()));
        }
    }

    private void validateInputParameters(PIICategory piiCategory) throws ConsentManagementException {
        if (StringUtils.isBlank((String)piiCategory.getName())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"PII Category name cannot be empty");
            }
            throw ConsentUtils.handleClientException(ConsentConstants.ErrorMessages.ERROR_CODE_PII_CATEGORY_NAME_REQUIRED, null);
        }
        if (this.isPIICategoryExists(piiCategory.getName())) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("A PII Category already exists with name: " + piiCategory.getName()));
            }
            throw ConsentUtils.handleClientException(ConsentConstants.ErrorMessages.ERROR_CODE_PII_CATEGORY_ALREADY_EXIST, piiCategory.getName());
        }
        if (piiCategory.getSensitive() == null) {
            piiCategory.setSensitive(false);
        }
        if (StringUtils.isBlank((String)piiCategory.getTenantDomain())) {
            piiCategory.setTenantId(ConsentUtils.getTenantIdFromCarbonContext());
            piiCategory.setTenantDomain(ConsentUtils.getTenantDomainFromCarbonContext());
        } else {
            piiCategory.setTenantId(ConsentUtils.getTenantId(this.realmService, piiCategory.getTenantDomain()));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("PII category request validation success: " + piiCategory.getName()));
        }
    }

    private void populateTenantDomain(Receipt receipt) throws ConsentManagementServerException {
        receipt.setTenantDomain(ConsentUtils.getTenantDomain(this.realmService, receipt.getTenantId()));
        receipt.getServices().forEach(LambdaExceptionUtils.rethrowConsumer(receiptService -> receiptService.setTenantDomain(ConsentUtils.getTenantDomain(this.realmService, receiptService.getTenantId()))));
    }

    private Purpose populatePiiCategories(Purpose purposeResponse) {
        ArrayList<PurposePIICategory> purposePIICategories = new ArrayList<PurposePIICategory>();
        purposeResponse.getPurposePIICategories().forEach(LambdaExceptionUtils.rethrowConsumer(piiCategory -> purposePIICategories.add(this.getPurposePIICategory((PurposePIICategory)piiCategory))));
        purposeResponse.setPurposePIICategories(purposePIICategories);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Purpose created successfully with the name: " + purposeResponse.getName()));
        }
        return purposeResponse;
    }

    private PurposePIICategory getPurposePIICategory(PurposePIICategory purposePIICategory) throws ConsentManagementException {
        PIICategory piiCategory = this.getPiiCategoryById(purposePIICategory.getId());
        PurposePIICategory purposePIICategoryResult = new PurposePIICategory(piiCategory, purposePIICategory.getMandatory());
        return purposePIICategoryResult;
    }

    private boolean isUserNameCaseSensitive(String username) throws ConsentManagementException {
        try {
            UserStoreManager userStoreManager = null;
            UserRealm userRealm = this.getUserRealm();
            if (this.realmService != null && userRealm != null) {
                AbstractUserStoreManager abstractUserStoreManager = (AbstractUserStoreManager)userRealm.getUserStoreManager();
                if (abstractUserStoreManager != null) {
                    userStoreManager = abstractUserStoreManager.getSecondaryUserStoreManager(UserCoreUtil.extractDomainFromName((String)username));
                }
                if (userStoreManager != null && userStoreManager.getRealmConfiguration() != null) {
                    String useCaseSensitiveUsernameForCacheKeysProperty = userStoreManager.getRealmConfiguration().getUserStoreProperty(USE_CASE_SENSITIVE_USERNAME_FOR_CACHE_KEYS);
                    if (useCaseSensitiveUsernameForCacheKeysProperty != null) {
                        this.isCaseSensitiveUserName = Boolean.parseBoolean(useCaseSensitiveUsernameForCacheKeysProperty);
                        return this.isCaseSensitiveUserName;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)"User store property: UseCaseSensitiveUsernameForCacheKeys not configured. Considering username as case sensitive.");
                    }
                    return false;
                }
            }
        }
        catch (UserStoreException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Error while reading user store property: UseCaseSensitiveUsernameForCacheKeys. Considering username as case sensitive.");
            }
            throw ConsentUtils.handleServerException(ConsentConstants.ErrorMessages.ERROR_CODE_GETTING_USER_STORE_MANAGER, username, e);
        }
        return false;
    }

    private String getLowerCaseUserName(String userName) {
        if (userName != null) {
            String domainFreeName = UserCoreUtil.removeDomainFromName((String)userName);
            String domainName = UserCoreUtil.extractDomainFromName((String)userName);
            return UserCoreUtil.addDomainToName((String)domainFreeName.toLowerCase(), (String)domainName);
        }
        return null;
    }

    private UserRealm getUserRealm() throws ConsentManagementException {
        UserRealm userRealm;
        String tenantDomain = ConsentUtils.getTenantDomainFromCarbonContext();
        try {
            int tenantId = this.realmService.getTenantManager().getTenantId(tenantDomain);
            userRealm = this.realmService.getTenantUserRealm(tenantId);
        }
        catch (UserStoreException e) {
            throw ConsentUtils.handleServerException(ConsentConstants.ErrorMessages.ERROR_CODE_GETTING_TENANT_ID, tenantDomain, e);
        }
        return userRealm;
    }
}

