/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.consent.mgt.core.dao.impl;

import java.sql.Timestamp;
import java.time.ZoneOffset;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.consent.mgt.core.constant.ConsentConstants;
import org.wso2.carbon.consent.mgt.core.dao.ReceiptDAO;
import org.wso2.carbon.consent.mgt.core.exception.ConsentManagementException;
import org.wso2.carbon.consent.mgt.core.exception.ConsentManagementServerException;
import org.wso2.carbon.consent.mgt.core.model.ConsentPurpose;
import org.wso2.carbon.consent.mgt.core.model.PIICategoryValidity;
import org.wso2.carbon.consent.mgt.core.model.Receipt;
import org.wso2.carbon.consent.mgt.core.model.ReceiptContext;
import org.wso2.carbon.consent.mgt.core.model.ReceiptInput;
import org.wso2.carbon.consent.mgt.core.model.ReceiptListResponse;
import org.wso2.carbon.consent.mgt.core.model.ReceiptPurposeInput;
import org.wso2.carbon.consent.mgt.core.model.ReceiptService;
import org.wso2.carbon.consent.mgt.core.model.ReceiptServiceInput;
import org.wso2.carbon.consent.mgt.core.util.ConsentUtils;
import org.wso2.carbon.consent.mgt.core.util.JdbcUtils;
import org.wso2.carbon.consent.mgt.core.util.LambdaExceptionUtils;
import org.wso2.carbon.database.utils.jdbc.JdbcTemplate;
import org.wso2.carbon.database.utils.jdbc.exceptions.DataAccessException;
import org.wso2.carbon.database.utils.jdbc.exceptions.TransactionException;

public class ReceiptDAOImpl
implements ReceiptDAO {
    private static final String SQL_FILTER_STRING_ANY = "%";
    private static final String QUERY_FILTER_STRING_ANY = "*";
    private static final String QUERY_FILTER_STRING_ANY_ESCAPED = "\\*";
    private static final Log log = LogFactory.getLog(ReceiptDAOImpl.class);

    @Override
    public int getPriority() {
        return 1;
    }

    @Override
    public void addReceipt(ReceiptInput receiptInput) throws ConsentManagementException {
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        try {
            jdbcTemplate.withTransaction(template -> {
                this.revokeActiveReceipts(receiptInput);
                this.addReceiptInfo(receiptInput);
                receiptInput.getServices().forEach(LambdaExceptionUtils.rethrowConsumer(receiptServiceInput -> {
                    int receiptToSPAssocId = this.addReceiptSPAssociation(receiptInput.getConsentReceiptId(), (ReceiptServiceInput)receiptServiceInput);
                    receiptServiceInput.getPurposes().forEach(LambdaExceptionUtils.rethrowConsumer(receiptPurposeInput -> {
                        int spToPurposeAssocId = this.addSpToPurposeAssociation(receiptToSPAssocId, (ReceiptPurposeInput)receiptPurposeInput);
                        receiptPurposeInput.getPurposeCategoryId().forEach(LambdaExceptionUtils.rethrowConsumer(id -> this.addSpPurposeToPurposeCategoryAssociation(spToPurposeAssocId, (int)id)));
                        receiptPurposeInput.getPiiCategory().forEach(LambdaExceptionUtils.rethrowConsumer(piiCategoryValidity -> this.addSpPurposeToPiiCategoryAssociation(spToPurposeAssocId, piiCategoryValidity.getId(), piiCategoryValidity.getValidity())));
                    }));
                }));
                if (receiptInput.getProperties() != null) {
                    this.addReceiptProperties(receiptInput.getConsentReceiptId(), receiptInput.getProperties());
                }
                return null;
            });
        }
        catch (TransactionException e) {
            throw ConsentUtils.handleServerException(ConsentConstants.ErrorMessages.ERROR_CODE_ADD_CONSENT_RECEIPT, receiptInput.getPiiPrincipalId(), e);
        }
    }

    private void revokeActiveReceipts(ReceiptInput receiptInput) throws ConsentManagementServerException {
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        try {
            jdbcTemplate.withTransaction(template -> {
                receiptInput.getServices().forEach(LambdaExceptionUtils.rethrowConsumer(receiptServiceInput -> {
                    List ids = template.executeQuery("SELECT R.CONSENT_RECEIPT_ID FROM CM_RECEIPT R INNER JOIN CM_RECEIPT_SP_ASSOC RA ON R.CONSENT_RECEIPT_ID=RA.CONSENT_RECEIPT_ID WHERE R.PII_PRINCIPAL_ID= ? AND RA.SP_NAME=? AND R.PRINCIPAL_TENANT_ID=? AND RA.SP_TENANT_ID=? AND R.STATE='ACTIVE'", (resultSet, rowNumber) -> resultSet.getString(1), preparedStatement -> {
                        preparedStatement.setString(1, receiptInput.getPiiPrincipalId());
                        preparedStatement.setString(2, receiptServiceInput.getService());
                        preparedStatement.setInt(3, receiptInput.getTenantId());
                        preparedStatement.setInt(4, receiptServiceInput.getTenantId());
                    });
                    if (CollectionUtils.isNotEmpty((Collection)ids)) {
                        ids.forEach(LambdaExceptionUtils.rethrowConsumer(id -> {
                            this.revokeReceipt((String)id);
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Revoked active receipt: " + id + " of the user: " + receiptInput.getPiiPrincipalId()));
                            }
                        }));
                    }
                }));
                return null;
            });
        }
        catch (TransactionException e) {
            throw ConsentUtils.handleServerException(ConsentConstants.ErrorMessages.ERROR_CODE_REVOKE_ACTIVE_RECEIPT, receiptInput.getPiiPrincipalId(), e);
        }
    }

    @Override
    public Receipt getReceipt(String receiptId) throws ConsentManagementException {
        Receipt receipt;
        ReceiptContext receiptContext = new ReceiptContext();
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        try {
            receipt = (Receipt)jdbcTemplate.withTransaction(template -> {
                Receipt internalReceipt = (Receipt)template.fetchSingleRecord("SELECT VERSION,JURISDICTION,CONSENT_TIMESTAMP,COLLECTION_METHOD,LANGUAGE,PII_PRINCIPAL_ID,PRINCIPAL_TENANT_ID,POLICY_URL,STATE,PII_CONTROLLER FROM CM_RECEIPT WHERE CONSENT_RECEIPT_ID =?", (resultSet, rowNumber) -> {
                    Receipt receiptInfo = new Receipt();
                    receiptInfo.setConsentReceiptId(receiptId);
                    receiptInfo.setVersion(resultSet.getString(1));
                    receiptInfo.setJurisdiction(resultSet.getString(2));
                    receiptInfo.setConsentTimestamp(resultSet.getTimestamp(3).getTime());
                    receiptInfo.setCollectionMethod(resultSet.getString(4));
                    receiptInfo.setLanguage(resultSet.getString(5));
                    receiptInfo.setPiiPrincipalId(resultSet.getString(6));
                    receiptInfo.setTenantId(resultSet.getInt(7));
                    receiptInfo.setPolicyUrl(resultSet.getString(8));
                    receiptInfo.setState(resultSet.getString(9));
                    receiptInfo.setPiiController(resultSet.getString(10));
                    return receiptInfo;
                }, preparedStatement -> preparedStatement.setString(1, receiptId));
                if (internalReceipt != null) {
                    internalReceipt.setServices(this.getServiceInfoOfReceipt(receiptId, receiptContext));
                    this.setReceiptSensitivity(receiptContext, internalReceipt);
                }
                return internalReceipt;
            });
        }
        catch (TransactionException e) {
            throw ConsentUtils.handleServerException(ConsentConstants.ErrorMessages.ERROR_CODE_RETRIEVE_RECEIPT_INFO, String.valueOf(receiptId), e);
        }
        return receipt;
    }

    @Override
    public boolean isReceiptExist(String receiptId, String piiPrincipalId, int tenantId) throws ConsentManagementException {
        try {
            JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
            String receipt = (String)jdbcTemplate.withTransaction(template -> (String)template.fetchSingleRecord("SELECT PII_PRINCIPAL_ID FROM CM_RECEIPT WHERE CONSENT_RECEIPT_ID =? AND PII_PRINCIPAL_ID =? AND PRINCIPAL_TENANT_ID = ?", (resultSet, rowNumber) -> resultSet.getString(1), preparedStatement -> {
                preparedStatement.setString(1, receiptId);
                preparedStatement.setString(2, piiPrincipalId);
                preparedStatement.setInt(3, tenantId);
            }));
            return receipt != null;
        }
        catch (TransactionException e) {
            throw ConsentUtils.handleServerException(ConsentConstants.ErrorMessages.ERROR_CODE_RETRIEVE_RECEIPT_EXISTENCE, "Receipt Id: " + receiptId + ", PII Principal Id: " + piiPrincipalId + "and Tenant Id: " + tenantId, e);
        }
    }

    @Override
    public void revokeReceipt(String receiptId) throws ConsentManagementException {
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        try {
            jdbcTemplate.withTransaction(template -> {
                template.executeUpdate("UPDATE CM_RECEIPT SET STATE = ? WHERE CONSENT_RECEIPT_ID = ?", preparedStatement -> {
                    preparedStatement.setString(1, "REVOKED");
                    preparedStatement.setString(2, receiptId);
                });
                return null;
            });
        }
        catch (TransactionException e) {
            throw ConsentUtils.handleServerException(ConsentConstants.ErrorMessages.ERROR_CODE_REVOKE_RECEIPT, receiptId, e);
        }
    }

    @Override
    public List<ReceiptListResponse> searchReceipts(int limit, int offset, String piiPrincipalId, int spTenantId, String service, String state, int principalTenantId) throws ConsentManagementException {
        List<ReceiptListResponse> receiptListResponses;
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        try {
            int piiPrincipalTenantId = ConsentUtils.getTenantIdFromCarbonContext();
            if (piiPrincipalId == null) {
                piiPrincipalId = SQL_FILTER_STRING_ANY;
            } else if (piiPrincipalId.contains(QUERY_FILTER_STRING_ANY)) {
                piiPrincipalId = piiPrincipalId.replaceAll(QUERY_FILTER_STRING_ANY_ESCAPED, SQL_FILTER_STRING_ANY);
            }
            if (service == null) {
                service = SQL_FILTER_STRING_ANY;
            } else if (service.contains(QUERY_FILTER_STRING_ANY)) {
                service = service.replaceAll(QUERY_FILTER_STRING_ANY_ESCAPED, SQL_FILTER_STRING_ANY);
            }
            if (state == null) {
                state = SQL_FILTER_STRING_ANY;
            }
            String finalPiiPrincipalId = piiPrincipalId;
            String finalService = service;
            String finalState = state;
            receiptListResponses = spTenantId != 0 && principalTenantId != 0 ? this.searchReceipt(limit, offset, spTenantId, jdbcTemplate, piiPrincipalTenantId, finalPiiPrincipalId, finalService, finalState) : (spTenantId == 0 && principalTenantId != 0 ? this.searchWithoutSpTenant(limit, offset, jdbcTemplate, piiPrincipalTenantId, finalPiiPrincipalId, finalService, finalState) : (spTenantId != 0 && principalTenantId == 0 ? this.searchReceiptWithoutPrincipleTenant(limit, offset, spTenantId, jdbcTemplate, finalPiiPrincipalId, finalService, finalState) : this.searchWithoutPrincipleAndSPTenantDomain(limit, offset, jdbcTemplate, finalPiiPrincipalId, finalService, finalState)));
        }
        catch (DataAccessException e) {
            throw ConsentUtils.handleServerException(ConsentConstants.ErrorMessages.ERROR_CODE_SEARCH_RECEIPTS, piiPrincipalId, e);
        }
        return receiptListResponses;
    }

    protected List<ReceiptListResponse> searchReceipt(int limit, int offset, int spTenantId, JdbcTemplate jdbcTemplate, int piiPrincipalTenantId, String finalPiiPrincipalId, String finalService, String finalState) throws DataAccessException {
        int initialOffset;
        String query;
        if (JdbcUtils.isH2MySqlOrPostgresDB()) {
            query = "SELECT R.CONSENT_RECEIPT_ID, R.LANGUAGE, R.PII_PRINCIPAL_ID, R.PRINCIPAL_TENANT_ID, R.STATE,RS.SP_DISPLAY_NAME,RS.SP_DESCRIPTION FROM CM_RECEIPT R INNER JOIN CM_RECEIPT_SP_ASSOC RS ON R.CONSENT_RECEIPT_ID=RS.CONSENT_RECEIPT_ID WHERE PII_PRINCIPAL_ID LIKE ? AND PRINCIPAL_TENANT_ID=? AND SP_NAME LIKE ? AND SP_TENANT_ID = ? AND STATE LIKE ? ORDER BY ID  ASC LIMIT ? OFFSET ?";
        } else if (JdbcUtils.isDB2DB()) {
            query = "SELECT CONSENT_RECEIPT_ID, LANGUAGE, PII_PRINCIPAL_ID, PRINCIPAL_TENANT_ID,STATE,SP_DISPLAY_NAME,SP_DESCRIPTION FROM (SELECT R.CONSENT_RECEIPT_ID, R.LANGUAGE, R.PII_PRINCIPAL_ID, R.PRINCIPAL_TENANT_ID, RS.SP_DISPLAY_NAME,RS.SP_DESCRIPTION,R.STATE,ROW_NUMBER() OVER( ORDER BY R.CONSENT_RECEIPT_ID) AS ROWNUMBER FROM CM_RECEIPT R INNER JOIN CM_RECEIPT_SP_ASSOC RS ON  R.CONSENT_RECEIPT_ID = RS.CONSENT_RECEIPT_ID WHERE R.PII_PRINCIPAL_ID LIKE ? AND PRINCIPAL_TENANT_ID = ? AND RS.SP_NAME LIKE ? AND RS.SP_TENANT_ID LIKE ? AND R.STATE LIKE ?) AS X WHERE ROWNUMBER BETWEEN ? AND ?";
            initialOffset = offset;
            offset += limit;
            limit = initialOffset + 1;
        } else if (JdbcUtils.isMSSqlDB()) {
            initialOffset = offset;
            offset = limit + offset;
            limit = initialOffset + 1;
            query = "SELECT CONSENT_RECEIPT_ID, LANGUAGE, PII_PRINCIPAL_ID, PRINCIPAL_TENANT_ID, STATE, SP_DISPLAY_NAME, SP_DESCRIPTION FROM (SELECT R.CONSENT_RECEIPT_ID, R.LANGUAGE, R.PII_PRINCIPAL_ID, R.PRINCIPAL_TENANT_ID, R.STATE, RS.SP_DISPLAY_NAME, RS.SP_DESCRIPTION, ROW_NUMBER() OVER ( ORDER BY R.CONSENT_RECEIPT_ID) AS ROWNUM FROM CM_RECEIPT R INNER JOIN CM_RECEIPT_SP_ASSOC RS ON R.CONSENT_RECEIPT_ID = RS.CONSENT_RECEIPT_ID WHERE PII_PRINCIPAL_ID LIKE ? AND PRINCIPAL_TENANT_ID = ? AND SP_NAME LIKE ? AND SP_TENANT_ID LIKE ? AND STATE LIKE ?) AS RES WHERE RES.ROWNUM BETWEEN ? AND ?";
        } else if (JdbcUtils.isInformixDB()) {
            query = "SELECT R.CONSENT_RECEIPT_ID, R.LANGUAGE, R.PII_PRINCIPAL_ID, R.PRINCIPAL_TENANT_ID, R.STATE,RS.SP_DISPLAY_NAME,RS.SP_DESCRIPTION FROM CM_RECEIPT R INNER JOIN CM_RECEIPT_SP_ASSOC RS ON R.CONSENT_RECEIPT_ID=RS.CONSENT_RECEIPT_ID WHERE PII_PRINCIPAL_ID LIKE ? AND PRINCIPAL_TENANT_ID =? AND SP_NAME LIKE ? AND SP_TENANT_ID LIKE ? AND STATE LIKE ? ORDER BY ID  ASC LIMIT ? OFFSET ?";
        } else {
            query = "SELECT CONSENT_RECEIPT_ID, LANGUAGE,PII_PRINCIPAL_ID,  PRINCIPAL_TENANT_ID, STATE,SP_DISPLAY_NAME,SP_DESCRIPTION FROM (SELECT ROWNUM RNUM,A.* FROM( SELECT R.CONSENT_RECEIPT_ID, R.LANGUAGE,R.PII_PRINCIPAL_ID,R.PRINCIPAL_TENANT_ID, R.STATE,RS.SP_DISPLAY_NAME,RS.SP_DESCRIPTION FROM CM_RECEIPT R INNER JOIN CM_RECEIPT_SP_ASSOC RS ON R.CONSENT_RECEIPT_ID=RS.CONSENT_RECEIPT_ID WHERE PII_PRINCIPAL_ID LIKE ? AND PRINCIPAL_TENANT_ID = ? AND SP_NAME LIKE ? AND SP_TENANT_ID LIKE ? AND STATE LIKE ? ORDER BY R.CONSENT_RECEIPT_ID ) A WHERE  ROWNUM <= ? ) WHERE  RNUM > ?";
            limit = offset + limit;
        }
        int finalLimit = limit;
        int finalOffset = offset;
        List receiptListResponses = jdbcTemplate.executeQuery(query, (resultSet, rowNumber) -> new ReceiptListResponse(resultSet.getString(1), resultSet.getString(2), resultSet.getString(3), resultSet.getInt(4), resultSet.getString(5), resultSet.getString(6), resultSet.getString(7)), preparedStatement -> {
            preparedStatement.setString(1, finalPiiPrincipalId);
            preparedStatement.setInt(2, piiPrincipalTenantId);
            preparedStatement.setString(3, finalService);
            preparedStatement.setInt(4, spTenantId);
            preparedStatement.setString(5, finalState);
            preparedStatement.setInt(6, finalLimit);
            preparedStatement.setInt(7, finalOffset);
        });
        return receiptListResponses;
    }

    protected List<ReceiptListResponse> searchWithoutSpTenant(int limit, int offset, JdbcTemplate jdbcTemplate, int piiPrincipalTenantId, String finalPiiPrincipalId, String finalService, String finalState) throws DataAccessException {
        int initialOffset;
        String query;
        if (JdbcUtils.isH2MySqlOrPostgresDB()) {
            query = "SELECT R.CONSENT_RECEIPT_ID, R.LANGUAGE, R.PII_PRINCIPAL_ID, R.PRINCIPAL_TENANT_ID, R.STATE,RS.SP_DISPLAY_NAME,RS.SP_DESCRIPTION FROM CM_RECEIPT R INNER JOIN CM_RECEIPT_SP_ASSOC RS ON R.CONSENT_RECEIPT_ID=RS.CONSENT_RECEIPT_ID WHERE PII_PRINCIPAL_ID LIKE ? AND PRINCIPAL_TENANT_ID =? AND SP_NAME LIKE ? AND STATE LIKE ? ORDER BY ID  ASC LIMIT ? OFFSET ?";
        } else if (JdbcUtils.isDB2DB()) {
            query = "SELECT CONSENT_RECEIPT_ID, LANGUAGE, PII_PRINCIPAL_ID, PRINCIPAL_TENANT_ID,STATE,SP_DISPLAY_NAME,SP_DESCRIPTION  FROM (SELECT R.CONSENT_RECEIPT_ID, R.LANGUAGE, R.PII_PRINCIPAL_ID, R.PRINCIPAL_TENANT_ID, R.STATE,SP_DISPLAY_NAME,SP_DESCRIPTION, ROW_NUMBER() OVER( ORDER BY R.CONSENT_RECEIPT_ID) AS ROWNUMBER FROM CM_RECEIPT R INNER JOIN CM_RECEIPT_SP_ASSOC RS ON R.CONSENT_RECEIPT_ID = RS.CONSENT_RECEIPT_ID WHERE R.PII_PRINCIPAL_ID LIKE ? AND PRINCIPAL_TENANT_ID=? AND RS.SP_NAME LIKE ? AND R.STATE LIKE ?) AS X WHERE ROWNUMBER BETWEEN ? AND ?";
            initialOffset = offset;
            offset += limit;
            limit = initialOffset + 1;
        } else if (JdbcUtils.isMSSqlDB()) {
            initialOffset = offset;
            query = "SELECT CONSENT_RECEIPT_ID, LANGUAGE, PII_PRINCIPAL_ID, PRINCIPAL_TENANT_ID, STATE, SP_DISPLAY_NAME, SP_DESCRIPTION FROM (SELECT R.CONSENT_RECEIPT_ID, R.LANGUAGE, R.PII_PRINCIPAL_ID, R.PRINCIPAL_TENANT_ID, R.STATE, RS.SP_DISPLAY_NAME, RS.SP_DESCRIPTION, ROW_NUMBER() OVER ( ORDER BY R.CONSENT_RECEIPT_ID) AS ROWNUM FROM CM_RECEIPT R INNER JOIN CM_RECEIPT_SP_ASSOC RS ON R.CONSENT_RECEIPT_ID = RS.CONSENT_RECEIPT_ID WHERE PII_PRINCIPAL_ID LIKE ? AND PRINCIPAL_TENANT_ID=? AND SP_NAME LIKE ? AND STATE LIKE ?) AS RES WHERE RES.ROWNUM BETWEEN ? AND ?";
            offset = limit + offset;
            limit = initialOffset + 1;
        } else if (JdbcUtils.isInformixDB()) {
            query = "SELECT R.CONSENT_RECEIPT_ID, R.LANGUAGE, R.PII_PRINCIPAL_ID, R.PRINCIPAL_TENANT_ID, R.STATE,RS.SP_DISPLAY_NAME,RS.SP_DESCRIPTION FROM CM_RECEIPT R INNER JOIN CM_RECEIPT_SP_ASSOC RS ON R.CONSENT_RECEIPT_ID=RS.CONSENT_RECEIPT_ID WHERE PII_PRINCIPAL_ID LIKE ? AND PRINCIPAL_TENANT_ID = ? AND SP_NAME LIKE ? AND STATE LIKE ? ORDER BY ID  ASC LIMIT ? OFFSET ?";
        } else {
            query = "SELECT CONSENT_RECEIPT_ID, LANGUAGE,PII_PRINCIPAL_ID,  PRINCIPAL_TENANT_ID, STATE,SP_DISPLAY_NAME,SP_DESCRIPTION FROM (SELECT ROWNUM RNUM,A.* FROM( SELECT R.CONSENT_RECEIPT_ID, R.LANGUAGE,R.PII_PRINCIPAL_ID,R.PRINCIPAL_TENANT_ID, R.STATE,RS.SP_DISPLAY_NAME,RS.SP_DESCRIPTION FROM CM_RECEIPT R INNER JOIN CM_RECEIPT_SP_ASSOC RS ON R.CONSENT_RECEIPT_ID=RS.CONSENT_RECEIPT_ID WHERE PII_PRINCIPAL_ID LIKE ? AND PRINCIPAL_TENANT_ID = ? AND SP_NAME LIKE ? AND STATE LIKE ? ORDER BY   R.CONSENT_RECEIPT_ID ) A WHERE  ROWNUM <= ? ) WHERE  RNUM > ?";
            limit = offset + limit;
        }
        int finalLimit = limit;
        int finalOffset = offset;
        List receiptListResponses = jdbcTemplate.executeQuery(query, (resultSet, rowNumber) -> new ReceiptListResponse(resultSet.getString(1), resultSet.getString(2), resultSet.getString(3), resultSet.getInt(4), resultSet.getString(5), resultSet.getString(6), resultSet.getString(7)), preparedStatement -> {
            preparedStatement.setString(1, finalPiiPrincipalId);
            preparedStatement.setInt(2, piiPrincipalTenantId);
            preparedStatement.setString(3, finalService);
            preparedStatement.setString(4, finalState);
            preparedStatement.setInt(5, finalLimit);
            preparedStatement.setInt(6, finalOffset);
        });
        return receiptListResponses;
    }

    protected List<ReceiptListResponse> searchReceiptWithoutPrincipleTenant(int limit, int offset, int spTenantId, JdbcTemplate jdbcTemplate, String finalPiiPrincipalId, String finalService, String finalState) throws DataAccessException {
        int initialOffset;
        String query;
        if (JdbcUtils.isH2MySqlOrPostgresDB()) {
            query = "SELECT R.CONSENT_RECEIPT_ID, R.LANGUAGE, R.PII_PRINCIPAL_ID, R.PRINCIPAL_TENANT_ID, R.STATE,RS.SP_DISPLAY_NAME,RS.SP_DESCRIPTION FROM CM_RECEIPT R INNER JOIN CM_RECEIPT_SP_ASSOC RS ON R.CONSENT_RECEIPT_ID=RS.CONSENT_RECEIPT_ID WHERE PII_PRINCIPAL_ID LIKE ? AND SP_NAME LIKE ? AND SP_TENANT_ID = ? AND STATE LIKE ? ORDER BY ID  ASC LIMIT ? OFFSET ?";
        } else if (JdbcUtils.isDB2DB()) {
            query = "SELECT CONSENT_RECEIPT_ID, LANGUAGE, PII_PRINCIPAL_ID, PRINCIPAL_TENANT_ID,STATE,SP_DISPLAY_NAME,SP_DESCRIPTION FROM (SELECT R.CONSENT_RECEIPT_ID, R.LANGUAGE, R.PII_PRINCIPAL_ID, R.PRINCIPAL_TENANT_ID, RS.SP_DISPLAY_NAME,RS.SP_DESCRIPTION,R.STATE,ROW_NUMBER() OVER( ORDER BY R.CONSENT_RECEIPT_ID) AS ROWNUMBER FROM CM_RECEIPT R INNER JOIN CM_RECEIPT_SP_ASSOC RS ON  R.CONSENT_RECEIPT_ID = RS.CONSENT_RECEIPT_ID WHERE R.PII_PRINCIPAL_ID LIKE ? AND RS.SP_NAME LIKE ? AND RS.SP_TENANT_ID LIKE ? AND R.STATE LIKE ?) AS X WHERE ROWNUMBER BETWEEN ? AND ?";
            initialOffset = offset;
            offset += limit;
            limit = initialOffset + 1;
        } else if (JdbcUtils.isMSSqlDB()) {
            initialOffset = offset;
            offset = limit + offset;
            limit = initialOffset + 1;
            query = "SELECT CONSENT_RECEIPT_ID, LANGUAGE, PII_PRINCIPAL_ID, PRINCIPAL_TENANT_ID, STATE, SP_DISPLAY_NAME, SP_DESCRIPTION FROM (SELECT R.CONSENT_RECEIPT_ID, R.LANGUAGE, R.PII_PRINCIPAL_ID, R.PRINCIPAL_TENANT_ID, R.STATE, RS.SP_DISPLAY_NAME, RS.SP_DESCRIPTION, ROW_NUMBER() OVER ( ORDER BY R.CONSENT_RECEIPT_ID) AS ROWNUM FROM CM_RECEIPT R INNER JOIN CM_RECEIPT_SP_ASSOC RS ON R.CONSENT_RECEIPT_ID = RS.CONSENT_RECEIPT_ID WHERE PII_PRINCIPAL_ID LIKE ? AND SP_NAME LIKE ? AND SP_TENANT_ID LIKE ? AND STATE LIKE ?) AS RES WHERE RES.ROWNUM BETWEEN ? AND ?";
        } else if (JdbcUtils.isInformixDB()) {
            query = "SELECT R.CONSENT_RECEIPT_ID, R.LANGUAGE, R.PII_PRINCIPAL_ID, R.PRINCIPAL_TENANT_ID, R.STATE,RS.SP_DISPLAY_NAME,RS.SP_DESCRIPTION FROM CM_RECEIPT R INNER JOIN CM_RECEIPT_SP_ASSOC RS ON R.CONSENT_RECEIPT_ID=RS.CONSENT_RECEIPT_ID WHERE PII_PRINCIPAL_ID LIKE ? AND SP_NAME LIKE ? AND SP_TENANT_ID LIKE ? AND STATE LIKE ? ORDER BY ID  ASC LIMIT ? OFFSET ?";
        } else {
            query = "SELECT CONSENT_RECEIPT_ID, LANGUAGE,PII_PRINCIPAL_ID,  PRINCIPAL_TENANT_ID, STATE,SP_DISPLAY_NAME,SP_DESCRIPTION FROM (SELECT ROWNUM RNUM,A.* FROM( SELECT R.CONSENT_RECEIPT_ID, R.LANGUAGE,R.PII_PRINCIPAL_ID,R.PRINCIPAL_TENANT_ID, R.STATE,RS.SP_DISPLAY_NAME,RS.SP_DESCRIPTION FROM CM_RECEIPT R INNER JOIN CM_RECEIPT_SP_ASSOC RS ON R.CONSENT_RECEIPT_ID=RS.CONSENT_RECEIPT_ID WHERE PII_PRINCIPAL_ID LIKE ? AND SP_NAME LIKE ? AND SP_TENANT_ID LIKE ? AND STATE LIKE ? ORDER BY R.CONSENT_RECEIPT_ID ) A WHERE  ROWNUM <= ? ) WHERE  RNUM > ?";
            limit = offset + limit;
        }
        int finalLimit = limit;
        int finalOffset = offset;
        List receiptListResponses = jdbcTemplate.executeQuery(query, (resultSet, rowNumber) -> new ReceiptListResponse(resultSet.getString(1), resultSet.getString(2), resultSet.getString(3), resultSet.getInt(4), resultSet.getString(5), resultSet.getString(6), resultSet.getString(7)), preparedStatement -> {
            preparedStatement.setString(1, finalPiiPrincipalId);
            preparedStatement.setString(2, finalService);
            preparedStatement.setInt(3, spTenantId);
            preparedStatement.setString(4, finalState);
            preparedStatement.setInt(5, finalLimit);
            preparedStatement.setInt(6, finalOffset);
        });
        return receiptListResponses;
    }

    protected List<ReceiptListResponse> searchWithoutPrincipleAndSPTenantDomain(int limit, int offset, JdbcTemplate jdbcTemplate, String finalPiiPrincipalId, String finalService, String finalState) throws DataAccessException {
        int initialOffset;
        String query;
        if (JdbcUtils.isH2MySqlOrPostgresDB()) {
            query = "SELECT R.CONSENT_RECEIPT_ID, R.LANGUAGE, R.PII_PRINCIPAL_ID, R.PRINCIPAL_TENANT_ID, R.STATE,RS.SP_DISPLAY_NAME,RS.SP_DESCRIPTION FROM CM_RECEIPT R INNER JOIN CM_RECEIPT_SP_ASSOC RS ON R.CONSENT_RECEIPT_ID=RS.CONSENT_RECEIPT_ID WHERE PII_PRINCIPAL_ID LIKE ? AND SP_NAME LIKE ? AND STATE LIKE ? ORDER BY ID  ASC LIMIT ? OFFSET ?";
        } else if (JdbcUtils.isDB2DB()) {
            query = "SELECT CONSENT_RECEIPT_ID, LANGUAGE, PII_PRINCIPAL_ID, PRINCIPAL_TENANT_ID,STATE,SP_DISPLAY_NAME,SP_DESCRIPTION FROM (SELECT R.CONSENT_RECEIPT_ID, R.LANGUAGE, R.PII_PRINCIPAL_ID, R.PRINCIPAL_TENANT_ID, RS.SP_DISPLAY_NAME,RS.SP_DESCRIPTION,R.STATE,ROW_NUMBER() OVER( ORDER BY R.CONSENT_RECEIPT_ID) AS ROWNUMBER FROM CM_RECEIPT R INNER JOIN CM_RECEIPT_SP_ASSOC RS ON  R.CONSENT_RECEIPT_ID = RS.CONSENT_RECEIPT_ID WHERE R.PII_PRINCIPAL_ID LIKE ? AND RS.SP_NAME LIKE ? AND R.STATE LIKE ?) AS X WHERE ROWNUMBER BETWEEN ? AND ?";
            initialOffset = offset;
            offset += limit;
            limit = initialOffset + 1;
        } else if (JdbcUtils.isMSSqlDB()) {
            initialOffset = offset;
            offset = limit + offset;
            limit = initialOffset + 1;
            query = "SELECT CONSENT_RECEIPT_ID, LANGUAGE, PII_PRINCIPAL_ID, PRINCIPAL_TENANT_ID, STATE, SP_DISPLAY_NAME, SP_DESCRIPTION FROM (SELECT R.CONSENT_RECEIPT_ID, R.LANGUAGE, R.PII_PRINCIPAL_ID, R.PRINCIPAL_TENANT_ID, R.STATE, RS.SP_DISPLAY_NAME, RS.SP_DESCRIPTION, ROW_NUMBER() OVER ( ORDER BY R.CONSENT_RECEIPT_ID) AS ROWNUM FROM CM_RECEIPT R INNER JOIN CM_RECEIPT_SP_ASSOC RS ON R.CONSENT_RECEIPT_ID = RS.CONSENT_RECEIPT_ID WHERE PII_PRINCIPAL_ID LIKE ? AND SP_NAME LIKE ? AND STATE LIKE ?) AS RES WHERE RES.ROWNUM BETWEEN ? AND ?";
        } else if (JdbcUtils.isInformixDB()) {
            query = "SELECT R.CONSENT_RECEIPT_ID, R.LANGUAGE, R.PII_PRINCIPAL_ID, R.PRINCIPAL_TENANT_ID, R.STATE,RS.SP_DISPLAY_NAME,RS.SP_DESCRIPTION FROM CM_RECEIPT R INNER JOIN CM_RECEIPT_SP_ASSOC RS ON R.CONSENT_RECEIPT_ID=RS.CONSENT_RECEIPT_ID WHERE PII_PRINCIPAL_ID LIKE ? AND SP_NAME LIKE ? AND STATE LIKE ? ORDER BY ID  ASC LIMIT ? OFFSET ?";
        } else {
            query = "SELECT CONSENT_RECEIPT_ID, LANGUAGE,PII_PRINCIPAL_ID,  PRINCIPAL_TENANT_ID, STATE,SP_DISPLAY_NAME,SP_DESCRIPTION FROM (SELECT ROWNUM RNUM,A.* FROM( SELECT R.CONSENT_RECEIPT_ID, R.LANGUAGE,R.PII_PRINCIPAL_ID,R.PRINCIPAL_TENANT_ID, R.STATE,RS.SP_DISPLAY_NAME,RS.SP_DESCRIPTION FROM CM_RECEIPT R INNER JOIN CM_RECEIPT_SP_ASSOC RS ON R.CONSENT_RECEIPT_ID=RS.CONSENT_RECEIPT_ID WHERE PII_PRINCIPAL_ID LIKE ? AND SP_NAME LIKE ? AND STATE LIKE ? ORDER BY R.CONSENT_RECEIPT_ID ) A WHERE  ROWNUM <= ? ) WHERE  RNUM > ?";
            limit = offset + limit;
        }
        int finalLimit = limit;
        int finalOffset = offset;
        List receiptListResponses = jdbcTemplate.executeQuery(query, (resultSet, rowNumber) -> new ReceiptListResponse(resultSet.getString(1), resultSet.getString(2), resultSet.getString(3), resultSet.getInt(4), resultSet.getString(5), resultSet.getString(6), resultSet.getString(7)), preparedStatement -> {
            preparedStatement.setString(1, finalPiiPrincipalId);
            preparedStatement.setString(2, finalService);
            preparedStatement.setString(3, finalState);
            preparedStatement.setInt(4, finalLimit);
            preparedStatement.setInt(5, finalOffset);
        });
        return receiptListResponses;
    }

    protected void setReceiptSensitivity(ReceiptContext receiptContext, Receipt receipt) {
        if (receiptContext.getSecretPIICategory().getSecretPIICategories().size() > 0) {
            receipt.setSensitive(true);
            receipt.setSpiCat(receiptContext.getSecretPIICategory().getSecretPIICategories());
        }
    }

    protected void addReceiptInfo(ReceiptInput receiptInput) throws ConsentManagementServerException {
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        try {
            jdbcTemplate.withTransaction(template -> {
                template.executeInsert("INSERT INTO CM_RECEIPT (CONSENT_RECEIPT_ID,VERSION, JURISDICTION,CONSENT_TIMESTAMP,COLLECTION_METHOD,LANGUAGE,PII_PRINCIPAL_ID,PRINCIPAL_TENANT_ID, POLICY_URL,STATE,PII_CONTROLLER) values (?,?,?,?,?,?,?,?,?,?,?)", preparedStatement -> {
                    preparedStatement.setString(1, receiptInput.getConsentReceiptId());
                    preparedStatement.setString(2, receiptInput.getVersion());
                    preparedStatement.setString(3, receiptInput.getJurisdiction());
                    preparedStatement.setTimestamp(4, new Timestamp(new Date().getTime()), Calendar.getInstance(TimeZone.getTimeZone(ZoneOffset.UTC)));
                    preparedStatement.setString(5, receiptInput.getCollectionMethod());
                    preparedStatement.setString(6, receiptInput.getLanguage());
                    preparedStatement.setString(7, receiptInput.getPiiPrincipalId());
                    preparedStatement.setInt(8, receiptInput.getTenantId());
                    preparedStatement.setString(9, receiptInput.getPolicyUrl());
                    preparedStatement.setString(10, "ACTIVE");
                    preparedStatement.setString(11, receiptInput.getPiiControllerInfo());
                }, (Object)receiptInput, false);
                return null;
            });
        }
        catch (TransactionException e) {
            throw ConsentUtils.handleServerException(ConsentConstants.ErrorMessages.ERROR_CODE_ADD_RECEIPT, receiptInput.getPiiPrincipalId(), e);
        }
    }

    protected int addReceiptSPAssociation(String receiptId, ReceiptServiceInput receiptServiceInput) throws ConsentManagementServerException {
        int receiptToSPAssocId;
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        try {
            receiptToSPAssocId = (Integer)jdbcTemplate.withTransaction(template -> template.executeInsert("INSERT INTO CM_RECEIPT_SP_ASSOC (CONSENT_RECEIPT_ID, SP_NAME,SP_TENANT_ID,SP_DISPLAY_NAME,SP_DESCRIPTION) VALUES (?,?,?,?,?)", preparedStatement -> {
                preparedStatement.setString(1, receiptId);
                preparedStatement.setString(2, receiptServiceInput.getService());
                preparedStatement.setInt(3, receiptServiceInput.getTenantId());
                preparedStatement.setString(4, receiptServiceInput.getSpDisplayName());
                preparedStatement.setString(5, receiptServiceInput.getSpDescription());
            }, (Object)receiptServiceInput, true));
        }
        catch (TransactionException e) {
            throw ConsentUtils.handleServerException(ConsentConstants.ErrorMessages.ERROR_CODE_ADD_RECEIPT_SP_ASSOC, receiptServiceInput.getService(), e);
        }
        return receiptToSPAssocId;
    }

    protected int addSpToPurposeAssociation(int receiptToSPAssocId, ReceiptPurposeInput receiptPurposeInput) throws ConsentManagementServerException {
        int spToPurposeAssocId;
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        try {
            spToPurposeAssocId = (Integer)jdbcTemplate.withTransaction(template -> template.executeInsert("INSERT INTO CM_SP_PURPOSE_ASSOC (RECEIPT_SP_ASSOC,PURPOSE_ID,CONSENT_TYPE,IS_PRIMARY_PURPOSE,TERMINATION,THIRD_PARTY_DISCLOSURE,THIRD_PARTY_NAME) VALUES (?,?,?,?,?,?,?)", preparedStatement -> {
                preparedStatement.setInt(1, receiptToSPAssocId);
                preparedStatement.setInt(2, receiptPurposeInput.getPurposeId());
                preparedStatement.setString(3, receiptPurposeInput.getConsentType());
                preparedStatement.setInt(4, receiptPurposeInput.isPrimaryPurpose() != false ? 1 : 0);
                preparedStatement.setString(5, receiptPurposeInput.getTermination());
                preparedStatement.setInt(6, receiptPurposeInput.isThirdPartyDisclosure() != false ? 1 : 0);
                preparedStatement.setString(7, receiptPurposeInput.getThirdPartyName());
            }, (Object)receiptPurposeInput, true));
        }
        catch (TransactionException e) {
            throw ConsentUtils.handleServerException(ConsentConstants.ErrorMessages.ERROR_CODE_ADD_SP_TO_PURPOSE_ASSOC, String.valueOf(receiptPurposeInput.getPurposeName()), e);
        }
        return spToPurposeAssocId;
    }

    protected void addSpPurposeToPurposeCategoryAssociation(int spToPurposeAssocId, int id) throws ConsentManagementServerException {
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        try {
            jdbcTemplate.withTransaction(template -> {
                template.executeInsert("INSERT INTO CM_SP_PURPOSE_PURPOSE_CAT_ASSC (SP_PURPOSE_ASSOC_ID, PURPOSE_CATEGORY_ID) VALUES (?,?)", preparedStatement -> {
                    preparedStatement.setInt(1, spToPurposeAssocId);
                    preparedStatement.setInt(2, id);
                }, (Object)id, false);
                return null;
            });
        }
        catch (TransactionException e) {
            throw ConsentUtils.handleServerException(ConsentConstants.ErrorMessages.ERROR_CODE_ADD_SP_PURPOSE_TO_PURPOSE_CAT_ASSOC, null, e);
        }
    }

    protected void addSpPurposeToPiiCategoryAssociation(int spToPurposeAssocId, int id, String validity) throws ConsentManagementServerException {
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        try {
            jdbcTemplate.withTransaction(template -> {
                template.executeInsert("INSERT INTO CM_SP_PURPOSE_PII_CAT_ASSOC (SP_PURPOSE_ASSOC_ID, PII_CATEGORY_ID, VALIDITY) VALUES (?,?,?)", preparedStatement -> {
                    preparedStatement.setInt(1, spToPurposeAssocId);
                    preparedStatement.setInt(2, id);
                    preparedStatement.setString(3, validity);
                }, (Object)id, false);
                return null;
            });
        }
        catch (TransactionException e) {
            throw ConsentUtils.handleServerException(ConsentConstants.ErrorMessages.ERROR_CODE_ADD_SP_PURPOSE_TO_PII_CAT_ASSOC, null, e);
        }
    }

    protected void addReceiptProperties(String consentReceiptId, Map<String, String> properties) throws ConsentManagementServerException {
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        try {
            jdbcTemplate.withTransaction(template -> {
                template.executeBatchInsert("INSERT INTO CM_CONSENT_RECEIPT_PROPERTY (CONSENT_RECEIPT_ID,NAME,VALUE) VALUES (?,?,?)", preparedStatement -> {
                    for (Map.Entry entry : properties.entrySet()) {
                        preparedStatement.setString(1, consentReceiptId);
                        preparedStatement.setString(2, (String)entry.getKey());
                        preparedStatement.setString(3, (String)entry.getValue());
                        preparedStatement.addBatch();
                    }
                }, (Object)consentReceiptId);
                return null;
            });
        }
        catch (TransactionException e) {
            throw ConsentUtils.handleServerException(ConsentConstants.ErrorMessages.ERROR_CODE_ADD_RECEIPT_PROPERTIES, null, e);
        }
    }

    protected List<ReceiptService> getServiceInfoOfReceipt(String consentReceiptId, ReceiptContext receiptContext) throws ConsentManagementServerException {
        List receiptServices;
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        try {
            receiptServices = (List)jdbcTemplate.withTransaction(template -> {
                List internalReceiptServices = template.executeQuery("SELECT ID,SP_NAME,SP_TENANT_ID,SP_DISPLAY_NAME,SP_DESCRIPTION  FROM CM_RECEIPT_SP_ASSOC WHERE CONSENT_RECEIPT_ID =?", (resultSet, rowNumber) -> {
                    ReceiptService receiptService = new ReceiptService();
                    receiptService.setReceiptToServiceId(resultSet.getInt(1));
                    receiptService.setService(resultSet.getString(2));
                    receiptService.setTenantId(resultSet.getInt(3));
                    receiptService.setSpDisplayName(resultSet.getString(4));
                    receiptService.setSpDescription(resultSet.getString(5));
                    return receiptService;
                }, preparedStatement -> preparedStatement.setString(1, consentReceiptId));
                if (internalReceiptServices != null) {
                    internalReceiptServices.forEach(LambdaExceptionUtils.rethrowConsumer(receiptService -> receiptService.setPurposes(this.getPurposeInfoOfService(receiptService.getReceiptToServiceId(), consentReceiptId, receiptContext))));
                }
                return internalReceiptServices;
            });
        }
        catch (TransactionException e) {
            throw ConsentUtils.handleServerException(ConsentConstants.ErrorMessages.ERROR_CODE_RETRIEVE_RECEIPT_INFO, consentReceiptId, e);
        }
        return receiptServices;
    }

    private List<ConsentPurpose> getPurposeInfoOfService(int receiptToServiceId, String consentReceiptId, ReceiptContext receiptContext) throws ConsentManagementException {
        List consentPurposes;
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        try {
            consentPurposes = (List)jdbcTemplate.withTransaction(template -> {
                List internalConsentPurposes = jdbcTemplate.executeQuery("SELECT SP.ID,SP.CONSENT_TYPE,SP.IS_PRIMARY_PURPOSE,SP.TERMINATION,SP.THIRD_PARTY_DISCLOSURE,SP.THIRD_PARTY_NAME,P.NAME,P.DESCRIPTION,P.ID FROM CM_SP_PURPOSE_ASSOC SP INNER JOIN  CM_PURPOSE P ON SP.PURPOSE_ID = P.ID WHERE RECEIPT_SP_ASSOC =?", (resultSet, rowNumber) -> {
                    ConsentPurpose consentPurpose = new ConsentPurpose();
                    consentPurpose.setServiceToPurposeId(resultSet.getInt(1));
                    consentPurpose.setConsentType(resultSet.getString(2));
                    consentPurpose.setPrimaryPurpose(resultSet.getInt(3) == 1);
                    consentPurpose.setTermination(resultSet.getString(4));
                    consentPurpose.setThirdPartyDisclosure(resultSet.getInt(5) == 1);
                    consentPurpose.setThirdPartyName(resultSet.getString(6));
                    consentPurpose.setPurpose(resultSet.getString(7));
                    consentPurpose.setPurposeDescription(resultSet.getString(8));
                    consentPurpose.setPurposeId(resultSet.getInt(9));
                    return consentPurpose;
                }, preparedStatement -> preparedStatement.setInt(1, receiptToServiceId));
                if (internalConsentPurposes != null) {
                    internalConsentPurposes.forEach(LambdaExceptionUtils.rethrowConsumer(consentPurpose -> {
                        consentPurpose.setPiiCategory(this.getPIICategoryInfoOfPurpose(consentPurpose.getServiceToPurposeId(), consentReceiptId, receiptContext));
                        consentPurpose.setPurposeCategory(this.getPurposeCategoryInfoOfPurpose(consentPurpose.getServiceToPurposeId(), consentReceiptId));
                    }));
                }
                return internalConsentPurposes;
            });
        }
        catch (TransactionException e) {
            throw ConsentUtils.handleServerException(ConsentConstants.ErrorMessages.ERROR_CODE_RETRIEVE_PURPOSE_INFO, consentReceiptId, e);
        }
        return consentPurposes;
    }

    private List<PIICategoryValidity> getPIICategoryInfoOfPurpose(int serviceToPurposeId, String consentReceiptId, ReceiptContext receiptContext) throws ConsentManagementServerException {
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        try {
            return (List)jdbcTemplate.withTransaction(template -> template.executeQuery("SELECT PC.NAME,PC.IS_SENSITIVE,SPC.VALIDITY,PC.ID,PC.DISPLAY_NAME FROM CM_SP_PURPOSE_PII_CAT_ASSOC SPC INNER JOIN  CM_PII_CATEGORY PC ON SPC.PII_CATEGORY_ID = PC.ID WHERE SPC.SP_PURPOSE_ASSOC_ID =?", (resultSet, rowNumber) -> {
                String name = resultSet.getString(1);
                boolean isSensitive = resultSet.getInt(2) == 1;
                String validity = resultSet.getString(3);
                int id = resultSet.getInt(4);
                String displayName = resultSet.getString(5);
                if (isSensitive) {
                    receiptContext.getSecretPIICategory().addSecretCategory(name);
                }
                return new PIICategoryValidity(name, validity, id, displayName);
            }, preparedStatement -> preparedStatement.setInt(1, serviceToPurposeId)));
        }
        catch (TransactionException e) {
            throw ConsentUtils.handleServerException(ConsentConstants.ErrorMessages.ERROR_CODE_RETRIEVE_RECEIPT_INFO, consentReceiptId, e);
        }
    }

    private List<String> getPurposeCategoryInfoOfPurpose(int serviceToPurposeId, String consentReceiptId) throws ConsentManagementServerException {
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        try {
            return (List)jdbcTemplate.withTransaction(template -> template.executeQuery("SELECT NAME FROM CM_SP_PURPOSE_PURPOSE_CAT_ASSC SPC INNER JOIN  CM_PURPOSE_CATEGORY PC ON SPC.PURPOSE_CATEGORY_ID = PC.ID WHERE SPC.SP_PURPOSE_ASSOC_ID =?", (resultSet, rowNumber) -> resultSet.getString(1), preparedStatement -> preparedStatement.setInt(1, serviceToPurposeId)));
        }
        catch (TransactionException e) {
            throw ConsentUtils.handleServerException(ConsentConstants.ErrorMessages.ERROR_CODE_RETRIEVE_RECEIPT_INFO, consentReceiptId, e);
        }
    }

    @Override
    public void deleteReceipt(String receiptID) throws ConsentManagementException {
        Receipt receipt = this.getReceipt(receiptID);
        if (receipt == null) {
            throw ConsentUtils.handleServerException(ConsentConstants.ErrorMessages.ERROR_CODE_DELETE_RECEIPT, String.valueOf(receiptID));
        }
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        try {
            jdbcTemplate.withTransaction(template -> {
                receipt.getServices().forEach(LambdaExceptionUtils.rethrowConsumer(receiptService -> {
                    int receiptToServiceId = receiptService.getReceiptToServiceId();
                    receiptService.getPurposes().forEach(LambdaExceptionUtils.rethrowConsumer(consentPurpose -> {
                        int serviceToPurposeId = consentPurpose.getServiceToPurposeId();
                        this.deleteSpPurposeToPiiCategoryAssociation(serviceToPurposeId);
                        this.deleteSpPurposeToPurposeCategoryAssociation(serviceToPurposeId);
                    }));
                    this.deleteSpToPurposeAssociation(receiptToServiceId);
                }));
                this.deleteReceiptSPAssociation(receiptID);
                this.deleteReceiptProperties(receiptID);
                this.deleteReceiptOnly(receiptID);
                return null;
            });
        }
        catch (TransactionException e) {
            throw ConsentUtils.handleServerException(ConsentConstants.ErrorMessages.ERROR_CODE_DELETE_RECEIPT, receiptID, e);
        }
    }

    @Override
    public void deleteReceiptsByTenantId(int tenantId) throws ConsentManagementException {
        this.deleteReceiptsByPrincipalTenantId(tenantId);
        this.deleteReceiptSPAssociationBySPTenantId(tenantId);
    }

    protected void deleteReceiptOnly(String receiptID) throws ConsentManagementServerException {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Deleting receipt with ID: %s", receiptID));
        }
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        try {
            jdbcTemplate.executeUpdate("DELETE FROM CM_RECEIPT WHERE CONSENT_RECEIPT_ID = ?", preparedStatement -> preparedStatement.setString(1, receiptID));
        }
        catch (DataAccessException e) {
            throw ConsentUtils.handleServerException(ConsentConstants.ErrorMessages.ERROR_CODE_DELETE_RECEIPT, String.valueOf(receiptID), e);
        }
    }

    protected void deleteReceiptProperties(String consentReceiptId) throws ConsentManagementServerException {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Deleting receipt properties for receipt ID : %s", consentReceiptId));
        }
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        try {
            jdbcTemplate.executeUpdate("DELETE FROM CM_CONSENT_RECEIPT_PROPERTY WHERE CONSENT_RECEIPT_ID = ?", preparedStatement -> preparedStatement.setString(1, consentReceiptId));
        }
        catch (DataAccessException e) {
            throw ConsentUtils.handleServerException(ConsentConstants.ErrorMessages.ERROR_CODE_DELETE_RECEIPT, String.valueOf(consentReceiptId), e);
        }
    }

    protected void deleteSpPurposeToPiiCategoryAssociation(int spToPurposeAssocId) throws ConsentManagementServerException {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Deleting SP, Purpose and Pii Category association with ID: %d", spToPurposeAssocId));
        }
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        try {
            jdbcTemplate.executeUpdate("DELETE FROM CM_SP_PURPOSE_PII_CAT_ASSOC WHERE SP_PURPOSE_ASSOC_ID = ?", preparedStatement -> preparedStatement.setInt(1, spToPurposeAssocId));
        }
        catch (DataAccessException e) {
            throw ConsentUtils.handleServerException(ConsentConstants.ErrorMessages.ERROR_CODE_DELETE_RECEIPT, String.valueOf(spToPurposeAssocId), e);
        }
    }

    protected void deleteSpPurposeToPurposeCategoryAssociation(int spToPurposeAssocId) throws ConsentManagementServerException {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Deleting SP, Purpose and Purpose Category association with ID: %d", spToPurposeAssocId));
        }
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        try {
            jdbcTemplate.executeUpdate("DELETE FROM CM_SP_PURPOSE_PURPOSE_CAT_ASSC WHERE SP_PURPOSE_ASSOC_ID = ?", preparedStatement -> preparedStatement.setInt(1, spToPurposeAssocId));
        }
        catch (DataAccessException e) {
            throw ConsentUtils.handleServerException(ConsentConstants.ErrorMessages.ERROR_CODE_DELETE_RECEIPT, String.valueOf(spToPurposeAssocId), e);
        }
    }

    protected void deleteReceiptSPAssociation(String receiptID) throws ConsentManagementServerException {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Deleting Receipt and SP association with ID: %s", receiptID));
        }
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        try {
            jdbcTemplate.executeUpdate("DELETE FROM CM_RECEIPT_SP_ASSOC WHERE CONSENT_RECEIPT_ID = ?", preparedStatement -> preparedStatement.setString(1, receiptID));
        }
        catch (DataAccessException e) {
            throw ConsentUtils.handleServerException(ConsentConstants.ErrorMessages.ERROR_CODE_DELETE_RECEIPT, String.valueOf(receiptID), e);
        }
    }

    protected void deleteReceiptsByPrincipalTenantId(int tenantId) throws ConsentManagementException {
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        try {
            jdbcTemplate.executeUpdate("DELETE FROM CM_RECEIPT WHERE PRINCIPAL_TENANT_ID = ?", preparedStatement -> preparedStatement.setInt(1, tenantId));
        }
        catch (DataAccessException e) {
            throw ConsentUtils.handleServerException(ConsentConstants.ErrorMessages.ERROR_CODE_DELETE_RECEIPTS_BY_PRINCIPAL_TENANT_ID, String.valueOf(tenantId), e);
        }
    }

    protected void deleteReceiptSPAssociationBySPTenantId(int tenantId) throws ConsentManagementServerException {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Deleting Receipt and SP association by SP tenant Id: %s", tenantId));
        }
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        try {
            jdbcTemplate.executeUpdate("DELETE FROM CM_RECEIPT_SP_ASSOC WHERE SP_TENANT_ID = ?", preparedStatement -> preparedStatement.setInt(1, tenantId));
        }
        catch (DataAccessException e) {
            throw ConsentUtils.handleServerException(ConsentConstants.ErrorMessages.ERROR_CODE_DELETE_SP_ASSOC_BY_SP_TENANT_ID, String.valueOf(tenantId), e);
        }
    }

    protected void deleteSpToPurposeAssociation(int receiptToSPAssocId) throws ConsentManagementServerException {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Deleting SP to Purpose Association with id %d", receiptToSPAssocId));
        }
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        try {
            jdbcTemplate.executeUpdate("DELETE FROM CM_SP_PURPOSE_ASSOC WHERE RECEIPT_SP_ASSOC = ?", preparedStatement -> preparedStatement.setInt(1, receiptToSPAssocId));
        }
        catch (DataAccessException e) {
            throw ConsentUtils.handleServerException(ConsentConstants.ErrorMessages.ERROR_CODE_DELETE_RECEIPT, String.valueOf(receiptToSPAssocId), e);
        }
    }
}

