/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.consent.mgt.core.util;

import org.wso2.carbon.consent.mgt.core.internal.ConsentManagerComponentDataHolder;
import org.wso2.carbon.database.utils.jdbc.JdbcTemplate;
import org.wso2.carbon.database.utils.jdbc.exceptions.DataAccessException;

public class JdbcUtils {
    public static JdbcTemplate getNewTemplate() {
        return new JdbcTemplate(ConsentManagerComponentDataHolder.getInstance().getDataSource());
    }

    public static boolean isH2MySqlOrPostgresDB() throws DataAccessException {
        return JdbcUtils.isDBTypeOf("MySQL") || JdbcUtils.isDBTypeOf("H2") || JdbcUtils.isDBTypeOf("PostgreSQL");
    }

    public static boolean isDB2DB() throws DataAccessException {
        return JdbcUtils.isDBTypeOf("DB2");
    }

    public static boolean isMSSqlDB() throws DataAccessException {
        return JdbcUtils.isDBTypeOf("Microsoft") || JdbcUtils.isDBTypeOf("microsoft");
    }

    public static boolean isInformixDB() throws DataAccessException {
        return JdbcUtils.isDBTypeOf("Informix");
    }

    private static boolean isDBTypeOf(String dbType) throws DataAccessException {
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        return jdbcTemplate.getDriverName().contains(dbType) || jdbcTemplate.getDatabaseProductName().contains(dbType);
    }
}

