/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.consent.mgt.core.connector.impl;

import java.util.Map;
import org.wso2.carbon.consent.mgt.core.connector.PIIController;
import org.wso2.carbon.consent.mgt.core.model.Address;
import org.wso2.carbon.consent.mgt.core.model.PiiController;
import org.wso2.carbon.consent.mgt.core.util.ConsentConfigParser;

public class DefaultPIIController
implements PIIController {
    private final ConsentConfigParser configParser;

    public DefaultPIIController(ConsentConfigParser configParser) {
        this.configParser = configParser;
    }

    @Override
    public int getPriority() {
        return 1;
    }

    @Override
    public PiiController getControllerInfo(String tenantDomain) {
        String addressCountry = this.getConfiguration("PIIController.Address.Country");
        String addressLocality = this.getConfiguration("PIIController.Address.Locality");
        String addressRegion = this.getConfiguration("PIIController.Address.Region");
        String addressPostOfficeBoxNumber = this.getConfiguration("PIIController.Address.PostOfficeBoxNumber");
        String addressPostCode = this.getConfiguration("PIIController.Address.PostalCode");
        String addressStreetAddress = this.getConfiguration("PIIController.Address.StreetAddress");
        String piiControllerName = this.getConfiguration("PIIController.PiiController");
        String piiControllerContact = this.getConfiguration("PIIController.Contact");
        String piiControllerPhone = this.getConfiguration("PIIController.Phone");
        String piiControllerEmail = this.getConfiguration("PIIController.Email");
        boolean piiControllerOnBehalf = Boolean.parseBoolean(this.getConfiguration("PIIController.OnBehalf"));
        String piiControllerURL = this.getConfiguration("PIIController.PiiControllerUrl");
        Address address = new Address(addressCountry, addressLocality, addressRegion, addressPostOfficeBoxNumber, addressPostCode, addressStreetAddress);
        return new PiiController(piiControllerName, piiControllerOnBehalf, piiControllerContact, piiControllerEmail, piiControllerPhone, piiControllerURL, address);
    }

    private String getConfiguration(String configElement) {
        Map<String, Object> configuration = this.configParser.getConfiguration();
        if (configuration.get(configElement) != null) {
            return configuration.get(configElement).toString();
        }
        return null;
    }
}

