/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.consent.mgt.core.model;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.wso2.carbon.consent.mgt.core.exception.ConsentManagementClientException;

public class ConsentMessageContext<T1, T2>
implements Serializable {
    private static final long serialVersionUID = 4937506590904486749L;
    protected Map<T1, T2> parameters = new HashMap<T1, T2>();

    public ConsentMessageContext(Map<T1, T2> parameters) {
    }

    public ConsentMessageContext() {
    }

    public void addParameter(T1 key, T2 value) throws ConsentManagementClientException {
        if (this.parameters.containsKey(key)) {
            throw new ConsentManagementClientException("Parameters map trying to override existing key " + key, "");
        }
        this.parameters.put(key, value);
    }

    public void addParameters(Map<T1, T2> parameters) throws ConsentManagementClientException {
        for (Map.Entry<T1, T2> parameter : parameters.entrySet()) {
            if (this.parameters.containsKey(parameter.getKey())) {
                throw new ConsentManagementClientException("Parameters map trying to override existing key " + parameter.getKey(), "");
            }
            parameters.put(parameter.getKey(), parameter.getValue());
        }
    }

    public Map<T1, T2> getParameters() {
        return Collections.unmodifiableMap(this.parameters);
    }

    public T2 getParameter(T1 key) {
        return this.parameters.get(key);
    }
}

