/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.consent.mgt.core.dao.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.wso2.carbon.consent.mgt.core.constant.ConsentConstants;
import org.wso2.carbon.consent.mgt.core.dao.PurposeDAO;
import org.wso2.carbon.consent.mgt.core.exception.ConsentManagementException;
import org.wso2.carbon.consent.mgt.core.exception.ConsentManagementServerException;
import org.wso2.carbon.consent.mgt.core.model.Purpose;
import org.wso2.carbon.consent.mgt.core.model.PurposePIICategory;
import org.wso2.carbon.consent.mgt.core.util.ConsentUtils;
import org.wso2.carbon.consent.mgt.core.util.JdbcUtils;
import org.wso2.carbon.consent.mgt.core.util.LambdaExceptionUtils;
import org.wso2.carbon.database.utils.jdbc.JdbcTemplate;
import org.wso2.carbon.database.utils.jdbc.exceptions.DataAccessException;

public class PurposeDAOImpl
implements PurposeDAO {
    private static final String SQL_FILTER_STRING_ANY = "%";
    private static final String QUERY_FILTER_STRING_ANY = "*";
    private static final String QUERY_FILTER_STRING_ANY_ESCAPED = "\\*";

    @Override
    public int getPriority() {
        return 1;
    }

    @Override
    public Purpose addPurpose(Purpose purpose) throws ConsentManagementException {
        int insertedId;
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        try {
            insertedId = jdbcTemplate.executeInsert("INSERT INTO CM_PURPOSE (NAME, DESCRIPTION, PURPOSE_GROUP, GROUP_TYPE, TENANT_ID) values (?, ?, ?, ?, ?)", preparedStatement -> {
                preparedStatement.setString(1, purpose.getName());
                preparedStatement.setString(2, purpose.getDescription());
                preparedStatement.setString(3, purpose.getGroup());
                preparedStatement.setString(4, purpose.getGroupType());
                preparedStatement.setInt(5, purpose.getTenantId());
            }, (Object)purpose, true);
        }
        catch (DataAccessException e) {
            throw ConsentUtils.handleServerException(ConsentConstants.ErrorMessages.ERROR_CODE_ADD_PURPOSE, purpose.getName(), e);
        }
        purpose.getPurposePIICategories().forEach(LambdaExceptionUtils.rethrowConsumer(piiCategory -> {
            try {
                jdbcTemplate.executeInsert("INSERT INTO CM_PURPOSE_PII_CAT_ASSOC (PURPOSE_ID, CM_PII_CATEGORY_ID, IS_MANDATORY) VALUES (?,?,?)", preparedStatement -> {
                    preparedStatement.setInt(1, insertedId);
                    preparedStatement.setInt(2, piiCategory.getId());
                    preparedStatement.setInt(3, piiCategory.getMandatory() != false ? 1 : 0);
                }, piiCategory, false);
            }
            catch (DataAccessException e) {
                throw ConsentUtils.handleServerException(ConsentConstants.ErrorMessages.ERROR_CODE_ADD_PURPOSE_PII_ASSOC, String.valueOf(insertedId), e);
            }
        }));
        Purpose purposeResult = new Purpose(insertedId, purpose.getName(), purpose.getDescription(), purpose.getGroup(), purpose.getGroupType(), purpose.getTenantId(), purpose.getPurposePIICategories());
        return purposeResult;
    }

    @Override
    public Purpose getPurposeById(int id) throws ConsentManagementException {
        Purpose purpose;
        if (id == 0) {
            throw ConsentUtils.handleClientException(ConsentConstants.ErrorMessages.ERROR_CODE_PURPOSE_ID_REQUIRED, null);
        }
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        try {
            purpose = (Purpose)jdbcTemplate.fetchSingleRecord("SELECT ID, NAME, DESCRIPTION, PURPOSE_GROUP, GROUP_TYPE, TENANT_ID FROM CM_PURPOSE WHERE ID = ?", (resultSet, rowNumber) -> new Purpose(resultSet.getInt(1), resultSet.getString(2), resultSet.getString(3), resultSet.getString(4), resultSet.getString(5), resultSet.getInt(6)), preparedStatement -> preparedStatement.setInt(1, id));
        }
        catch (DataAccessException e) {
            throw ConsentUtils.handleServerException(ConsentConstants.ErrorMessages.ERROR_CODE_SELECT_PURPOSE_BY_ID, String.valueOf(id), e);
        }
        if (purpose != null) {
            try {
                ArrayList<PurposePIICategory> piiCategories = new ArrayList<PurposePIICategory>();
                jdbcTemplate.executeQuery("SELECT CM_PII_CATEGORY_ID, IS_MANDATORY FROM CM_PURPOSE_PII_CAT_ASSOC WHERE PURPOSE_ID = ?", (resultSet, rowNumber) -> piiCategories.add(new PurposePIICategory(resultSet.getInt(1), (Boolean)(resultSet.getInt(2) == 1 ? 1 : 0))), preparedStatement -> preparedStatement.setInt(1, purpose.getId()));
                purpose.setPurposePIICategories(piiCategories);
            }
            catch (DataAccessException e) {
                throw ConsentUtils.handleServerException(ConsentConstants.ErrorMessages.ERROR_CODE_SELECT_PURPOSE_BY_ID, String.valueOf(id), e);
            }
        }
        return purpose;
    }

    @Override
    public Purpose getPurposeByName(String name, String group, String groupType, int tenantId) throws ConsentManagementException {
        Purpose purpose;
        if (StringUtils.isBlank((String)name)) {
            throw ConsentUtils.handleClientException(ConsentConstants.ErrorMessages.ERROR_CODE_PURPOSE_NAME_REQUIRED, null);
        }
        if (StringUtils.isBlank((String)group)) {
            throw ConsentUtils.handleClientException(ConsentConstants.ErrorMessages.ERROR_CODE_PURPOSE_GROUP_REQUIRED, null);
        }
        if (StringUtils.isBlank((String)groupType)) {
            throw ConsentUtils.handleClientException(ConsentConstants.ErrorMessages.ERROR_CODE_PURPOSE_GROUP_TYPE_REQUIRED, null);
        }
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        try {
            purpose = (Purpose)jdbcTemplate.fetchSingleRecord("SELECT ID, NAME, DESCRIPTION, PURPOSE_GROUP, GROUP_TYPE, TENANT_ID FROM CM_PURPOSE WHERE NAME = ? AND PURPOSE_GROUP = ? AND GROUP_TYPE = ? AND TENANT_ID = ?", (resultSet, rowNumber) -> new Purpose(resultSet.getInt(1), resultSet.getString(2), resultSet.getString(3), resultSet.getString(4), resultSet.getString(5), resultSet.getInt(6)), preparedStatement -> {
                preparedStatement.setString(1, name);
                preparedStatement.setString(2, group);
                preparedStatement.setString(3, groupType);
                preparedStatement.setInt(4, tenantId);
            });
        }
        catch (DataAccessException e) {
            throw ConsentUtils.handleServerException(ConsentConstants.ErrorMessages.ERROR_CODE_SELECT_PURPOSE_BY_NAME, name, e);
        }
        return purpose;
    }

    @Override
    public List<Purpose> listPurposes(int limit, int offset, int tenantId) throws ConsentManagementException {
        return this.listPurposes(QUERY_FILTER_STRING_ANY, QUERY_FILTER_STRING_ANY, limit, offset, tenantId);
    }

    @Override
    public List<Purpose> listPurposes(String group, String groupType, int limit, int offset, int tenantId) throws ConsentManagementException {
        List purposes;
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        try {
            int initialOffset;
            String query;
            if (StringUtils.isEmpty((String)group)) {
                group = SQL_FILTER_STRING_ANY;
            } else if (group.contains(QUERY_FILTER_STRING_ANY)) {
                group = group.replaceAll(QUERY_FILTER_STRING_ANY_ESCAPED, SQL_FILTER_STRING_ANY);
            }
            if (StringUtils.isEmpty((String)groupType)) {
                groupType = SQL_FILTER_STRING_ANY;
            } else if (groupType.contains(QUERY_FILTER_STRING_ANY)) {
                groupType = groupType.replaceAll(QUERY_FILTER_STRING_ANY_ESCAPED, SQL_FILTER_STRING_ANY);
            }
            if (JdbcUtils.isH2MySqlOrPostgresDB()) {
                query = "SELECT ID, NAME, DESCRIPTION, PURPOSE_GROUP, GROUP_TYPE, TENANT_ID FROM CM_PURPOSE WHERE TENANT_ID = ? AND PURPOSE_GROUP LIKE ? AND GROUP_TYPE LIKE ? ORDER BY ID ASC LIMIT ? OFFSET ?";
            } else if (JdbcUtils.isDB2DB()) {
                query = "SELECT ID, NAME, DESCRIPTION, PURPOSE_GROUP, GROUP_TYPE, TENANT_ID FROM (SELECT ROW_NUMBER() OVER (ORDER BY ID) AS rn, p.* FROM CM_PURPOSE AS p) WHERE TENANT_ID =? AND PURPOSE_GROUP LIKE ? AND GROUP_TYPE LIKE ? AND rn BETWEEN ? AND ?";
                initialOffset = offset;
                offset += limit;
                limit = initialOffset + 1;
            } else if (JdbcUtils.isMSSqlDB()) {
                initialOffset = offset;
                offset = limit + offset;
                limit = initialOffset + 1;
                query = "SELECT ID, NAME, DESCRIPTION, PURPOSE_GROUP, GROUP_TYPE, TENANT_ID FROM (SELECT ID, NAME, DESCRIPTION, PURPOSE_GROUP, GROUP_TYPE, TENANT_ID, ROW_NUMBER() OVER (ORDER BY ID) AS RowNum FROM CM_PURPOSE) AS P WHERE P.TENANT_ID = ? AND PURPOSE_GROUP LIKE ? AND GROUP_TYPE LIKE ? AND P.RowNum BETWEEN ? AND ?";
            } else if (JdbcUtils.isInformixDB()) {
                query = "SELECT ID, NAME, DESCRIPTION, PURPOSE_GROUP, GROUP_TYPE, TENANT_ID FROM CM_PURPOSE WHERE TENANT_ID = ? AND PURPOSE_GROUP LIKE ? AND GROUP_TYPE LIKE ? ORDER BY ID ASC LIMIT ? OFFSET ?";
            } else {
                query = "SELECT ID, NAME, DESCRIPTION, PURPOSE_GROUP, GROUP_TYPE, TENANT_ID FROM (SELECT ID, NAME, DESCRIPTION, PURPOSE_GROUP, GROUP_TYPE, TENANT_ID, rownum AS rnum FROM (SELECT ID, NAME, DESCRIPTION, PURPOSE_GROUP, GROUP_TYPE, TENANT_ID FROM CM_PURPOSE ORDER BY ID) WHERE TENANT_ID =? AND PURPOSE_GROUP LIKE ? AND GROUP_TYPE LIKE ? AND rownum <= ?) WHERE rnum > ?";
                limit = offset + limit;
            }
            int finalLimit = limit;
            int finalOffset = offset;
            String finalGroup = group;
            String finalGroupType = groupType;
            purposes = jdbcTemplate.executeQuery(query, (resultSet, rowNumber) -> new Purpose(resultSet.getInt(1), resultSet.getString(2), resultSet.getString(3), resultSet.getString(4), resultSet.getString(5), resultSet.getInt(6)), preparedStatement -> {
                preparedStatement.setInt(1, tenantId);
                preparedStatement.setString(2, finalGroup);
                preparedStatement.setString(3, finalGroupType);
                preparedStatement.setInt(4, finalLimit);
                preparedStatement.setInt(5, finalOffset);
            });
        }
        catch (DataAccessException e) {
            throw new ConsentManagementServerException(String.format(ConsentConstants.ErrorMessages.ERROR_CODE_LIST_PURPOSE.getMessage(), group, groupType, limit, offset), ConsentConstants.ErrorMessages.ERROR_CODE_LIST_PURPOSE.getCode(), e);
        }
        return purposes;
    }

    @Override
    public int deletePurpose(int id) throws ConsentManagementException {
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        try {
            jdbcTemplate.executeUpdate("DELETE FROM CM_PURPOSE WHERE ID = ?", preparedStatement -> preparedStatement.setInt(1, id));
        }
        catch (DataAccessException e) {
            throw ConsentUtils.handleServerException(ConsentConstants.ErrorMessages.ERROR_CODE_DELETE_PURPOSE, String.valueOf(id), e);
        }
        return id;
    }

    @Override
    public void deletePurposesByTenantId(int tenantId) throws ConsentManagementException {
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        try {
            jdbcTemplate.executeUpdate("DELETE FROM CM_PURPOSE WHERE TENANT_ID = ?", preparedStatement -> preparedStatement.setInt(1, tenantId));
        }
        catch (DataAccessException e) {
            throw ConsentUtils.handleServerException(ConsentConstants.ErrorMessages.ERROR_CODE_DELETE_PURPOSES_BY_TENANT_ID, String.valueOf(tenantId), e);
        }
    }

    @Override
    public boolean isPurposeUsed(int id) throws ConsentManagementServerException {
        Integer count;
        try {
            JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
            count = (Integer)jdbcTemplate.fetchSingleRecord("SELECT COUNT(*) FROM CM_SP_PURPOSE_ASSOC WHERE PURPOSE_ID=?", (resultSet, rowNumber) -> resultSet.getInt(1), preparedStatement -> preparedStatement.setInt(1, id));
            if (count == null) {
                return false;
            }
        }
        catch (DataAccessException e) {
            throw ConsentUtils.handleServerException(ConsentConstants.ErrorMessages.ERROR_CODE_RETRIEVE_RECEIPTS_ASSOCIATED_WITH_PURPOSE, String.valueOf(id), e);
        }
        return count > 0;
    }
}

