/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.consent.mgt.core.dao.impl;

import java.util.List;
import org.wso2.carbon.consent.mgt.core.constant.ConsentConstants;
import org.wso2.carbon.consent.mgt.core.dao.PurposeCategoryDAO;
import org.wso2.carbon.consent.mgt.core.exception.ConsentManagementException;
import org.wso2.carbon.consent.mgt.core.exception.ConsentManagementServerException;
import org.wso2.carbon.consent.mgt.core.model.PurposeCategory;
import org.wso2.carbon.consent.mgt.core.util.ConsentUtils;
import org.wso2.carbon.consent.mgt.core.util.JdbcUtils;
import org.wso2.carbon.database.utils.jdbc.JdbcTemplate;
import org.wso2.carbon.database.utils.jdbc.exceptions.DataAccessException;

public class PurposeCategoryDAOImpl
implements PurposeCategoryDAO {
    @Override
    public int getPriority() {
        return 1;
    }

    @Override
    public PurposeCategory addPurposeCategory(PurposeCategory purposeCategory) throws ConsentManagementException {
        int insertedId;
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        try {
            insertedId = jdbcTemplate.executeInsert("INSERT INTO CM_PURPOSE_CATEGORY (NAME, DESCRIPTION, TENANT_ID) VALUES (?,?,?)", preparedStatement -> {
                preparedStatement.setString(1, purposeCategory.getName());
                preparedStatement.setString(2, purposeCategory.getDescription());
                preparedStatement.setInt(3, purposeCategory.getTenantId());
            }, (Object)purposeCategory, true);
        }
        catch (DataAccessException e) {
            throw ConsentUtils.handleServerException(ConsentConstants.ErrorMessages.ERROR_CODE_ADD_PURPOSE_CATEGORY, purposeCategory.getName(), e);
        }
        PurposeCategory purposeCategoryResult = new PurposeCategory(insertedId, purposeCategory.getName(), purposeCategory.getDescription(), purposeCategory.getTenantId());
        return purposeCategoryResult;
    }

    @Override
    public PurposeCategory getPurposeCategoryById(int id) throws ConsentManagementException {
        PurposeCategory purposeCategory;
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        try {
            purposeCategory = (PurposeCategory)jdbcTemplate.fetchSingleRecord("SELECT ID, NAME, DESCRIPTION, TENANT_ID FROM CM_PURPOSE_CATEGORY  WHERE ID = ?", (resultSet, rowNumber) -> new PurposeCategory(resultSet.getInt(1), resultSet.getString(2), resultSet.getString(3), resultSet.getInt(4)), preparedStatement -> preparedStatement.setInt(1, id));
        }
        catch (DataAccessException e) {
            throw ConsentUtils.handleServerException(ConsentConstants.ErrorMessages.ERROR_CODE_SELECT_PURPOSE_CATEGORY_BY_ID, String.valueOf(id), e);
        }
        return purposeCategory;
    }

    @Override
    public List<PurposeCategory> listPurposeCategories(int limit, int offset, int tenantId) throws ConsentManagementException {
        List purposesCategories;
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        try {
            int initialOffset;
            String query;
            if (JdbcUtils.isH2MySqlOrPostgresDB()) {
                query = "SELECT ID, NAME, DESCRIPTION, TENANT_ID FROM CM_PURPOSE_CATEGORY WHERE TENANT_ID = ? ORDER BY ID ASC LIMIT ? OFFSET ?";
            } else if (JdbcUtils.isDB2DB()) {
                query = "SELECT ID, NAME, DESCRIPTION, TENANT_ID FROM (SELECT ROW_NUMBER() OVER (ORDER BY ID) AS rn, p.*  FROM CM_PURPOSE_CATEGORY AS p) WHERE TENANT_ID =? AND rn BETWEEN ? AND ?";
                initialOffset = offset;
                offset += limit;
                limit = initialOffset + 1;
            } else if (JdbcUtils.isMSSqlDB()) {
                query = "SELECT ID, NAME, DESCRIPTION, TENANT_ID FROM (SELECT ID, NAME, DESCRIPTION, TENANT_ID, ROW_NUMBER() OVER (ORDER BY ID) AS RowNum FROM CM_PURPOSE_CATEGORY) AS P WHERE P.TENANT_ID = ? AND P.RowNum BETWEEN ? AND ?";
                initialOffset = offset;
                offset = limit + offset;
                limit = initialOffset + 1;
            } else if (JdbcUtils.isInformixDB()) {
                query = "SELECT ID, NAME, DESCRIPTION, TENANT_ID FROM CM_PURPOSE_CATEGORY WHERE TENANT_ID = ? ORDER BY ID ASC LIMIT ? OFFSET ?";
            } else {
                query = "SELECT ID, NAME, DESCRIPTION, TENANT_ID FROM (SELECT ID, NAME, DESCRIPTION, TENANT_ID, rownum AS rnum FROM (SELECT ID, NAME, DESCRIPTION, TENANT_ID FROM CM_PURPOSE_CATEGORY ORDER BY ID) WHERE TENANT_ID =? AND rownum <= ?) WHERE  rnum > ?";
                limit = offset + limit;
            }
            int finalLimit = limit;
            int finalOffset = offset;
            purposesCategories = jdbcTemplate.executeQuery(query, (resultSet, rowNumber) -> new PurposeCategory(resultSet.getInt(1), resultSet.getString(2), resultSet.getString(3), resultSet.getInt(4)), preparedStatement -> {
                preparedStatement.setInt(1, tenantId);
                preparedStatement.setInt(2, finalLimit);
                preparedStatement.setInt(3, finalOffset);
            });
        }
        catch (DataAccessException e) {
            throw new ConsentManagementServerException(String.format(ConsentConstants.ErrorMessages.ERROR_CODE_LIST_PURPOSE_CATEGORY.getMessage(), limit, offset), ConsentConstants.ErrorMessages.ERROR_CODE_LIST_PURPOSE_CATEGORY.getCode(), e);
        }
        return purposesCategories;
    }

    @Override
    public int deletePurposeCategory(int id) throws ConsentManagementException {
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        try {
            jdbcTemplate.executeUpdate("DELETE FROM CM_PURPOSE_CATEGORY WHERE ID = ?", preparedStatement -> preparedStatement.setInt(1, id));
        }
        catch (DataAccessException e) {
            throw ConsentUtils.handleServerException(ConsentConstants.ErrorMessages.ERROR_CODE_DELETE_PURPOSE_CATEGORY, String.valueOf(id), e);
        }
        return id;
    }

    @Override
    public void deletePurposeCategoriesByTenantId(int tenantId) throws ConsentManagementException {
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        try {
            jdbcTemplate.executeUpdate("DELETE FROM CM_PURPOSE_CATEGORY WHERE TENANT_ID = ?", preparedStatement -> preparedStatement.setInt(1, tenantId));
        }
        catch (DataAccessException e) {
            throw ConsentUtils.handleServerException(ConsentConstants.ErrorMessages.ERROR_CODE_DELETE_PURPOSE_CATEGORIES_BY_TENANT_ID, String.valueOf(tenantId), e);
        }
    }

    @Override
    public PurposeCategory getPurposeCategoryByName(String name, int tenantId) throws ConsentManagementException {
        PurposeCategory purposeCategory;
        JdbcTemplate jdbcTemplate = JdbcUtils.getNewTemplate();
        try {
            purposeCategory = (PurposeCategory)jdbcTemplate.fetchSingleRecord("SELECT ID, NAME, DESCRIPTION, TENANT_ID FROM CM_PURPOSE_CATEGORY WHERE NAME = ? AND TENANT_ID = ?", (resultSet, rowNumber) -> new PurposeCategory(resultSet.getInt(1), resultSet.getString(2), resultSet.getString(3), resultSet.getInt(4)), preparedStatement -> {
                preparedStatement.setString(1, name);
                preparedStatement.setInt(2, tenantId);
            });
        }
        catch (DataAccessException e) {
            throw ConsentUtils.handleServerException(ConsentConstants.ErrorMessages.ERROR_CODE_SELECT_PURPOSE_CATEGORY_BY_NAME, name, e);
        }
        return purposeCategory;
    }
}

