/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.consent.mgt.core.util;

import org.apache.commons.lang.StringUtils;
import org.wso2.carbon.consent.mgt.core.constant.ConsentConstants;
import org.wso2.carbon.consent.mgt.core.exception.ConsentManagementClientException;
import org.wso2.carbon.consent.mgt.core.exception.ConsentManagementException;
import org.wso2.carbon.consent.mgt.core.exception.ConsentManagementRuntimeException;
import org.wso2.carbon.consent.mgt.core.exception.ConsentManagementServerException;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.service.RealmService;

public class ConsentUtils {
    public static ConsentManagementServerException handleServerException(ConsentConstants.ErrorMessages error, String data) {
        String message = StringUtils.isNotBlank((String)data) ? String.format(error.getMessage(), data) : error.getMessage();
        return new ConsentManagementServerException(message, error.getCode());
    }

    public static ConsentManagementServerException handleServerException(ConsentConstants.ErrorMessages error, String data, Throwable e) {
        String message = StringUtils.isNotBlank((String)data) ? String.format(error.getMessage(), data) : error.getMessage();
        return new ConsentManagementServerException(message, error.getCode(), e);
    }

    public static ConsentManagementClientException handleClientException(ConsentConstants.ErrorMessages error, String data) {
        String message = StringUtils.isNotBlank((String)data) ? String.format(error.getMessage(), data) : error.getMessage();
        return new ConsentManagementClientException(message, error.getCode());
    }

    public static ConsentManagementClientException handleClientException(ConsentConstants.ErrorMessages error, String data, Throwable e) {
        String message = StringUtils.isNotBlank((String)data) ? String.format(error.getMessage(), data) : error.getMessage();
        return new ConsentManagementClientException(message, error.getCode(), e);
    }

    public static ConsentManagementRuntimeException handleRuntimeException(ConsentConstants.ErrorMessages error, String data, Throwable e) {
        String message = StringUtils.isNotBlank((String)data) ? String.format(error.getMessage(), data) : error.getMessage();
        return new ConsentManagementRuntimeException(message, error.getCode(), e);
    }

    public static ConsentManagementRuntimeException handleRuntimeException(ConsentConstants.ErrorMessages error, String data) {
        String message = StringUtils.isNotBlank((String)data) ? String.format(error.getMessage(), data) : error.getMessage();
        return new ConsentManagementRuntimeException(message, error.getCode());
    }

    public static int getTenantId(RealmService realmService, String tenantDomain) throws ConsentManagementException {
        int tenantId;
        try {
            tenantId = realmService.getTenantManager().getTenantId(tenantDomain);
        }
        catch (UserStoreException e) {
            throw ConsentUtils.handleServerException(ConsentConstants.ErrorMessages.ERROR_CODE_RETRIEVE_TENANT_ID, tenantDomain, e);
        }
        if (tenantId == -1) {
            throw ConsentUtils.handleClientException(ConsentConstants.ErrorMessages.ERROR_CODE_INVALID_TENANT_DOMAIN, tenantDomain);
        }
        return tenantId;
    }

    public static String getTenantDomain(RealmService realmService, int tenantId) throws ConsentManagementServerException {
        String tenantDomain;
        try {
            tenantDomain = realmService.getTenantManager().getDomain(tenantId);
        }
        catch (UserStoreException e) {
            throw ConsentUtils.handleServerException(ConsentConstants.ErrorMessages.ERROR_CODE_RETRIEVE_TENANT_DOMAIN, Integer.toString(tenantId), e);
        }
        if (tenantDomain == null) {
            throw ConsentUtils.handleServerException(ConsentConstants.ErrorMessages.ERROR_CODE_INVALID_TENANT_ID, Integer.toString(tenantId));
        }
        return tenantDomain;
    }

    public static String getTenantDomainFromCarbonContext() {
        return PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantDomain();
    }

    public static int getTenantIdFromCarbonContext() {
        return PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
    }
}

