/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.consent.mgt.core;

import java.util.List;
import java.util.Map;
import org.wso2.carbon.consent.mgt.core.ConsentManager;
import org.wso2.carbon.consent.mgt.core.ConsentManagerImpl;
import org.wso2.carbon.consent.mgt.core.PrivilegedConsentManager;
import org.wso2.carbon.consent.mgt.core.connector.ConsentMgtInterceptor;
import org.wso2.carbon.consent.mgt.core.exception.ConsentManagementException;
import org.wso2.carbon.consent.mgt.core.model.AddReceiptResponse;
import org.wso2.carbon.consent.mgt.core.model.ConsentInterceptorTemplate;
import org.wso2.carbon.consent.mgt.core.model.ConsentManagerConfigurationHolder;
import org.wso2.carbon.consent.mgt.core.model.ConsentMessageContext;
import org.wso2.carbon.consent.mgt.core.model.OperationDelegate;
import org.wso2.carbon.consent.mgt.core.model.PIICategory;
import org.wso2.carbon.consent.mgt.core.model.Purpose;
import org.wso2.carbon.consent.mgt.core.model.PurposeCategory;
import org.wso2.carbon.consent.mgt.core.model.Receipt;
import org.wso2.carbon.consent.mgt.core.model.ReceiptInput;
import org.wso2.carbon.consent.mgt.core.model.ReceiptListResponse;

public class PrivilegedConsentManagerImpl
implements PrivilegedConsentManager {
    private ConsentManager consentManager;
    protected List<ConsentMgtInterceptor> consentMgtInterceptors;

    public PrivilegedConsentManagerImpl(ConsentManagerConfigurationHolder configHolder, List<ConsentMgtInterceptor> consentMgtInterceptors) {
        this.consentManager = new ConsentManagerImpl(configHolder);
        this.consentMgtInterceptors = consentMgtInterceptors;
    }

    @Override
    public Purpose addPurpose(final Purpose purpose) throws ConsentManagementException {
        ConsentMessageContext context = new ConsentMessageContext();
        ConsentInterceptorTemplate template = new ConsentInterceptorTemplate(this.consentMgtInterceptors, context);
        return template.intercept("PRE_ADD_PURPOSE", properties -> properties.put("PURPOSE", purpose)).executeWith(new OperationDelegate<Purpose>(){

            @Override
            public Purpose execute() throws ConsentManagementException {
                return PrivilegedConsentManagerImpl.this.consentManager.addPurpose(purpose);
            }
        }).intercept("POST_ADD_PURPOSE", properties -> properties.put("PURPOSE", purpose)).getResult();
    }

    @Override
    public Purpose getPurpose(final int purposeId) throws ConsentManagementException {
        ConsentMessageContext context = new ConsentMessageContext();
        ConsentInterceptorTemplate template = new ConsentInterceptorTemplate(this.consentMgtInterceptors, context);
        return template.intercept("PRE_GET_PURPOSE", properties -> properties.put("PURPOSE_ID", purposeId)).executeWith(new OperationDelegate<Purpose>(){

            @Override
            public Purpose execute() throws ConsentManagementException {
                return PrivilegedConsentManagerImpl.this.consentManager.getPurpose(purposeId);
            }
        }).intercept("POST_GET_PURPOSE", properties -> properties.put("PURPOSE_ID", purposeId)).getResult();
    }

    @Override
    public Purpose getPurposeByName(final String name, final String group, final String groupType) throws ConsentManagementException {
        ConsentMessageContext context = new ConsentMessageContext();
        ConsentInterceptorTemplate template = new ConsentInterceptorTemplate(this.consentMgtInterceptors, context);
        return template.intercept("PRE_GET_PURPOSE_BY_NAME", properties -> {
            properties.put("PURPOSE_NAME", name);
            properties.put("GROUP", group);
            properties.put("GROUP_TYPE", groupType);
        }).executeWith(new OperationDelegate<Purpose>(){

            @Override
            public Purpose execute() throws ConsentManagementException {
                return PrivilegedConsentManagerImpl.this.consentManager.getPurposeByName(name, group, groupType);
            }
        }).intercept("POST_GET_PURPOSE_BY_NAME", properties -> properties.put("PURPOSE_NAME", name)).getResult();
    }

    @Override
    public List<Purpose> listPurposes(final int limit, final int offset) throws ConsentManagementException {
        ConsentMessageContext context = new ConsentMessageContext();
        ConsentInterceptorTemplate template = new ConsentInterceptorTemplate(this.consentMgtInterceptors, context);
        return template.intercept("PRE_GET_PURPOSE_LIST", properties -> {
            properties.put("LIMIT", limit);
            properties.put("OFFSET", offset);
        }).executeWith(new OperationDelegate<List<Purpose>>(){

            @Override
            public List<Purpose> execute() throws ConsentManagementException {
                return PrivilegedConsentManagerImpl.this.consentManager.listPurposes(limit, offset);
            }
        }).intercept("POST_GET_PURPOSE_LIST", properties -> {
            properties.put("LIMIT", limit);
            properties.put("OFFSET", offset);
        }).getResult();
    }

    @Override
    public List<Purpose> listPurposes(final String group, final String groupType, final int limit, final int offset) throws ConsentManagementException {
        ConsentMessageContext context = new ConsentMessageContext();
        ConsentInterceptorTemplate template = new ConsentInterceptorTemplate(this.consentMgtInterceptors, context);
        return template.intercept("PRE_GET_PURPOSE_LIST", properties -> {
            properties.put("GROUP", group);
            properties.put("GROUP_TYPE", groupType);
            properties.put("LIMIT", limit);
            properties.put("OFFSET", offset);
        }).executeWith(new OperationDelegate<List<Purpose>>(){

            @Override
            public List<Purpose> execute() throws ConsentManagementException {
                return PrivilegedConsentManagerImpl.this.consentManager.listPurposes(group, groupType, limit, offset);
            }
        }).intercept("POST_GET_PURPOSE_LIST", properties -> {
            properties.put("LIMIT", limit);
            properties.put("OFFSET", offset);
        }).getResult();
    }

    @Override
    public void deletePurpose(final int purposeId) throws ConsentManagementException {
        ConsentMessageContext context = new ConsentMessageContext();
        ConsentInterceptorTemplate template = new ConsentInterceptorTemplate(this.consentMgtInterceptors, context);
        template.intercept("PRE_DELETE_PURPOSE", properties -> properties.put("PURPOSE_ID", purposeId)).executeWith(new OperationDelegate<Void>(){

            @Override
            public Void execute() throws ConsentManagementException {
                PrivilegedConsentManagerImpl.this.consentManager.deletePurpose(purposeId);
                return null;
            }
        }).intercept("POST_DELETE_PURPOSE", properties -> properties.put("PURPOSE_ID", purposeId));
    }

    @Override
    public void deletePurposes(final int tenantId) throws ConsentManagementException {
        ConsentMessageContext context = new ConsentMessageContext();
        ConsentInterceptorTemplate template = new ConsentInterceptorTemplate(this.consentMgtInterceptors, context);
        template.intercept("PRE_DELETE_PURPOSES", properties -> properties.put("TENANT_ID", tenantId)).executeWith(new OperationDelegate<Void>(){

            @Override
            public Void execute() throws ConsentManagementException {
                PrivilegedConsentManagerImpl.this.consentManager.deletePurposes(tenantId);
                return null;
            }
        }).intercept("POST_DELETE_PURPOSES", properties -> properties.put("TENANT_ID", tenantId));
    }

    @Override
    public boolean isPurposeExists(final String name, final String group, final String groupType) throws ConsentManagementException {
        ConsentMessageContext context = new ConsentMessageContext();
        ConsentInterceptorTemplate template = new ConsentInterceptorTemplate(this.consentMgtInterceptors, context);
        return template.intercept("PRE_IS_PURPOSE_EXIST", properties -> {
            properties.put("PURPOSE_NAME", name);
            properties.put("GROUP", group);
            properties.put("GROUP_TYPE", groupType);
        }).executeWith(new OperationDelegate<Boolean>(){

            @Override
            public Boolean execute() throws ConsentManagementException {
                return PrivilegedConsentManagerImpl.this.consentManager.isPurposeExists(name, group, groupType);
            }
        }).intercept("POST_IS_PURPOSE_EXIST", properties -> properties.put("PURPOSE_NAME", name)).getResult();
    }

    @Override
    public PurposeCategory addPurposeCategory(final PurposeCategory purposeCategory) throws ConsentManagementException {
        ConsentMessageContext context = new ConsentMessageContext();
        ConsentInterceptorTemplate template = new ConsentInterceptorTemplate(this.consentMgtInterceptors, context);
        return template.intercept("PRE_ADD_PURPOSE_CATEGORY", properties -> properties.put("PURPOSE_CATEGORY", purposeCategory)).executeWith(new OperationDelegate<PurposeCategory>(){

            @Override
            public PurposeCategory execute() throws ConsentManagementException {
                return PrivilegedConsentManagerImpl.this.consentManager.addPurposeCategory(purposeCategory);
            }
        }).intercept("POST_ADD_PURPOSE_CATEGORY", properties -> properties.put("PURPOSE_CATEGORY", purposeCategory)).getResult();
    }

    @Override
    public PurposeCategory getPurposeCategory(final int purposeCategoryId) throws ConsentManagementException {
        ConsentMessageContext context = new ConsentMessageContext();
        ConsentInterceptorTemplate template = new ConsentInterceptorTemplate(this.consentMgtInterceptors, context);
        return template.intercept("PRE_GET_PURPOSE_CATEGORY", properties -> properties.put("PURPOSE_CATEGORY_ID", purposeCategoryId)).executeWith(new OperationDelegate<PurposeCategory>(){

            @Override
            public PurposeCategory execute() throws ConsentManagementException {
                return PrivilegedConsentManagerImpl.this.consentManager.getPurposeCategory(purposeCategoryId);
            }
        }).intercept("POST_GET_PURPOSE_CATEGORY", properties -> properties.put("PURPOSE_CATEGORY_ID", purposeCategoryId)).getResult();
    }

    @Override
    public PurposeCategory getPurposeCategoryByName(final String name) throws ConsentManagementException {
        ConsentMessageContext context = new ConsentMessageContext();
        ConsentInterceptorTemplate template = new ConsentInterceptorTemplate(this.consentMgtInterceptors, context);
        return template.intercept("PRE_GET_PURPOSE_CATEGORY_BY_NAME", properties -> properties.put("PURPOSE_CATEGORY_NAME", name)).executeWith(new OperationDelegate<PurposeCategory>(){

            @Override
            public PurposeCategory execute() throws ConsentManagementException {
                return PrivilegedConsentManagerImpl.this.consentManager.getPurposeCategoryByName(name);
            }
        }).intercept("POST_GET_PURPOSE_CATEGORY_BY_NAME", properties -> properties.put("PURPOSE_CATEGORY_NAME", name)).getResult();
    }

    @Override
    public List<PurposeCategory> listPurposeCategories(final int limit, final int offset) throws ConsentManagementException {
        ConsentMessageContext context = new ConsentMessageContext();
        ConsentInterceptorTemplate template = new ConsentInterceptorTemplate(this.consentMgtInterceptors, context);
        return template.intercept("PRE_GET_PURPOSE_CATEGORY_LIST", properties -> {
            properties.put("LIMIT", limit);
            properties.put("OFFSET", offset);
        }).executeWith(new OperationDelegate<List<PurposeCategory>>(){

            @Override
            public List<PurposeCategory> execute() throws ConsentManagementException {
                return PrivilegedConsentManagerImpl.this.consentManager.listPurposeCategories(limit, offset);
            }
        }).intercept("POST_GET_PURPOSE_CATEGORY_LIST", properties -> {
            properties.put("LIMIT", limit);
            properties.put("OFFSET", offset);
        }).getResult();
    }

    @Override
    public void deletePurposeCategory(final int purposeCategoryId) throws ConsentManagementException {
        ConsentMessageContext context = new ConsentMessageContext();
        ConsentInterceptorTemplate template = new ConsentInterceptorTemplate(this.consentMgtInterceptors, context);
        template.intercept("PRE_DELETE_PURPOSE_CATEGORY", properties -> properties.put("PURPOSE_CATEGORY_ID", purposeCategoryId)).executeWith(new OperationDelegate<Void>(){

            @Override
            public Void execute() throws ConsentManagementException {
                PrivilegedConsentManagerImpl.this.consentManager.deletePurposeCategory(purposeCategoryId);
                return null;
            }
        }).intercept("POST_DELETE_PURPOSE_CATEGORY", properties -> properties.put("PURPOSE_CATEGORY_ID", purposeCategoryId));
    }

    @Override
    public void deletePurposeCategories(final int tenantId) throws ConsentManagementException {
        ConsentMessageContext context = new ConsentMessageContext();
        ConsentInterceptorTemplate template = new ConsentInterceptorTemplate(this.consentMgtInterceptors, context);
        template.intercept("PRE_DELETE_PURPOSE_CATEGORIES", properties -> properties.put("TENANT_ID", tenantId)).executeWith(new OperationDelegate<Void>(){

            @Override
            public Void execute() throws ConsentManagementException {
                PrivilegedConsentManagerImpl.this.consentManager.deletePurposeCategories(tenantId);
                return null;
            }
        }).intercept("POST_DELETE_PURPOSE_CATEGORIES", properties -> properties.put("TENANT_ID", tenantId));
    }

    @Override
    public boolean isPurposeCategoryExists(final String name) throws ConsentManagementException {
        ConsentMessageContext context = new ConsentMessageContext();
        ConsentInterceptorTemplate template = new ConsentInterceptorTemplate(this.consentMgtInterceptors, context);
        return template.intercept("PRE_IS_PURPOSE_CATEGORY_EXIST", properties -> properties.put("PURPOSE_CATEGORY_NAME", name)).executeWith(new OperationDelegate<Boolean>(){

            @Override
            public Boolean execute() throws ConsentManagementException {
                return PrivilegedConsentManagerImpl.this.consentManager.isPurposeCategoryExists(name);
            }
        }).intercept("POST_IS_PURPOSE_CATEGORY_EXIST", properties -> properties.put("PURPOSE_CATEGORY_NAME", name)).getResult();
    }

    @Override
    public PIICategory addPIICategory(final PIICategory piiCategory) throws ConsentManagementException {
        ConsentMessageContext context = new ConsentMessageContext();
        ConsentInterceptorTemplate template = new ConsentInterceptorTemplate(this.consentMgtInterceptors, context);
        return template.intercept("PRE_ADD_PII_CATEGORY", properties -> properties.put("PII_CATEGORY", piiCategory)).executeWith(new OperationDelegate<PIICategory>(){

            @Override
            public PIICategory execute() throws ConsentManagementException {
                return PrivilegedConsentManagerImpl.this.consentManager.addPIICategory(piiCategory);
            }
        }).intercept("POST_ADD_PII_CATEGORY", properties -> properties.put("PII_CATEGORY", piiCategory)).getResult();
    }

    @Override
    public PIICategory getPIICategoryByName(final String name) throws ConsentManagementException {
        ConsentMessageContext context = new ConsentMessageContext();
        ConsentInterceptorTemplate template = new ConsentInterceptorTemplate(this.consentMgtInterceptors, context);
        return template.intercept("PRE_GET_PII_CATEGORY_BY_NAME", properties -> properties.put("PII_CATEGORY_NAME", name)).executeWith(new OperationDelegate<PIICategory>(){

            @Override
            public PIICategory execute() throws ConsentManagementException {
                return PrivilegedConsentManagerImpl.this.consentManager.getPIICategoryByName(name);
            }
        }).intercept("POST_GET_PII_CATEGORY_BY_NAME", properties -> properties.put("PII_CATEGORY_NAME", name)).getResult();
    }

    @Override
    public PIICategory getPIICategory(final int piiCategoryId) throws ConsentManagementException {
        ConsentMessageContext context = new ConsentMessageContext();
        ConsentInterceptorTemplate template = new ConsentInterceptorTemplate(this.consentMgtInterceptors, context);
        return template.intercept("PRE_GET_PII_CATEGORY", properties -> properties.put("PII_CATEGORY_ID", piiCategoryId)).executeWith(new OperationDelegate<PIICategory>(){

            @Override
            public PIICategory execute() throws ConsentManagementException {
                return PrivilegedConsentManagerImpl.this.consentManager.getPIICategory(piiCategoryId);
            }
        }).intercept("POST_GET_PII_CATEGORY", properties -> properties.put("PII_CATEGORY_ID", piiCategoryId)).getResult();
    }

    @Override
    public List<PIICategory> listPIICategories(final int limit, final int offset) throws ConsentManagementException {
        ConsentMessageContext context = new ConsentMessageContext();
        ConsentInterceptorTemplate template = new ConsentInterceptorTemplate(this.consentMgtInterceptors, context);
        return template.intercept("PRE_GET_PII_CATEGORY_LIST", properties -> {
            properties.put("LIMIT", limit);
            properties.put("OFFSET", offset);
        }).executeWith(new OperationDelegate<List<PIICategory>>(){

            @Override
            public List<PIICategory> execute() throws ConsentManagementException {
                return PrivilegedConsentManagerImpl.this.consentManager.listPIICategories(limit, offset);
            }
        }).intercept("POST_GET_PII_CATEGORY_LIST", properties -> {
            properties.put("LIMIT", limit);
            properties.put("OFFSET", offset);
        }).getResult();
    }

    @Override
    public void deletePIICategory(final int piiCategoryId) throws ConsentManagementException {
        ConsentMessageContext context = new ConsentMessageContext();
        ConsentInterceptorTemplate template = new ConsentInterceptorTemplate(this.consentMgtInterceptors, context);
        template.intercept("PRE_DELETE_PII_CATEGORY", properties -> properties.put("PII_CATEGORY_ID", piiCategoryId)).executeWith(new OperationDelegate<Void>(){

            @Override
            public Void execute() throws ConsentManagementException {
                PrivilegedConsentManagerImpl.this.consentManager.deletePIICategory(piiCategoryId);
                return null;
            }
        }).intercept("POST_DELETE_PII_CATEGORY", properties -> properties.put("PII_CATEGORY_ID", piiCategoryId));
    }

    @Override
    public void deletePIICategories(final int tenantId) throws ConsentManagementException {
        ConsentMessageContext context = new ConsentMessageContext();
        ConsentInterceptorTemplate template = new ConsentInterceptorTemplate(this.consentMgtInterceptors, context);
        template.intercept("PRE_DELETE_PII_CATEGORIES", properties -> properties.put("TENANT_ID", tenantId)).executeWith(new OperationDelegate<Void>(){

            @Override
            public Void execute() throws ConsentManagementException {
                PrivilegedConsentManagerImpl.this.consentManager.deletePIICategories(tenantId);
                return null;
            }
        }).intercept("POST_DELETE_PII_CATEGORIES", properties -> properties.put("TENANT_ID", tenantId));
    }

    @Override
    public boolean isPIICategoryExists(final String name) throws ConsentManagementException {
        ConsentMessageContext context = new ConsentMessageContext();
        ConsentInterceptorTemplate template = new ConsentInterceptorTemplate(this.consentMgtInterceptors, context);
        return template.intercept("PRE_IS_PII_CATEGORY_EXIST", properties -> properties.put("PII_CATEGORY_NAME", name)).executeWith(new OperationDelegate<Boolean>(){

            @Override
            public Boolean execute() throws ConsentManagementException {
                return PrivilegedConsentManagerImpl.this.consentManager.isPIICategoryExists(name);
            }
        }).intercept("POST_IS_PII_CATEGORY_EXIST", properties -> properties.put("PII_CATEGORY_NAME", name)).getResult();
    }

    @Override
    public AddReceiptResponse addConsent(final ReceiptInput receiptInput) throws ConsentManagementException {
        ConsentMessageContext context = new ConsentMessageContext();
        ConsentInterceptorTemplate template = new ConsentInterceptorTemplate(this.consentMgtInterceptors, context);
        return template.intercept("PRE_ADD_RECEIPT", properties -> properties.put("RECEIPT_INPUT", receiptInput)).executeWith(new OperationDelegate<AddReceiptResponse>(){

            @Override
            public AddReceiptResponse execute() throws ConsentManagementException {
                return PrivilegedConsentManagerImpl.this.consentManager.addConsent(receiptInput);
            }
        }).intercept("POST_ADD_RECEIPT", properties -> properties.put("RECEIPT_INPUT", receiptInput)).getResult();
    }

    @Override
    public Receipt getReceipt(final String receiptId) throws ConsentManagementException {
        ConsentMessageContext context = new ConsentMessageContext();
        ConsentInterceptorTemplate template = new ConsentInterceptorTemplate(this.consentMgtInterceptors, context);
        return template.intercept("PRE_GET_RECEIPT", properties -> properties.put("RECEIPT_ID", receiptId)).executeWith(new OperationDelegate<Receipt>(){

            @Override
            public Receipt execute() throws ConsentManagementException {
                return PrivilegedConsentManagerImpl.this.consentManager.getReceipt(receiptId);
            }
        }).intercept("POST_GET_RECEIPT", properties -> properties.put("RECEIPT_ID", receiptId)).getResult();
    }

    @Override
    public List<ReceiptListResponse> searchReceipts(final int limit, final int offset, final String piiPrincipalId, final String spTenantDomain, final String service, final String state) throws ConsentManagementException {
        ConsentMessageContext context = new ConsentMessageContext();
        ConsentInterceptorTemplate template = new ConsentInterceptorTemplate(this.consentMgtInterceptors, context);
        return template.intercept("PRE_LIST_RECEIPTS", properties -> this.populateProperties(limit, offset, piiPrincipalId, spTenantDomain, service, state, properties)).executeWith(new OperationDelegate<List<ReceiptListResponse>>(){

            @Override
            public List<ReceiptListResponse> execute() throws ConsentManagementException {
                return PrivilegedConsentManagerImpl.this.consentManager.searchReceipts(limit, offset, piiPrincipalId, spTenantDomain, service, state);
            }
        }).intercept("POST_LIST_RECEIPTS", properties -> this.populateProperties(limit, offset, piiPrincipalId, spTenantDomain, service, state, properties)).getResult();
    }

    @Override
    public List<ReceiptListResponse> searchReceipts(final int limit, final int offset, final String piiPrincipalId, final String spTenantDomain, final String service, final String state, final String principalTenantDomain) throws ConsentManagementException {
        ConsentMessageContext context = new ConsentMessageContext();
        ConsentInterceptorTemplate template = new ConsentInterceptorTemplate(this.consentMgtInterceptors, context);
        return template.intercept("PRE_LIST_RECEIPTS", properties -> this.populateProperties(limit, offset, piiPrincipalId, spTenantDomain, service, state, principalTenantDomain, properties)).executeWith(new OperationDelegate<List<ReceiptListResponse>>(){

            @Override
            public List<ReceiptListResponse> execute() throws ConsentManagementException {
                return PrivilegedConsentManagerImpl.this.consentManager.searchReceipts(limit, offset, piiPrincipalId, spTenantDomain, service, state, principalTenantDomain);
            }
        }).intercept("POST_LIST_RECEIPTS", properties -> this.populateProperties(limit, offset, piiPrincipalId, spTenantDomain, service, state, principalTenantDomain, properties)).getResult();
    }

    @Override
    public void revokeReceipt(final String receiptId) throws ConsentManagementException {
        ConsentMessageContext context = new ConsentMessageContext();
        ConsentInterceptorTemplate template = new ConsentInterceptorTemplate(this.consentMgtInterceptors, context);
        template.intercept("PRE_REVOKE_RECEIPT", properties -> properties.put("RECEIPT_ID", receiptId)).executeWith(new OperationDelegate<Void>(){

            @Override
            public Void execute() throws ConsentManagementException {
                PrivilegedConsentManagerImpl.this.consentManager.revokeReceipt(receiptId);
                return null;
            }
        }).intercept("POST_REVOKE_RECEIPT", properties -> properties.put("RECEIPT_ID", receiptId));
    }

    @Override
    public void deleteReceipt(final String receiptId) throws ConsentManagementException {
        ConsentMessageContext context = new ConsentMessageContext();
        ConsentInterceptorTemplate template = new ConsentInterceptorTemplate(this.consentMgtInterceptors, context);
        template.intercept("PRE_DELETE_RECEIPT", properties -> properties.put("RECEIPT_ID", receiptId)).executeWith(new OperationDelegate<Void>(){

            @Override
            public Void execute() throws ConsentManagementException {
                PrivilegedConsentManagerImpl.this.consentManager.deleteReceipt(receiptId);
                return null;
            }
        }).intercept("POST_DELETE_RECEIPT", properties -> properties.put("RECEIPT_ID", receiptId));
    }

    @Override
    public void deleteReceipts(final int tenantId) throws ConsentManagementException {
        ConsentMessageContext context = new ConsentMessageContext();
        ConsentInterceptorTemplate template = new ConsentInterceptorTemplate(this.consentMgtInterceptors, context);
        template.intercept("PRE_DELETE_RECEIPTS", properties -> properties.put("TENANT_ID", tenantId)).executeWith(new OperationDelegate<Void>(){

            @Override
            public Void execute() throws ConsentManagementException {
                PrivilegedConsentManagerImpl.this.consentManager.deleteReceipts(tenantId);
                return null;
            }
        }).intercept("POST_DELETE_RECEIPTS", properties -> properties.put("TENANT_ID", tenantId));
    }

    @Override
    public boolean isReceiptExist(String receiptId, String tenantAwareUsername, int tenantId) throws ConsentManagementException {
        return this.consentManager.isReceiptExist(receiptId, tenantAwareUsername, tenantId);
    }

    private void populateProperties(int limit, int offset, String piiPrincipalId, String spTenantDomain, String service, String state, Map<String, Object> properties) {
        properties.put("LIMIT", limit);
        properties.put("OFFSET", offset);
        properties.put("PII_PRINCIPAL_ID", piiPrincipalId);
        properties.put("SP_TENANT_DOMAIN", spTenantDomain);
        properties.put("SERVICE", service);
        properties.put("STATE", state);
    }

    private void populateProperties(int limit, int offset, String piiPrincipalId, String spTenantDomain, String service, String state, String principalTenantDomain, Map<String, Object> properties) {
        properties.put("LIMIT", limit);
        properties.put("OFFSET", offset);
        properties.put("PII_PRINCIPAL_ID", piiPrincipalId);
        properties.put("SP_TENANT_DOMAIN", spTenantDomain);
        properties.put("SERVICE", service);
        properties.put("STATE", state);
        properties.put("PRINCIPAL_TENANT_DOMAIN", principalTenantDomain);
    }
}

