/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.consent.mgt.core;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.consent.mgt.core.PrivilegedConsentManagerImpl;
import org.wso2.carbon.consent.mgt.core.connector.ConsentMgtInterceptor;
import org.wso2.carbon.consent.mgt.core.constant.ConsentConstants;
import org.wso2.carbon.consent.mgt.core.exception.ConsentManagementClientException;
import org.wso2.carbon.consent.mgt.core.exception.ConsentManagementException;
import org.wso2.carbon.consent.mgt.core.model.ConsentManagerConfigurationHolder;
import org.wso2.carbon.consent.mgt.core.model.Receipt;
import org.wso2.carbon.consent.mgt.core.model.ReceiptListResponse;
import org.wso2.carbon.consent.mgt.core.util.ConsentUtils;
import org.wso2.carbon.context.PrivilegedCarbonContext;
import org.wso2.carbon.user.api.AuthorizationManager;
import org.wso2.carbon.user.api.UserStoreException;
import org.wso2.carbon.user.core.service.RealmService;

public class InterceptingConsentManager
extends PrivilegedConsentManagerImpl {
    private static final Log log = LogFactory.getLog(InterceptingConsentManager.class);
    private RealmService realmService;

    public InterceptingConsentManager(ConsentManagerConfigurationHolder configHolder, List<ConsentMgtInterceptor> consentMgtInterceptors) {
        super(configHolder, consentMgtInterceptors);
        this.realmService = configHolder.getRealmService();
    }

    @Override
    public Receipt getReceipt(String receiptId) throws ConsentManagementException {
        this.validateAuthorizationForGetOrRevokeReceipts(receiptId, "GET_RECEIPT");
        return super.getReceipt(receiptId);
    }

    @Override
    public List<ReceiptListResponse> searchReceipts(int limit, int offset, String piiPrincipalId, String spTenantDomain, String service, String state) throws ConsentManagementException {
        this.validateAuthorizationForListReceipts(piiPrincipalId);
        return super.searchReceipts(limit, offset, piiPrincipalId, spTenantDomain, service, state);
    }

    @Override
    public void revokeReceipt(String receiptId) throws ConsentManagementException {
        this.validateAuthorizationForGetOrRevokeReceipts(receiptId, "REVOKE_RECEIPT");
        super.revokeReceipt(receiptId);
    }

    private void validateAuthorizationForListReceipts(String piiPrincipalId) throws ConsentManagementException {
        String loggedInUser = PrivilegedCarbonContext.getThreadLocalCarbonContext().getUsername();
        if (StringUtils.isBlank((String)loggedInUser)) {
            throw ConsentUtils.handleClientException(ConsentConstants.ErrorMessages.ERROR_CODE_NO_USER_FOUND, "LIST_RECEIPT");
        }
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        if (StringUtils.isNotBlank((String)piiPrincipalId) && piiPrincipalId.equalsIgnoreCase(loggedInUser)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("User: " + piiPrincipalId + " is authorized to perform a search on own consent receipts."));
            }
            return;
        }
        this.handleAuthorization("LIST_RECEIPT", loggedInUser, tenantId);
    }

    private void validateAuthorizationForGetOrRevokeReceipts(String receiptId, String operation) throws ConsentManagementException {
        String loggedInUser = PrivilegedCarbonContext.getThreadLocalCarbonContext().getUsername();
        if (StringUtils.isBlank((String)loggedInUser)) {
            throw ConsentUtils.handleClientException(ConsentConstants.ErrorMessages.ERROR_CODE_NO_USER_FOUND, operation);
        }
        int tenantId = PrivilegedCarbonContext.getThreadLocalCarbonContext().getTenantId();
        if (super.isReceiptExist(receiptId, loggedInUser, tenantId)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("User: " + loggedInUser + " is authorized to perform a " + operation + " on own consent receipt."));
            }
            return;
        }
        this.handleAuthorization(operation, loggedInUser, tenantId);
        this.handleCrossDomainPermission(receiptId);
    }

    private void handleCrossDomainPermission(String receiptId) throws ConsentManagementException {
        String tenantDomain = ConsentUtils.getTenantDomainFromCarbonContext();
        Receipt receipt = super.getReceipt(receiptId);
        if (receipt != null) {
            if (StringUtils.equals((String)receipt.getTenantDomain(), (String)tenantDomain)) {
                return;
            }
            if (receipt.getServices().stream().anyMatch(service -> StringUtils.equals((String)service.getTenantDomain(), (String)tenantDomain))) {
                return;
            }
        }
        String message = String.format(ConsentConstants.ErrorMessages.ERROR_CODE_RECEIPT_ID_INVALID.getMessage(), receiptId) + " in tenant: " + tenantDomain;
        throw new ConsentManagementClientException(message, ConsentConstants.ErrorMessages.ERROR_CODE_RECEIPT_ID_INVALID.getCode());
    }

    private void handleAuthorization(String operation, String tenantAwareUsername, int tenantId) throws ConsentManagementException {
        block10: {
            try {
                boolean authorized = false;
                AuthorizationManager authorizationManager = this.realmService.getTenantUserRealm(tenantId).getAuthorizationManager();
                if ("GET_RECEIPT".equals(operation)) {
                    authorized = authorizationManager.isUserAuthorized(tenantAwareUsername, "/permission/admin/manage/identity/consentmgt/view", "ui.execute");
                } else if ("LIST_RECEIPT".equals(operation)) {
                    authorized = authorizationManager.isUserAuthorized(tenantAwareUsername, "/permission/admin/manage/identity/consentmgt/list", "ui.execute");
                } else if ("REVOKE_RECEIPT".equals(operation)) {
                    authorized = authorizationManager.isUserAuthorized(tenantAwareUsername, "/permission/admin/manage/identity/consentmgt/delete", "ui.execute");
                }
                if (authorized) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("User: " + tenantAwareUsername + " is successfully authorized to perform the operation: " + operation));
                    }
                    break block10;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("LoggedIn user: " + tenantAwareUsername + " is not authorized to perform operation :" + operation + " of another users"));
                }
                throw ConsentUtils.handleClientException(ConsentConstants.ErrorMessages.ERROR_CODE_USER_NOT_AUTHORIZED, tenantAwareUsername);
            }
            catch (UserStoreException e) {
                throw ConsentUtils.handleServerException(ConsentConstants.ErrorMessages.ERROR_CODE_UNEXPECTED, null, e);
            }
        }
    }
}

