/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.consent.mgt.core.internal;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.consent.mgt.core.ConsentManager;
import org.wso2.carbon.consent.mgt.core.InterceptingConsentManager;
import org.wso2.carbon.consent.mgt.core.PrivilegedConsentManager;
import org.wso2.carbon.consent.mgt.core.PrivilegedConsentManagerImpl;
import org.wso2.carbon.consent.mgt.core.connector.ConsentMgtInterceptor;
import org.wso2.carbon.consent.mgt.core.connector.PIIController;
import org.wso2.carbon.consent.mgt.core.connector.impl.DefaultPIIController;
import org.wso2.carbon.consent.mgt.core.constant.ConsentConstants;
import org.wso2.carbon.consent.mgt.core.dao.PIICategoryDAO;
import org.wso2.carbon.consent.mgt.core.dao.PurposeCategoryDAO;
import org.wso2.carbon.consent.mgt.core.dao.PurposeDAO;
import org.wso2.carbon.consent.mgt.core.dao.ReceiptDAO;
import org.wso2.carbon.consent.mgt.core.dao.impl.PIICategoryDAOImpl;
import org.wso2.carbon.consent.mgt.core.dao.impl.PurposeCategoryDAOImpl;
import org.wso2.carbon.consent.mgt.core.dao.impl.PurposeDAOImpl;
import org.wso2.carbon.consent.mgt.core.dao.impl.ReceiptDAOImpl;
import org.wso2.carbon.consent.mgt.core.exception.ConsentManagementRuntimeException;
import org.wso2.carbon.consent.mgt.core.internal.ConsentManagerComponentDataHolder;
import org.wso2.carbon.consent.mgt.core.model.ConsentManagerConfigurationHolder;
import org.wso2.carbon.consent.mgt.core.util.ConsentConfigParser;
import org.wso2.carbon.consent.mgt.core.util.ConsentDBInitializer;
import org.wso2.carbon.user.core.service.RealmService;

@Component(name="carbon.consent.mgt.component", immediate=true)
public class ConsentManagerComponent {
    private static final Log log = LogFactory.getLog(ConsentManagerComponent.class);
    private List<PIIController> piiControllers = new ArrayList<PIIController>();
    private List<PurposeDAO> purposeDAOs = new ArrayList<PurposeDAO>();
    private List<PIICategoryDAO> piiCategoryDAOs = new ArrayList<PIICategoryDAO>();
    private List<PurposeCategoryDAO> purposeCategoryDAOs = new ArrayList<PurposeCategoryDAO>();
    private List<ReceiptDAO> receiptDAOs = new ArrayList<ReceiptDAO>();
    private List<ConsentMgtInterceptor> consentMgtInterceptors = new ArrayList<ConsentMgtInterceptor>();
    private RealmService realmService;

    @Activate
    protected void activate(ComponentContext componentContext) {
        try {
            BundleContext bundleContext = componentContext.getBundleContext();
            ConsentConfigParser configParser = new ConsentConfigParser();
            DataSource dataSource = this.initDataSource(configParser);
            this.initializeConsentDB(dataSource);
            this.setDataSourceToDataHolder(dataSource);
            bundleContext.registerService(PIIController.class.getName(), (Object)new DefaultPIIController(configParser), null);
            bundleContext.registerService(PurposeDAO.class.getName(), (Object)new PurposeDAOImpl(), null);
            bundleContext.registerService(ReceiptDAO.class.getName(), (Object)new ReceiptDAOImpl(), null);
            bundleContext.registerService(PIICategoryDAO.class.getName(), (Object)new PIICategoryDAOImpl(), null);
            bundleContext.registerService(PurposeCategoryDAO.class.getName(), (Object)new PurposeCategoryDAOImpl(), null);
            ConsentManagerConfigurationHolder configHolder = new ConsentManagerConfigurationHolder();
            configHolder.setPurposeDAOs(this.purposeDAOs);
            configHolder.setPurposeCategoryDAOs(this.purposeCategoryDAOs);
            configHolder.setPiiCategoryDAOs(this.piiCategoryDAOs);
            configHolder.setReceiptDAOs(this.receiptDAOs);
            configHolder.setConfigParser(configParser);
            configHolder.setPiiControllers(this.piiControllers);
            configHolder.setRealmService(this.realmService);
            bundleContext.registerService(ConsentManager.class.getName(), (Object)new InterceptingConsentManager(configHolder, this.consentMgtInterceptors), null);
            bundleContext.registerService(PrivilegedConsentManager.class.getName(), (Object)new PrivilegedConsentManagerImpl(configHolder, this.consentMgtInterceptors), null);
            log.debug((Object)"ConsentManagerComponent is activated.");
        }
        catch (Throwable e) {
            log.error((Object)"Error while activating ConsentManagerComponent.", e);
        }
    }

    @Reference(name="realm.service", service=RealmService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRealmService")
    protected void setRealmService(RealmService realmService) {
        this.realmService = realmService;
        if (realmService != null && log.isDebugEnabled()) {
            log.debug((Object)"RealmService is registered in ConsentManager service.");
        }
    }

    protected void unsetRealmService(RealmService realmService) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"RealmService is unregistered in ConsentManager service.");
        }
        this.realmService = null;
    }

    @Reference(name="pii.controller", service=PIIController.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="unsetPIIController")
    protected void setPIIController(PIIController piiController) {
        if (piiController != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"PII Controller is registered in ConsentManager service.");
            }
            this.piiControllers.add(piiController);
            this.piiControllers.sort(Comparator.comparingInt(PIIController::getPriority));
        }
    }

    protected void unsetPIIController(PIIController piiController) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"PII Controller is unregistered in ConsentManager service.");
        }
        this.piiControllers.remove(piiController);
    }

    @Reference(name="purpose.dao", service=PurposeDAO.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="unsetPurpose")
    protected void setPurpose(PurposeDAO purposeDAO) {
        if (purposeDAO != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Purpose DAO is registered in ConsentManager service.");
            }
            this.purposeDAOs.add(purposeDAO);
            this.purposeDAOs.sort(Comparator.comparingInt(PurposeDAO::getPriority));
        }
    }

    protected void unsetPurpose(PurposeDAO purposeDAO) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Purpose DAO is unregistered in ConsentManager service.");
        }
        this.purposeDAOs.remove(purposeDAO);
    }

    @Reference(name="purposeCategory.dao", service=PurposeCategoryDAO.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="unsetPurposeCategory")
    protected void setPurposeCategory(PurposeCategoryDAO purposeCategoryDAO) {
        if (purposeCategoryDAO != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Purpose Category DAO is registered in ConsentManager service.");
            }
            this.purposeCategoryDAOs.add(purposeCategoryDAO);
            this.purposeCategoryDAOs.sort(Comparator.comparingInt(PurposeCategoryDAO::getPriority));
        }
    }

    protected void unsetPurposeCategory(PurposeCategoryDAO piiCategoryDAO) {
        if (log.isDebugEnabled()) {
            log.debug((Object)" Purpose Category DAO is unregistered in ConsentManager service.");
        }
        this.purposeCategoryDAOs.remove(piiCategoryDAO);
    }

    @Reference(name="piiCategory.dao", service=PIICategoryDAO.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="unsetPIICategory")
    protected void setPIICategory(PIICategoryDAO piiCategory) {
        if (piiCategory != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"PII Category DAO is registered in ConsentManager service.");
            }
            this.piiCategoryDAOs.add(piiCategory);
            this.piiCategoryDAOs.sort(Comparator.comparingInt(PIICategoryDAO::getPriority));
        }
    }

    protected void unsetPIICategory(PIICategoryDAO piiCategoryDAO) {
        if (log.isDebugEnabled()) {
            log.debug((Object)" PII Category DAO is unregistered in ConsentManager service.");
        }
        this.piiCategoryDAOs.remove(piiCategoryDAO);
    }

    @Reference(name="receipt.dao", service=ReceiptDAO.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="unsetReceiptDAO")
    protected void setReceiptDAO(ReceiptDAO receiptDAO) {
        if (receiptDAO != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Receipt DAO is registered in ConsentManager service.");
            }
            this.receiptDAOs.add(receiptDAO);
            this.receiptDAOs.sort(Comparator.comparingInt(ReceiptDAO::getPriority));
        }
    }

    protected void unsetReceiptDAO(ReceiptDAO receiptDAO) {
        if (log.isDebugEnabled()) {
            log.debug((Object)" Receipt DAO is unregistered in ConsentManager service.");
        }
        this.receiptDAOs.remove(receiptDAO);
    }

    @Reference(name="consent.interceptor", service=ConsentMgtInterceptor.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, unbind="unsetConsentInterceptor")
    protected void setConsentInterceptor(ConsentMgtInterceptor interceptor) {
        if (interceptor != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Consent Management Interceptor is registered in ConsentManager service.");
            }
            this.consentMgtInterceptors.add(interceptor);
            this.consentMgtInterceptors.sort(Comparator.comparingInt(ConsentMgtInterceptor::getOrder));
        }
    }

    protected void unsetConsentInterceptor(ConsentMgtInterceptor interceptor) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Consent Management Interceptor is unregistered in ConsentManager service.");
        }
        this.consentMgtInterceptors.remove(interceptor);
    }

    private DataSource initDataSource(ConsentConfigParser configParser) {
        String dataSourceName = configParser.getConsentDataSource();
        try {
            InitialContext ctx = new InitialContext();
            DataSource dataSource = (DataSource)ctx.lookup(dataSourceName);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Data source: %s found in context.", dataSourceName));
            }
            return dataSource;
        }
        catch (NamingException e) {
            throw new ConsentManagementRuntimeException(ConsentConstants.ErrorMessages.ERROR_CODE_DATABASE_INITIALIZATION.getMessage(), ConsentConstants.ErrorMessages.ERROR_CODE_DATABASE_INITIALIZATION.getCode(), e);
        }
    }

    private void initializeConsentDB(DataSource dataSource) {
        if (System.getProperty("setup") == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Consent Database schema initialization check was skipped since 'setup' variable was not given during startup");
            }
        } else {
            ConsentDBInitializer dbInitializer = new ConsentDBInitializer(dataSource);
            dbInitializer.createConsentDatabase();
        }
    }

    private void setDataSourceToDataHolder(DataSource dataSource) {
        ConsentManagerComponentDataHolder.getInstance().setDataSource(dataSource);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Data Source is set to the Consent Management Service.");
        }
    }
}

