/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.consent.mgt.ui.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.wso2.carbon.consent.mgt.core.ConsentManager;
import org.wso2.carbon.consent.mgt.ui.internal.ConsentManagementUIServiceDataHolder;
import org.wso2.carbon.user.core.service.RealmService;

@Component(name="org.wso2.carbon.identity.consent.mgt.ui", immediate=true)
public class ConsentMgtUIServiceComponent {
    private static final Log log = LogFactory.getLog(ConsentMgtUIServiceComponent.class);

    @Activate
    protected void activate(ComponentContext context) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Consent Management UI bundle activated!");
        }
    }

    @Deactivate
    protected void deactivate(ComponentContext context) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Consent Management UI bundle is deactivated");
        }
    }

    @Reference(name="consent.service", service=ConsentManager.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetConsentService")
    protected void setConsentService(ConsentManager consentManager) {
        ConsentManagementUIServiceDataHolder.getInstance().setConsentManager(consentManager);
        if (consentManager != null && log.isDebugEnabled()) {
            log.debug((Object)"ConsentManager is registered in ConsentManager UI service.");
        }
    }

    protected void unsetConsentService(ConsentManager consentManager) {
        ConsentManagementUIServiceDataHolder.getInstance().setConsentManager(null);
        if (log.isDebugEnabled()) {
            log.debug((Object)"ConsentManager is unregistered in ConsentManager UI service.");
        }
    }

    @Reference(name="realm.service", service=RealmService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetRealmService")
    protected void setRealmService(RealmService realmService) {
        ConsentManagementUIServiceDataHolder.getInstance().setRealmService(realmService);
        if (realmService != null && log.isDebugEnabled()) {
            log.debug((Object)"RealmService is registered in ConsentManager service.");
        }
    }

    protected void unsetRealmService(RealmService realmService) {
        ConsentManagementUIServiceDataHolder.getInstance().setRealmService(null);
        if (log.isDebugEnabled()) {
            log.debug((Object)"RealmService is unregistered in ConsentManager service.");
        }
    }
}

