/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dashboards.api;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.wso2.carbon.dashboards.core.widget.info.WidgetDataHolder;
import org.wso2.msf4j.Microservice;

public class WidgetInfoProviderAPI
implements Microservice {
    @GET
    @Path(value="/")
    @Produces(value={"application/json"})
    public Response getWidgetsMetaInfo() {
        List widgetInfoProviderImplList = WidgetDataHolder.getInstance().getWidgetInfoProviders();
        List list = widgetInfoProviderImplList.stream().map(widget -> widget.getWidgetsMetaInfo()).filter(Objects::nonNull).collect(Collectors.toList());
        return Response.ok().entity(list).build();
    }

    @GET
    @Path(value="/{id}/conf")
    @Produces(value={"application/json"})
    public Response getWidgetConf(@PathParam(value="id") String widgetId) {
        List widgetInfoProviderImplList = WidgetDataHolder.getInstance().getWidgetInfoProviders();
        String widgetConf = widgetInfoProviderImplList.stream().map(widget -> widget.getWidgetConf(widgetId).orElse(null)).filter(Objects::nonNull).findFirst().orElse(null);
        if (widgetConf != null) {
            return Response.ok().entity((Object)widgetConf).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @GET
    @Path(value="/{id}/thumbnail")
    public Response getThumbnail(@PathParam(value="id") String widgetId) {
        List widgetInfoProviderImplList = WidgetDataHolder.getInstance().getWidgetInfoProviders();
        java.nio.file.Path path = widgetInfoProviderImplList.stream().map(widget -> widget.getThumbnail(widgetId).orElse(null)).filter(Objects::nonNull).findFirst().orElse(null);
        if (path != null && Files.exists(path, new LinkOption[0])) {
            return Response.ok((Object)path.toFile()).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Error in retrieving widget thumbnail").build();
    }
}

