/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dashboards.api.internal;

import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.analytics.msf4j.interceptor.common.AuthenticationInterceptor;
import org.wso2.carbon.dashboards.core.DashboardMetadataProvider;
import org.wso2.carbon.dashboards.core.bean.DashboardMetadata;
import org.wso2.carbon.dashboards.core.exception.DashboardException;
import org.wso2.carbon.dashboards.core.exception.UnauthorizedException;
import org.wso2.msf4j.Microservice;
import org.wso2.msf4j.Request;
import org.wso2.msf4j.interceptor.annotation.RequestInterceptor;

@Path(value="/portal/apis/dashboards")
@RequestInterceptor(value={AuthenticationInterceptor.class})
@Component(name="org.wso2.carbon.dashboards.api.DashboardApi", service={Microservice.class}, immediate=true)
public class DashboardRestApi
implements Microservice {
    private static final Logger LOGGER = LoggerFactory.getLogger(DashboardRestApi.class);
    private DashboardMetadataProvider dashboardDataProvider;

    @Activate
    protected void activate(BundleContext bundleContext) {
        LOGGER.debug("{} activated.", (Object)this.getClass().getName());
    }

    @Deactivate
    protected void deactivate(BundleContext bundleContext) {
        LOGGER.debug("{} deactivated.", (Object)this.getClass().getName());
    }

    @Reference(name="dashboardMetadata", service=DashboardMetadataProvider.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetMetadataProvider")
    protected void setMetadataProvider(DashboardMetadataProvider dashboardDataProvider) {
        this.dashboardDataProvider = dashboardDataProvider;
    }

    protected void unsetMetadataProvider(DashboardMetadataProvider dashboardDataProvider) {
        this.dashboardDataProvider = null;
    }

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/")
    public Response get(@Context Request request) {
        try {
            return Response.ok().entity((Object)this.dashboardDataProvider.getAllByUser(DashboardRestApi.getUserName(request))).build();
        }
        catch (UnauthorizedException e) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        catch (DashboardException e) {
            LOGGER.error("An error occurred when listing dashboards.", (Throwable)e);
            return Response.serverError().entity((Object)"Cannot list dashboards.").build();
        }
    }

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/{id}")
    public Response get(@PathParam(value="id") String id, @Context Request request) {
        try {
            return this.dashboardDataProvider.getDashboardByUser(DashboardRestApi.getUserName(request), id, request.getHeader("X-Dashboard-Origin-Component")).map(metadata -> Response.ok().entity(metadata).build()).orElse(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Cannot find a dashboard for ID '" + id + "'.")).build());
        }
        catch (UnauthorizedException e) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)("Insufficient permissions to retrieve dashboard with ID : " + id)).build();
        }
        catch (DashboardException e) {
            LOGGER.error("An error occurred when retrieving dashboard for ID '{}'.", (Object)id, (Object)e);
            return Response.serverError().entity((Object)("Cannot retrieve dashboard for ID '" + id + "'.")).build();
        }
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/")
    public Response create(@Context Request request, DashboardMetadata dashboardMetadata) {
        try {
            if (!this.dashboardDataProvider.get(dashboardMetadata.getUrl()).isPresent()) {
                this.dashboardDataProvider.add(DashboardRestApi.getUserName(request), dashboardMetadata);
                return Response.status((Response.Status)Response.Status.CREATED).build();
            }
            return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)("Dashboard with URL " + dashboardMetadata.getUrl() + " already exists.")).build();
        }
        catch (UnauthorizedException e) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"Insufficient permissions to create a dashboard").build();
        }
        catch (DashboardException e) {
            LOGGER.error("An error occurred when creating a new dashboard from {} data.", (Object)dashboardMetadata, (Object)e);
            return Response.serverError().entity((Object)("Cannot create a new dashboard from '" + dashboardMetadata + "'.")).build();
        }
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/{id}")
    public Response update(@PathParam(value="id") String id, DashboardMetadata dashboardMetadata, @Context Request request) {
        try {
            this.dashboardDataProvider.update(DashboardRestApi.getUserName(request), dashboardMetadata);
            return Response.ok().build();
        }
        catch (UnauthorizedException e) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)("Insufficient permissions to update the dashboard with ID : " + dashboardMetadata.getUrl())).build();
        }
        catch (DashboardException e) {
            LOGGER.error("Ann error occurred when updating dashboard '{}' with {} data.", new Object[]{id, dashboardMetadata, e});
            return Response.serverError().entity((Object)("Cannot update dashboard '" + id + "'.")).build();
        }
    }

    @DELETE
    @Path(value="/{id}")
    public Response delete(@PathParam(value="id") String id, @Context Request request) {
        try {
            this.dashboardDataProvider.delete(DashboardRestApi.getUserName(request), id);
            return Response.ok().build();
        }
        catch (UnauthorizedException e) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)("Insufficient permissions to delete the dashboard with ID : " + id)).build();
        }
        catch (DashboardException e) {
            LOGGER.error("Ann error occurred when deleting dashboard '{}'.", (Object)id, (Object)e);
            return Response.serverError().entity((Object)("Cannot delete dashboard '" + id + "'.")).build();
        }
    }

    @GET
    @Path(value="/roles")
    @Produces(value={"application/json"})
    public Response getRoles() {
        try {
            List allRoles = this.dashboardDataProvider.getAllRoles();
            return Response.ok().entity((Object)allRoles).build();
        }
        catch (DashboardException e) {
            LOGGER.error("Cannot retrieve user roles.", (Throwable)e);
            return Response.serverError().entity((Object)"Cannot retrieve user roles.").build();
        }
    }

    @GET
    @Path(value="/roles/{username}")
    @Produces(value={"application/json"})
    public Response getRolesByUsername(@PathParam(value="username") String username) {
        try {
            List roles = this.dashboardDataProvider.getRolesByUsername(username);
            return Response.ok().entity((Object)roles).build();
        }
        catch (DashboardException e) {
            LOGGER.error("Cannot retrieve user roles for '" + username + "'.", (Throwable)e);
            return Response.serverError().entity((Object)("Cannot retrieve user roles for '" + username + "'.")).build();
        }
    }

    @GET
    @Path(value="/{url}/roles")
    @Produces(value={"application/json"})
    public Response getDashboardRoles(@PathParam(value="url") String url) {
        try {
            return Response.ok().entity((Object)this.dashboardDataProvider.getDashboardRoles(url)).build();
        }
        catch (DashboardException e) {
            LOGGER.error("Cannot retrieve roles for dashboard '" + url + "'", (Throwable)e);
            return Response.serverError().entity((Object)("Cannot retrieve roles for dashboard '" + url + "'")).build();
        }
    }

    @POST
    @Path(value="/{url}/roles")
    @Consumes(value={"application/json"})
    public Response updateDashboardRoles(@PathParam(value="url") String url, @Context Request request, Map<String, List<String>> roles) {
        try {
            this.dashboardDataProvider.updateDashboardRoles(DashboardRestApi.getUserName(request), url, roles);
            return Response.ok().build();
        }
        catch (UnauthorizedException e) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)("Insufficient permissions to update the roles of dashboard with ID : " + url)).build();
        }
        catch (DashboardException e) {
            LOGGER.error("Cannot update user roles of dashboard '" + url + "'.", (Throwable)e);
            return Response.serverError().entity((Object)("Cannot update user roles of dashboard '" + url + "'.")).build();
        }
    }

    private static String getUserName(Request request) {
        return request.getProperty("username").toString();
    }
}

