/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dashboards.api.internal;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.analytics.msf4j.interceptor.common.AuthenticationInterceptor;
import org.wso2.carbon.dashboards.core.WidgetInfoProvider;
import org.wso2.carbon.dashboards.core.exception.DashboardRuntimeException;
import org.wso2.msf4j.Microservice;
import org.wso2.msf4j.interceptor.annotation.RequestInterceptor;

@Path(value="/portal/apis/widgets")
@RequestInterceptor(value={AuthenticationInterceptor.class})
@Component(name="org.wso2.carbon.dashboards.api.WidgetApi", service={Microservice.class}, immediate=true)
public class WidgetRestApi
implements Microservice {
    private static final Logger LOGGER = LoggerFactory.getLogger(WidgetRestApi.class);
    private WidgetInfoProvider widgetInfoProvider;

    @Activate
    protected void activate(BundleContext bundleContext) {
        LOGGER.debug("{} activated.", (Object)this.getClass().getName());
    }

    @Deactivate
    protected void deactivate(BundleContext bundleContext) {
        LOGGER.debug("{} deactivated.", (Object)this.getClass().getName());
    }

    @Reference(service=WidgetInfoProvider.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetWidgetInfoProvider")
    protected void setWidgetInfoProvider(WidgetInfoProvider widgetInfoProvider) {
        this.widgetInfoProvider = widgetInfoProvider;
    }

    protected void unsetWidgetInfoProvider(WidgetInfoProvider widgetInfoProvider) {
        this.widgetInfoProvider = null;
    }

    @GET
    @Path(value="/")
    @Produces(value={"application/json"})
    public Response getWidgetsMetaInfo() {
        try {
            return WidgetRestApi.okResponse(this.widgetInfoProvider.getAllWidgetConfigurations());
        }
        catch (DashboardRuntimeException e) {
            LOGGER.error("An error occurred when listing widget configurations.", (Throwable)e);
            return WidgetRestApi.serverErrorResponse("Cannot list widget configurations.");
        }
    }

    @GET
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public Response getWidgetConf(@PathParam(value="id") String widgetId) {
        try {
            return this.widgetInfoProvider.getWidgetConfiguration(widgetId).map(WidgetRestApi::okResponse).orElse(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Cannot find widget '" + widgetId + "'.")).build());
        }
        catch (DashboardRuntimeException e) {
            LOGGER.error("An error occurred when retrieving configuration of widget '{}'.", (Object)widgetId, (Object)e);
            return WidgetRestApi.serverErrorResponse("Cannot retrieve configuration of widget '" + widgetId + "'.");
        }
    }

    @GET
    @Path(value="/{id}/thumbnail")
    public Response getThumbnail(@PathParam(value="id") String widgetId) {
        return Response.ok().build();
    }

    private static Response okResponse(Object content) {
        return Response.ok().entity(content).build();
    }

    private static Response serverErrorResponse(String message) {
        return Response.serverError().entity((Object)message).build();
    }
}

