/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dashboards.api.internal;

import java.util.HashMap;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.dashboards.api.internal.DashboardRestApi;
import org.wso2.carbon.dashboards.api.internal.WidgetRestApi;
import org.wso2.carbon.dashboards.core.DashboardMetadataProvider;
import org.wso2.carbon.dashboards.core.WidgetMetadataProvider;
import org.wso2.carbon.uis.api.App;
import org.wso2.carbon.uis.spi.RestApiProvider;
import org.wso2.msf4j.Microservice;

@Component(service={RestApiProvider.class}, immediate=true)
public class DashboardRestApiProvider
implements RestApiProvider {
    public static final String DASHBOARD_PORTAL_APP_NAME = "portal";
    private static final Logger LOGGER = LoggerFactory.getLogger(DashboardRestApiProvider.class);
    private DashboardMetadataProvider dashboardDataProvider;
    private WidgetMetadataProvider widgetMetadataProvider;

    @Activate
    protected void activate(BundleContext bundleContext) {
        LOGGER.debug("{} activated.", (Object)this.getClass().getName());
    }

    @Deactivate
    protected void deactivate(BundleContext bundleContext) {
        LOGGER.debug("{} deactivated.", (Object)this.getClass().getName());
    }

    @Reference(service=DashboardMetadataProvider.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetDashboardMetadataProvider")
    protected void setDashboardMetadataProvider(DashboardMetadataProvider dashboardDataProvider) {
        this.dashboardDataProvider = dashboardDataProvider;
        LOGGER.debug("DashboardMetadataProvider '{}' registered.", (Object)dashboardDataProvider.getClass().getName());
    }

    protected void unsetDashboardMetadataProvider(DashboardMetadataProvider dashboardDataProvider) {
        this.dashboardDataProvider = null;
        LOGGER.debug("DashboardMetadataProvider '{}' unregistered.", (Object)dashboardDataProvider.getClass().getName());
    }

    @Reference(service=WidgetMetadataProvider.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetWidgetMetadataProvider")
    protected void setWidgetMetadataProvider(WidgetMetadataProvider widgetMetadataProvider) {
        this.widgetMetadataProvider = widgetMetadataProvider;
        LOGGER.debug("WidgetMetadataProvider '{}' registered.", (Object)widgetMetadataProvider.getClass().getName());
    }

    protected void unsetWidgetMetadataProvider(WidgetMetadataProvider widgetMetadataProvider) {
        this.widgetMetadataProvider = null;
        LOGGER.debug("WidgetMetadataProvider '{}' registered.", (Object)widgetMetadataProvider.getClass().getName());
    }

    public String getAppName() {
        return DASHBOARD_PORTAL_APP_NAME;
    }

    public Map<String, Microservice> getMicroservices(App app) {
        HashMap<String, Microservice> microservices = new HashMap<String, Microservice>(2);
        microservices.put("/apis/dashboards", new DashboardRestApi(this.dashboardDataProvider));
        this.widgetMetadataProvider.setDashboardApp(app);
        microservices.put("/apis/widgets", new WidgetRestApi(this.widgetMetadataProvider));
        return microservices;
    }
}

