/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dashboards.api;

import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.wso2.carbon.dashboards.api.DataHolder;
import org.wso2.carbon.dashboards.core.bean.DashboardMetadata;
import org.wso2.carbon.dashboards.core.bean.PaginationContext;
import org.wso2.carbon.dashboards.core.bean.Query;
import org.wso2.carbon.dashboards.core.exception.DashboardException;
import org.wso2.carbon.dashboards.core.provider.DashboardMetadataProvider;
import org.wso2.msf4j.Microservice;

@Path(value="/apis/dashboards")
@Component(name="org.wso2.carbon.dashboards.api.DashboardMetadataAPI", service={Microservice.class}, immediate=true)
public class DashboardMetadataAPI
implements Microservice {
    @Activate
    protected void activate(BundleContext bundleContext) {
    }

    @Deactivate
    protected void deactivate(BundleContext bundleContext) {
    }

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/")
    public Response list() throws DashboardException {
        DashboardMetadataProvider provider = DataHolder.getInstance().getDashboardMetadataProvider();
        if (provider != null) {
            List dashboards = provider.list(new Query(this.getUsername()), new PaginationContext());
            return Response.ok().entity((Object)dashboards).build();
        }
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
    }

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/{id}")
    public Response get(@PathParam(value="id") String id) throws DashboardException {
        DashboardMetadataProvider provider = DataHolder.getInstance().getDashboardMetadataProvider();
        if (provider != null) {
            DashboardMetadata metadata = provider.get(new Query(this.getUsername(), id));
            if (metadata == null) {
                Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            return Response.ok().entity((Object)metadata).build();
        }
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/")
    public Response create(DashboardMetadata dashboardMetadata) throws DashboardException {
        DashboardMetadataProvider provider = DataHolder.getInstance().getDashboardMetadataProvider();
        if (provider != null) {
            provider.add(dashboardMetadata);
            return Response.status((Response.Status)Response.Status.CREATED).build();
        }
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/{id}")
    public Response update(@PathParam(value="id") String id, DashboardMetadata dashboardMetadata) throws DashboardException {
        DashboardMetadataProvider provider = DataHolder.getInstance().getDashboardMetadataProvider();
        if (provider != null) {
            provider.update(dashboardMetadata);
            return Response.ok().build();
        }
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
    }

    @DELETE
    @Path(value="/{id}")
    public Response delete(@PathParam(value="id") String id) throws DashboardException {
        DashboardMetadataProvider provider = DataHolder.getInstance().getDashboardMetadataProvider();
        if (provider != null) {
            provider.delete(new Query(this.getUsername(), id));
            return Response.ok().build();
        }
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
    }

    private String getUsername() {
        return "admin";
    }
}

