/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dashboards.api.internal;

import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.analytics.msf4j.interceptor.common.AuthenticationInterceptor;
import org.wso2.carbon.dashboards.core.WidgetMetadataProvider;
import org.wso2.carbon.dashboards.core.bean.importer.WidgetType;
import org.wso2.carbon.dashboards.core.bean.widget.GeneratedWidgetConfigs;
import org.wso2.carbon.dashboards.core.exception.DashboardException;
import org.wso2.msf4j.Microservice;
import org.wso2.msf4j.interceptor.annotation.RequestInterceptor;

@RequestInterceptor(value={AuthenticationInterceptor.class})
public class WidgetRestApi
implements Microservice {
    public static final String API_CONTEXT_PATH = "/apis/widgets";
    private static final Logger LOGGER = LoggerFactory.getLogger(WidgetRestApi.class);
    private final WidgetMetadataProvider widgetMetadataProvider;

    public WidgetRestApi(WidgetMetadataProvider widgetMetadataProvider) {
        this.widgetMetadataProvider = widgetMetadataProvider;
    }

    @GET
    @Path(value="/")
    @Produces(value={"application/json"})
    public Response getWidgetsMetaInfo() {
        try {
            return WidgetRestApi.okResponse(this.widgetMetadataProvider.getAllWidgetConfigurations());
        }
        catch (DashboardException e) {
            LOGGER.error("An error occurred when listing widget configurations.", (Throwable)e);
            return WidgetRestApi.serverErrorResponse("Cannot list widget configurations.");
        }
        catch (Throwable throwable) {
            LOGGER.error("Server error occurred when listing widget configurations.", throwable);
            return Response.serverError().entity((Object)"Server error occurred when listing widget configurations.").build();
        }
    }

    @GET
    @Path(value="/{id}")
    @Produces(value={"application/json"})
    public Response getWidgetConf(@PathParam(value="id") String widgetId) {
        try {
            return this.widgetMetadataProvider.getWidgetConfiguration(widgetId).map(WidgetRestApi::okResponse).orElse(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Cannot find widget '" + widgetId + "'.")).build());
        }
        catch (DashboardException e) {
            LOGGER.error("An error occurred when retrieving configuration of widget '{}'.", (Object)this.replaceCRLFCharacters(widgetId), (Object)e);
            return WidgetRestApi.serverErrorResponse("Cannot retrieve configuration of widget '" + widgetId + "'.");
        }
        catch (Throwable throwable) {
            LOGGER.error("Server error occurred when retrieving configuration of widget '{}': ", (Object)this.replaceCRLFCharacters(this.replaceCRLFCharacters(widgetId)), (Object)throwable);
            return Response.serverError().entity((Object)("Server error occurred when retrieving configuration of widget '{}': " + widgetId + "'.")).build();
        }
    }

    @GET
    @Path(value="/{id}/thumbnail")
    public Response getThumbnail(@PathParam(value="id") String widgetId) {
        return Response.ok().build();
    }

    private static Response okResponse(Object content) {
        return Response.ok().entity(content).build();
    }

    private static Response serverErrorResponse(String message) {
        return Response.serverError().entity((Object)message).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="{widgetName}/validate")
    public Response validateWidgetName(@PathParam(value="widgetName") String widgetName) {
        try {
            if (!this.widgetMetadataProvider.isWidgetPresent(widgetName)) {
                return Response.status((Response.Status)Response.Status.OK).build();
            }
            return Response.status((Response.Status)Response.Status.CONFLICT).build();
        }
        catch (DashboardException e) {
            LOGGER.error("An error occurred when validating the widget name: " + this.replaceCRLFCharacters(widgetName) + ".", (Throwable)e);
            return Response.serverError().entity((Object)("An error occurred when validating the widget name: " + widgetName + ".")).build();
        }
        catch (Throwable throwable) {
            LOGGER.error("Server error occurred when validating the widget name: ", (Object)this.replaceCRLFCharacters(this.replaceCRLFCharacters(widgetName)), (Object)throwable);
            return Response.serverError().entity((Object)("Server error occurred when validating the widget name: '" + widgetName + "'.")).build();
        }
    }

    @DELETE
    @Path(value="/{id}")
    public Response deleteWidget(@PathParam(value="id") String widgetId) {
        try {
            if (this.widgetMetadataProvider.isWidgetPresent(widgetId, WidgetType.GENERATED)) {
                this.widgetMetadataProvider.delete(widgetId);
                return Response.status((Response.Status)Response.Status.OK).build();
            }
            return Response.status((int)422).entity((Object)("Cannot find widget '" + widgetId + "'.")).build();
        }
        catch (DashboardException e) {
            LOGGER.error("An error occurred when deleting widget '{}'.", (Object)this.replaceCRLFCharacters(widgetId), (Object)e);
            return Response.serverError().entity((Object)("Cannot delete widget '" + widgetId + "'.")).build();
        }
        catch (Throwable throwable) {
            LOGGER.error("Server error occurred when deleting widget '{}'. ", (Object)this.replaceCRLFCharacters(this.replaceCRLFCharacters(widgetId)), (Object)throwable);
            return Response.serverError().entity((Object)("Server error occurred when deleting widget '{}'. '" + widgetId + "'.")).build();
        }
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/")
    public Response create(GeneratedWidgetConfigs generatedWidgetConfigs) {
        try {
            this.widgetMetadataProvider.addGeneratedWidgetConfigs(generatedWidgetConfigs);
            return Response.status((Response.Status)Response.Status.CREATED).build();
        }
        catch (DashboardException e) {
            LOGGER.error("An error occurred when creating a new gadget from {} data.", (Object)this.replaceCRLFCharacters(generatedWidgetConfigs.toString()), (Object)e);
            return Response.serverError().entity((Object)("Cannot create a new gadget from '" + generatedWidgetConfigs + "'.")).build();
        }
        catch (Throwable throwable) {
            LOGGER.error("Server error occurred when creating a new gadget from {} data. ", (Object)this.replaceCRLFCharacters(generatedWidgetConfigs.toString()), (Object)throwable);
            return Response.serverError().entity((Object)("Server error occurred when creating a new gadget from {} data. '" + generatedWidgetConfigs.toString() + "'.")).build();
        }
    }

    private String replaceCRLFCharacters(String str) {
        if (str != null) {
            str = str.replace('\n', '_').replace('\r', '_');
        }
        return str;
    }
}

