/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dashboards.api.internal;

import com.google.gson.Gson;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.analytics.msf4j.interceptor.common.AuthenticationInterceptor;
import org.wso2.carbon.dashboards.core.DashboardMetadataProvider;
import org.wso2.carbon.dashboards.core.bean.DashboardMetadata;
import org.wso2.carbon.dashboards.core.bean.importer.DashboardArtifact;
import org.wso2.carbon.dashboards.core.exception.DashboardException;
import org.wso2.carbon.dashboards.core.exception.UnauthorizedException;
import org.wso2.msf4j.Microservice;
import org.wso2.msf4j.Request;
import org.wso2.msf4j.interceptor.annotation.RequestInterceptor;

@RequestInterceptor(value={AuthenticationInterceptor.class})
public class DashboardRestApi
implements Microservice {
    public static final String API_CONTEXT_PATH = "/apis/dashboards";
    private static final Logger LOGGER = LoggerFactory.getLogger(DashboardRestApi.class);
    private static final Gson GSON = new Gson();
    private final DashboardMetadataProvider dashboardDataProvider;

    public DashboardRestApi(DashboardMetadataProvider dashboardDataProvider) {
        this.dashboardDataProvider = dashboardDataProvider;
    }

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/")
    public Response get(@Context Request request) {
        try {
            return Response.ok().entity((Object)this.dashboardDataProvider.getAllByUser(DashboardRestApi.getUserName(request))).build();
        }
        catch (UnauthorizedException e) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        catch (DashboardException e) {
            LOGGER.error("An error occurred when listing dashboards.", (Throwable)e);
            return Response.serverError().entity((Object)"Cannot list dashboards.").build();
        }
    }

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/{id}")
    public Response get(@PathParam(value="id") String id, @Context Request request) {
        try {
            return this.dashboardDataProvider.getDashboardByUser(DashboardRestApi.getUserName(request), id, request.getHeader("X-Dashboard-Origin-Component")).map(metadata -> Response.ok().entity(metadata).build()).orElse(Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)("Cannot find a dashboard for ID '" + id + "'.")).build());
        }
        catch (UnauthorizedException e) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)("Insufficient permissions to retrieve dashboard with ID : " + id)).build();
        }
        catch (DashboardException e) {
            LOGGER.error(String.format("An error occurred when retrieving dashboard for ID %s.", DashboardRestApi.replaceCRLFCharacters(id)), (Throwable)e);
            return Response.serverError().entity((Object)("Cannot retrieve dashboard for ID '" + id + "'.")).build();
        }
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/")
    public Response create(@Context Request request, DashboardMetadata dashboardMetadata) {
        try {
            if (!this.dashboardDataProvider.get(dashboardMetadata.getUrl()).isPresent()) {
                this.dashboardDataProvider.add(DashboardRestApi.getUserName(request), dashboardMetadata);
                return Response.status((Response.Status)Response.Status.CREATED).build();
            }
            return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)("Dashboard with URL " + dashboardMetadata.getUrl() + " already exists.")).build();
        }
        catch (UnauthorizedException e) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)"Insufficient permissions to create a dashboard").build();
        }
        catch (DashboardException e) {
            LOGGER.error("An error occurred when creating a new dashboard from {} data.", (Object)DashboardRestApi.replaceCRLFCharacters(dashboardMetadata.toString()), (Object)e);
            return Response.serverError().entity((Object)("Cannot create a new dashboard from '" + dashboardMetadata + "'.")).build();
        }
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/{id}")
    public Response update(@PathParam(value="id") String id, DashboardMetadata dashboardMetadata, @Context Request request) {
        try {
            this.dashboardDataProvider.update(DashboardRestApi.getUserName(request), dashboardMetadata);
            return Response.ok().build();
        }
        catch (UnauthorizedException e) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)("Insufficient permissions to update the dashboard with ID : " + dashboardMetadata.getUrl())).build();
        }
        catch (DashboardException e) {
            LOGGER.error("An error occurred when updating dashboard '{}' with {} data.", new Object[]{id, dashboardMetadata, e});
            return Response.serverError().entity((Object)("Cannot update dashboard '" + id + "'.")).build();
        }
    }

    @DELETE
    @Path(value="/{id}")
    public Response delete(@PathParam(value="id") String id, @Context Request request) {
        try {
            this.dashboardDataProvider.delete(DashboardRestApi.getUserName(request), id);
            return Response.ok().build();
        }
        catch (UnauthorizedException e) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)("Insufficient permissions to delete the dashboard with ID : " + id)).build();
        }
        catch (DashboardException e) {
            LOGGER.error(String.format("An error occurred when deleting dashboard %s", DashboardRestApi.replaceCRLFCharacters(id)), (Throwable)e);
            return Response.serverError().entity((Object)("Cannot delete dashboard '" + id + "'.")).build();
        }
    }

    @GET
    @Path(value="/roles")
    @Produces(value={"application/json"})
    public Response getRoles(@Context Request request) {
        try {
            List allRoles = this.dashboardDataProvider.getAllRoles(DashboardRestApi.getUserName(request));
            return Response.ok().entity((Object)allRoles).build();
        }
        catch (DashboardException e) {
            LOGGER.error("Cannot retrieve user roles.", (Throwable)e);
            return Response.serverError().entity((Object)"Cannot retrieve user roles.").build();
        }
    }

    @GET
    @Path(value="/roles/{username}")
    @Produces(value={"application/json"})
    public Response getRolesByUsername(@PathParam(value="username") String username) {
        try {
            List roles = this.dashboardDataProvider.getRolesByUsername(username);
            return Response.ok().entity((Object)roles).build();
        }
        catch (DashboardException e) {
            LOGGER.error("Cannot retrieve user roles for '" + DashboardRestApi.replaceCRLFCharacters(username) + "'.", (Throwable)e);
            return Response.serverError().entity((Object)("Cannot retrieve user roles for '" + username + "'.")).build();
        }
    }

    @GET
    @Path(value="/roles/{username}/iscreator")
    public Response isCreator(@PathParam(value="username") String username) {
        try {
            boolean isCreator = this.dashboardDataProvider.isCreator(username);
            return Response.ok().entity((Object)isCreator).build();
        }
        catch (DashboardException e) {
            return Response.serverError().entity((Object)("Cannot read user roles for '" + username + "'.")).build();
        }
    }

    @GET
    @Path(value="/roles/{username}/iswidgetcreator")
    public Response isWidgetCreator(@PathParam(value="username") String username) {
        try {
            boolean isWidgetCreator = this.dashboardDataProvider.isWidgetCreator(username);
            return Response.ok().entity((Object)isWidgetCreator).build();
        }
        catch (DashboardException e) {
            return Response.serverError().entity((Object)("Cannot read user roles for '" + username + "'.")).build();
        }
    }

    @GET
    @Path(value="/{url}/roles")
    @Produces(value={"application/json"})
    public Response getDashboardRoles(@PathParam(value="url") String url, @Context Request request) {
        try {
            return Response.ok().entity((Object)this.dashboardDataProvider.getDashboardRoles(url, DashboardRestApi.getUserName(request))).build();
        }
        catch (DashboardException e) {
            LOGGER.error("Cannot retrieve roles for dashboard '" + DashboardRestApi.replaceCRLFCharacters(url) + "'", (Throwable)e);
            return Response.serverError().entity((Object)("Cannot retrieve roles for dashboard '" + url + "'")).build();
        }
    }

    @POST
    @Path(value="/{url}/roles")
    @Consumes(value={"application/json"})
    public Response updateDashboardRoles(@PathParam(value="url") String url, @Context Request request, Map<String, List<String>> roles) {
        try {
            this.dashboardDataProvider.updateDashboardRoles(DashboardRestApi.getUserName(request), url, roles);
            return Response.ok().build();
        }
        catch (UnauthorizedException e) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)("Insufficient permissions to update the roles of dashboard with ID : " + url)).build();
        }
        catch (DashboardException e) {
            LOGGER.error("Cannot update user roles of dashboard '" + DashboardRestApi.replaceCRLFCharacters(url) + "'.", (Throwable)e);
            return Response.serverError().entity((Object)("Cannot update user roles of dashboard '" + url + "'.")).build();
        }
    }

    @GET
    @Path(value="/{url}/export")
    @Produces(value={"application/json"})
    public Response exportDashboard(@PathParam(value="url") String url, @QueryParam(value="download") boolean download, @QueryParam(value="permissions") boolean permissions, @Context Request request) {
        try {
            DashboardArtifact artifact = this.dashboardDataProvider.exportDashboard(url, permissions, DashboardRestApi.getUserName(request));
            Response.ResponseBuilder responseBuilder = Response.ok((Object)artifact);
            if (download) {
                responseBuilder.header("Content-Disposition", (Object)("attachment; filename=\"" + DashboardRestApi.replaceCRLFCharacters(url) + ".json\""));
            }
            return responseBuilder.build();
        }
        catch (DashboardException e) {
            LOGGER.error("Cannot export dashboard '" + DashboardRestApi.replaceCRLFCharacters(url) + "'.", (Throwable)e);
            return Response.serverError().entity((Object)("Cannot export dashboard '" + url + "'.")).build();
        }
    }

    private static String getUserName(Request request) {
        return request.getProperty("username").toString();
    }

    private static String replaceCRLFCharacters(String str) {
        if (str != null) {
            str = str.replace('\n', '_').replace('\r', '_');
        }
        return str;
    }

    @GET
    @Path(value="/report-config")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response getReportConfigs() {
        Map reportConfigurations = this.dashboardDataProvider.getReportGenerationConfigurations().getReportConfigs();
        return Response.ok().entity((Object)reportConfigurations).build();
    }

    @GET
    @Path(value="/theme-config-path")
    public Response getThemeConfigPath(@Context Request request) {
        String logoPath;
        try {
            logoPath = this.dashboardDataProvider.getThemeConfigPath(DashboardRestApi.getUserName(request));
        }
        catch (DashboardException e) {
            LOGGER.error("Cannot get the path where theme resources are stored.", (Throwable)e);
            return Response.serverError().entity((Object)"Cannot get the path where theme resources are stored.").build();
        }
        return Response.ok().entity((Object)logoPath).build();
    }
}

