/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dashboards.api.internal;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.config.ConfigurationException;
import org.wso2.carbon.config.provider.ConfigProvider;
import org.wso2.carbon.dashboards.api.internal.DashboardRestApi;
import org.wso2.carbon.dashboards.api.internal.WidgetRestApi;
import org.wso2.carbon.dashboards.core.DashboardMetadataProvider;
import org.wso2.carbon.uiserver.api.App;
import org.wso2.carbon.uiserver.spi.RestApiProvider;
import org.wso2.msf4j.Microservice;

@Component(service={RestApiProvider.class}, immediate=true)
public class DashboardRestApiProvider
implements RestApiProvider {
    public static final String DASHBOARD_PORTAL_APP_NAME = "analytics-dashboard";
    private static final String ADDITIONAL_APIS_PROP = "additional.apis";
    private static final Logger LOGGER = LoggerFactory.getLogger(DashboardRestApiProvider.class);
    private DashboardMetadataProvider dashboardMetadataProvider;
    private ConfigProvider configProvider;

    @Activate
    protected void activate(BundleContext bundleContext) {
        LOGGER.debug("{} activated.", (Object)this.getClass().getName());
    }

    @Deactivate
    protected void deactivate(BundleContext bundleContext) {
        LOGGER.debug("{} deactivated.", (Object)this.getClass().getName());
    }

    @Reference(service=DashboardMetadataProvider.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetDashboardMetadataProvider")
    protected void setDashboardMetadataProvider(DashboardMetadataProvider dashboardDataProvider) {
        this.dashboardMetadataProvider = dashboardDataProvider;
        LOGGER.debug("DashboardMetadataProvider '{}' registered.", (Object)dashboardDataProvider.getClass().getName());
    }

    protected void unsetDashboardMetadataProvider(DashboardMetadataProvider dashboardDataProvider) {
        this.dashboardMetadataProvider = null;
        LOGGER.debug("DashboardMetadataProvider '{}' unregistered.", (Object)dashboardDataProvider.getClass().getName());
    }

    @Reference(service=ConfigProvider.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unregisterConfigProvider")
    protected void registerConfigProvider(ConfigProvider configProvider) {
        this.configProvider = configProvider;
        LOGGER.debug("ConfigProvider '{}' registered.", (Object)configProvider.getClass().getName());
    }

    protected void unregisterConfigProvider(ConfigProvider configProvider) {
        this.configProvider = null;
        LOGGER.debug("ConfigProvider '{}' unregistered.", (Object)configProvider.getClass().getName());
    }

    public String getAppName() {
        return DASHBOARD_PORTAL_APP_NAME;
    }

    public Map<String, Microservice> getMicroservices(App app) {
        this.dashboardMetadataProvider.init(app);
        HashMap<String, Microservice> additionalServices = this.getAdditionalApiServices();
        HashMap<String, Microservice> microservices = new HashMap<String, Microservice>(additionalServices.size() + 2);
        microservices.put("/apis/dashboards", new DashboardRestApi(this.dashboardMetadataProvider));
        microservices.put("/apis/widgets", new WidgetRestApi(this.dashboardMetadataProvider.getWidgetMetadataProvider()));
        microservices.putAll(additionalServices);
        return microservices;
    }

    private HashMap<String, Microservice> getAdditionalApiServices() {
        HashMap<String, Microservice> microservices = new HashMap<String, Microservice>();
        try {
            LinkedHashMap additionalApis = (LinkedHashMap)this.configProvider.getConfigurationObject(ADDITIONAL_APIS_PROP);
            if (additionalApis != null) {
                additionalApis.forEach((path, impl) -> {
                    try {
                        Class<?> serviceClass = Class.forName(impl);
                        Microservice microservice = (Microservice)serviceClass.newInstance();
                        microservices.put((String)path, microservice);
                    }
                    catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                        LOGGER.error("Error occurred while registering microservice '{}' for path '{}'. Error: {}", new Object[]{impl, path, e.getMessage()});
                    }
                });
            }
        }
        catch (ConfigurationException e) {
            LOGGER.error("Error occurred while accessing Additional API configuration: {}", (Object)e.getMessage());
        }
        return microservices;
    }
}

