/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dashboards.core;

import com.google.gson.JsonElement;
import feign.Response;
import feign.RetryableException;
import feign.gson.GsonDecoder;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.analytics.idp.client.core.api.AnalyticsHttpClientBuilderService;
import org.wso2.carbon.config.ConfigurationException;
import org.wso2.carbon.config.provider.ConfigProvider;
import org.wso2.carbon.dashboards.core.DashboardMetadataProvider;
import org.wso2.carbon.dashboards.core.WidgetMetadataProvider;
import org.wso2.carbon.dashboards.core.bean.DashboardMetadata;
import org.wso2.carbon.dashboards.core.bean.DashboardMetadataContent;
import org.wso2.carbon.dashboards.core.bean.authorizer.TenantIdInfo;
import org.wso2.carbon.dashboards.core.bean.importer.WidgetType;
import org.wso2.carbon.dashboards.core.bean.widget.WidgetConfigs;
import org.wso2.carbon.dashboards.core.bean.widget.WidgetMetaInfo;
import org.wso2.carbon.dashboards.core.exception.DashboardException;
import org.wso2.carbon.dashboards.core.exception.UnauthorizedException;
import org.wso2.carbon.dashboards.core.internal.authorizer.DashboardAuthorizerServiceFactory;
import org.wso2.carbon.dashboards.core.utils.DashboardUtil;
import org.wso2.carbon.data.provider.DataProviderAuthorizer;
import org.wso2.carbon.data.provider.bean.DataProviderConfigRoot;
import org.wso2.carbon.data.provider.exception.DataProviderException;

@Component(service={DataProviderAuthorizer.class}, immediate=true)
public class DashboardDataProviderAuthorizer
implements DataProviderAuthorizer {
    private static final Logger LOGGER = LoggerFactory.getLogger(DashboardDataProviderAuthorizer.class);
    private static final String AUTH_CONFIGS_HEADER = "auth.configs";
    private static final String AUTH_CONFIGS_PROPERTIES_HEADER = "properties";
    private static final String ADMIN_SERVICE_BASE_URL_KEY = "adminServiceBaseUrl";
    private static final String ADMIN_SERVICE_USERNAME_KEY = "adminServiceUsername";
    private static final String ADMIN_SERVICE_PASSWORD_KEY = "adminServicePassword";
    private static final String MAIN_CONFIG = "configs";
    private static final String DATA_PROVIDER_CONFIG = "config";
    private static final String QUERY_DATA = "queryData";
    private static final String QUERY_VALUES = "queryValues";
    private static final String QUERY_NAME = "queryName";
    private static final String QUERY_PROPERTY_NAME = "query";
    private static final String NOT_LIKE_CONTEXT_PATH = "not like '/t/%'";
    private static final String LIKE_CONTEXT_PATH = "like '/t/{{tenantDomain}}/%'";
    private static final String CONTEXT_CONDITION_KEY = "{{contextCondition}}";
    private static final String TENANT_DOMAIN_KEY = "{{tenantDomain}}";
    private static final String TENANT_ID_KEY = "{{tenantId}}";
    private static final String SUPER_TENANT_DOMAIN = "carbon.super";
    private AnalyticsHttpClientBuilderService clientBuilderService;
    private DashboardMetadataProvider dashboardMetadataProvider;
    private ConfigProvider configProvider;

    @Reference(service=DashboardMetadataProvider.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetDashboardMetadataProvider")
    protected void setDashboardMetadataProvider(DashboardMetadataProvider dashboardDataProvider) {
        this.dashboardMetadataProvider = dashboardDataProvider;
        LOGGER.debug("DashboardMetadataProvider '{}' registered.", (Object)dashboardDataProvider.getClass().getName());
    }

    protected void unsetDashboardMetadataProvider(DashboardMetadataProvider dashboardDataProvider) {
        this.dashboardMetadataProvider = null;
        LOGGER.debug("DashboardMetadataProvider '{}' unregistered.", (Object)dashboardDataProvider.getClass().getName());
    }

    @Reference(name="carbon.anaytics.common.clientservice", service=AnalyticsHttpClientBuilderService.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unregisterAnalyticsHttpClient")
    protected void registerAnalyticsHttpClient(AnalyticsHttpClientBuilderService service) {
        this.clientBuilderService = service;
        LOGGER.debug("AnalyticsHttpClientBuilderService '{}' registered.", (Object)service.getClass().getName());
    }

    protected void unregisterAnalyticsHttpClient(AnalyticsHttpClientBuilderService service) {
        this.clientBuilderService = null;
        LOGGER.debug("AnalyticsHttpClientBuilderService '{}' unregistered.", (Object)service.getClass().getName());
    }

    @Reference(service=ConfigProvider.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetConfigProvider")
    protected void setConfigProvider(ConfigProvider configProvider) {
        this.configProvider = configProvider;
        LOGGER.debug("ConfigProvider '{}' registered.", (Object)configProvider.getClass().getName());
    }

    protected void unsetConfigProvider(ConfigProvider configProvider) {
        this.configProvider = null;
        LOGGER.debug("ConfigProvider '{}' unregistered.", (Object)configProvider.getClass().getName());
    }

    public boolean authorize(DataProviderConfigRoot dataProviderConfigRoot) throws DataProviderException {
        Optional<WidgetMetaInfo> widgetMetaInfo;
        Optional<DashboardMetadata> dashboardMetadata;
        if (dataProviderConfigRoot.getAction().equalsIgnoreCase(DataProviderConfigRoot.Types.UNSUBSCRIBE.toString())) {
            return true;
        }
        String dashboardId = dataProviderConfigRoot.getDashboardId();
        String username = dataProviderConfigRoot.getUsername();
        String widgetName = dataProviderConfigRoot.getWidgetName();
        if (dashboardId == null || dashboardId.isEmpty()) {
            String error = "Dashboard Id in the Data Provider Config cannot be empty.";
            LOGGER.error(error);
            throw new DataProviderException(error);
        }
        if (username == null || username.isEmpty()) {
            String error = "Username in the Data Provider Config cannot be empty.";
            LOGGER.error(error);
            throw new DataProviderException(error);
        }
        if (widgetName == null || widgetName.isEmpty()) {
            String error = "Widget Name in the Data Provider Config cannot be empty.";
            LOGGER.error(error);
            throw new DataProviderException(error);
        }
        try {
            dashboardMetadata = this.dashboardMetadataProvider.getDashboardByUser(username, dashboardId, null);
        }
        catch (UnauthorizedException e) {
            return false;
        }
        catch (DashboardException e) {
            String error = e.getMessage();
            LOGGER.error(error, (Throwable)e);
            throw new DataProviderException(error, (Throwable)e);
        }
        if (!dashboardMetadata.isPresent()) {
            return false;
        }
        DashboardMetadataContent dashboardMetadataContent = dashboardMetadata.get().getContent();
        Map<WidgetType, Set<String>> widgets = DashboardUtil.findWidgets(dashboardMetadataContent);
        boolean isWidgetAvailableInDashboard = false;
        for (String widget : widgets.get((Object)WidgetType.CUSTOM)) {
            if (!widget.equalsIgnoreCase(widgetName)) continue;
            isWidgetAvailableInDashboard = true;
            break;
        }
        if (!isWidgetAvailableInDashboard) {
            for (String widget : widgets.get((Object)WidgetType.GENERATED)) {
                if (!widget.equalsIgnoreCase(widgetName)) continue;
                isWidgetAvailableInDashboard = true;
                break;
            }
        }
        if (!isWidgetAvailableInDashboard) {
            return false;
        }
        WidgetMetadataProvider widgetMetadataProvider = this.dashboardMetadataProvider.getWidgetMetadataProvider();
        try {
            widgetMetaInfo = widgetMetadataProvider.getWidgetConfiguration(widgetName);
        }
        catch (DashboardException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new DataProviderException(e.getMessage(), (Throwable)e);
        }
        if (!widgetMetaInfo.isPresent()) {
            String error = "Widget configuration cannot be found.";
            LOGGER.error(error);
            throw new DataProviderException(error);
        }
        WidgetConfigs widgetConfigs = widgetMetaInfo.get().getConfigs();
        JsonElement dataProviderConfig = widgetConfigs.getProviderConfig();
        this.assembleQuery(username, dataProviderConfigRoot, dataProviderConfig);
        LOGGER.debug("Authorized via the '{}' class.", (Object)this.getClass().getName());
        return true;
    }

    private void assembleQuery(String username, DataProviderConfigRoot dataProviderConfigRoot, JsonElement dataProviderConfig) throws DataProviderException {
        JsonElement queryValues = null;
        String[] usernameSections = username.split("@");
        String tenantDomain = usernameSections[usernameSections.length - 1];
        if (dataProviderConfig.getAsJsonObject().get(MAIN_CONFIG) == null || dataProviderConfig.getAsJsonObject().get(MAIN_CONFIG).getAsJsonObject().get(DATA_PROVIDER_CONFIG) == null || dataProviderConfig.getAsJsonObject().get(MAIN_CONFIG).getAsJsonObject().get(DATA_PROVIDER_CONFIG).getAsJsonObject().get(QUERY_DATA) == null) {
            String error = "Cannot find the query data in the widget configuration.";
            LOGGER.error(error);
            throw new DataProviderException(error);
        }
        JsonElement queryData = dataProviderConfig.getAsJsonObject().get(MAIN_CONFIG).getAsJsonObject().get(DATA_PROVIDER_CONFIG).getAsJsonObject().get(QUERY_DATA);
        if (dataProviderConfigRoot.getDataProviderConfiguration() == null || dataProviderConfigRoot.getDataProviderConfiguration().getAsJsonObject().get(QUERY_DATA) == null || dataProviderConfigRoot.getDataProviderConfiguration().getAsJsonObject().get(QUERY_DATA).getAsJsonObject().get(QUERY_NAME) == null) {
            String error = "Query Name cannot be found in the data provider configuration root.";
            LOGGER.error(error);
            throw new DataProviderException(error);
        }
        String queryName = dataProviderConfigRoot.getDataProviderConfiguration().getAsJsonObject().get(QUERY_DATA).getAsJsonObject().get(QUERY_NAME).getAsString();
        if (queryName == null || queryName.isEmpty() || queryData.getAsJsonObject().get(queryName) == null) {
            String error = "Cannot find the query in the widget configuration.";
            LOGGER.error(error);
            throw new DataProviderException(error);
        }
        String query = queryData.getAsJsonObject().get(queryName).getAsString();
        if (dataProviderConfigRoot.getDataProviderConfiguration() != null && dataProviderConfigRoot.getDataProviderConfiguration().getAsJsonObject().get(QUERY_DATA) != null && dataProviderConfigRoot.getDataProviderConfiguration().getAsJsonObject().get(QUERY_DATA).getAsJsonObject().get(QUERY_VALUES) != null) {
            queryValues = dataProviderConfigRoot.getDataProviderConfiguration().getAsJsonObject().get(QUERY_DATA).getAsJsonObject().get(QUERY_VALUES);
        }
        if (queryValues != null) {
            for (String key : queryValues.getAsJsonObject().keySet()) {
                String keyValue = queryValues.getAsJsonObject().get(key).getAsString();
                if (keyValue == null) {
                    String error = "Cannot find the replaceable value for " + key + ".";
                    LOGGER.error(error);
                    throw new DataProviderException(error);
                }
                query = query.replace(key, keyValue);
            }
        }
        if (tenantDomain != null && !tenantDomain.isEmpty()) {
            String contextPath = tenantDomain.equalsIgnoreCase(SUPER_TENANT_DOMAIN) ? NOT_LIKE_CONTEXT_PATH : LIKE_CONTEXT_PATH;
            String tenantId = this.getTenantId(username);
            query = query.replace(CONTEXT_CONDITION_KEY, contextPath).replace(TENANT_DOMAIN_KEY, tenantDomain).replace(TENANT_ID_KEY, tenantId);
        }
        Objects.requireNonNull(dataProviderConfigRoot.getDataProviderConfiguration()).getAsJsonObject().get(QUERY_DATA).getAsJsonObject().addProperty(QUERY_PROPERTY_NAME, query);
    }

    private String getTenantId(String username) throws DataProviderException {
        String error;
        String adminPassword;
        String adminUsername;
        String adminServiceUrl;
        try {
            Map properties;
            Map authConfigs = (Map)this.configProvider.getConfigurationObject(AUTH_CONFIGS_HEADER);
            if (authConfigs == null) {
                String error2 = "Cannot find auth.configs in the deployment.yaml file.";
                LOGGER.error(error2);
                throw new DataProviderException(error2);
            }
            if (authConfigs.containsKey(AUTH_CONFIGS_PROPERTIES_HEADER)) {
                properties = (Map)authConfigs.get(AUTH_CONFIGS_PROPERTIES_HEADER);
                if (properties == null) {
                    String error3 = "properties header under auth.configs in the deployment.yaml file cannot be empty";
                    LOGGER.error(error3);
                    throw new DataProviderException(error3);
                }
            } else {
                String error4 = "Cannot find properties header under the auth.configs in the deployment.yaml file.";
                LOGGER.error(error4);
                throw new DataProviderException(error4);
            }
            adminServiceUrl = this.getPropertyValueFromParentMap(properties, ADMIN_SERVICE_BASE_URL_KEY);
            adminUsername = this.getPropertyValueFromParentMap(properties, ADMIN_SERVICE_USERNAME_KEY);
            adminPassword = this.getPropertyValueFromParentMap(properties, ADMIN_SERVICE_PASSWORD_KEY);
        }
        catch (ConfigurationException e) {
            String error5 = "Error occurred while getting the auth.configs configuration from deployment.yaml file.";
            LOGGER.error(error5);
            throw new DataProviderException(error5);
        }
        try {
            Response response = DashboardAuthorizerServiceFactory.getAuthorizerHttpsClient(this.clientBuilderService, adminServiceUrl, adminUsername, adminPassword).getTenantId(username);
            if (response == null) {
                error = "Response returned from the admin rest api is null.";
                LOGGER.error(error);
                throw new DataProviderException(error);
            }
            if (response.status() == 200) {
                TenantIdInfo tenantIdInfo = (TenantIdInfo)new GsonDecoder().decode(response, TenantIdInfo.class);
                String tenantId = tenantIdInfo.getTenantId().toString();
                if (tenantId.isEmpty()) {
                    String error6 = "Tenant Id cannot be found.";
                    LOGGER.error(error6);
                    throw new DataProviderException(error6);
                }
                return tenantId;
            }
            if (response.status() == 401) {
                error = "Unauthorized to get response from admin rest api. Status Code: " + response.status();
                LOGGER.error(error);
                throw new DataProviderException(error);
            }
            error = "Unknown Error occurred while getting response from admin rest api. Status Code: " + response.status();
            LOGGER.error(error);
            throw new DataProviderException(error);
        }
        catch (RetryableException e) {
            error = "Unable to reach the admin rest api.";
            LOGGER.error(error, (Throwable)e);
            throw new DataProviderException(error, (Throwable)e);
        }
        catch (IOException e) {
            error = "Error occurred while parsing the admin rest api response.";
            LOGGER.error(error, (Throwable)e);
            throw new DataProviderException(error, (Throwable)e);
        }
    }

    private String getPropertyValueFromParentMap(Map parentConfigMap, String keyToBeChecked) throws DataProviderException {
        if (parentConfigMap.containsKey(keyToBeChecked)) {
            String value = (String)parentConfigMap.get(keyToBeChecked);
            if (value == null || value.isEmpty()) {
                String error = "Value of the property '" + keyToBeChecked + "' cannot be empty. Please define the value for the property under " + AUTH_CONFIGS_HEADER + " in the deployment.yaml file.";
                LOGGER.error(error);
                throw new DataProviderException(error);
            }
            return value;
        }
        String error = "Cannot find property " + keyToBeChecked + " under " + AUTH_CONFIGS_HEADER + " in the deployment.yaml file.";
        LOGGER.error(error);
        throw new DataProviderException(error);
    }
}

