/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dashboards.core.internal;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.dashboards.core.DashboardMetadataProvider;
import org.wso2.carbon.dashboards.core.WidgetMetadataProvider;
import org.wso2.carbon.dashboards.core.bean.DashboardMetadata;
import org.wso2.carbon.dashboards.core.bean.importer.DashboardArtifact;
import org.wso2.carbon.dashboards.core.bean.importer.WidgetType;
import org.wso2.carbon.dashboards.core.bean.widget.GeneratedWidgetConfigs;
import org.wso2.carbon.dashboards.core.exception.DashboardException;
import org.wso2.carbon.dashboards.core.internal.io.DashboardArtifactHandler;
import org.wso2.carbon.utils.Utils;

public class DashboardImporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(DashboardImporter.class);
    public static final String PERMISSION_VIEWERS = "viewers";
    public static final String PERMISSION_EDITORS = "editors";
    public static final String PERMISSION_OWNERS = "owners";
    public static final String PERMISSION_VIEWER = "viewer";
    public static final String PERMISSION_EDITOR = "editor";
    public static final String PERMISSION_OWNER = "owner";
    private final DashboardMetadataProvider dashboardMetadataProvider;
    private final WidgetMetadataProvider widgetMetadataProvider;

    public DashboardImporter(DashboardMetadataProvider dashboardMetadataProvider, WidgetMetadataProvider widgetMetadataProvider) {
        this.dashboardMetadataProvider = dashboardMetadataProvider;
        this.widgetMetadataProvider = widgetMetadataProvider;
    }

    public void importDashboards() {
        Map<String, DashboardArtifact> dashboardArtifacts;
        Path path = Utils.getRuntimePath().resolve(Paths.get("resources", "dashboards"));
        try {
            dashboardArtifacts = DashboardArtifactHandler.readArtifactsIn(path);
        }
        catch (DashboardException e) {
            LOGGER.error("Cannot read dashboard artifacts in '{}' to import.", (Object)path, (Object)e);
            return;
        }
        for (Map.Entry<String, DashboardArtifact> entry : dashboardArtifacts.entrySet()) {
            DashboardArtifact dashboardArtifact = entry.getValue();
            DashboardMetadata dashboard = dashboardArtifact.getDashboard();
            String dashboardArtifactPath = entry.getKey();
            boolean importedSuccessfully = true;
            try {
                if (this.dashboardMetadataProvider.get(dashboard.getUrl()).isPresent()) {
                    this.dashboardMetadataProvider.update(dashboard);
                } else {
                    this.dashboardMetadataProvider.add(dashboard);
                }
                Map<String, List<String>> permissionMap = dashboardArtifact.getPermissions();
                if (permissionMap.containsKey(PERMISSION_VIEWERS)) {
                    permissionMap.put(PERMISSION_VIEWER, permissionMap.remove(PERMISSION_VIEWERS));
                }
                if (permissionMap.containsKey(PERMISSION_EDITORS)) {
                    permissionMap.put(PERMISSION_EDITOR, permissionMap.remove(PERMISSION_EDITORS));
                }
                if (permissionMap.containsKey(PERMISSION_OWNERS)) {
                    permissionMap.put(PERMISSION_OWNER, permissionMap.remove(PERMISSION_OWNERS));
                }
                this.dashboardMetadataProvider.updateDashboardRoles(dashboard.getUrl(), dashboardArtifact.getPermissions(), null);
            }
            catch (DashboardException e) {
                LOGGER.warn("Cannot save dashboard importing from '{}' to the database.", (Object)dashboardArtifactPath, (Object)e);
                continue;
            }
            for (String widgetId : dashboardArtifact.getWidgets().getCustom()) {
                try {
                    if (this.widgetMetadataProvider.isWidgetPresent(widgetId, WidgetType.ALL)) continue;
                    LOGGER.warn("Widget '{}' does not exists. Please copy the widget to 'deployment/web-ui-apps/analytics-dashboard/extensions/widgets/' directory.", (Object)widgetId);
                }
                catch (DashboardException e) {
                    LOGGER.warn("Cannot check existence of custom widget '{}' which is included in the importing dashboard '{}'.", new Object[]{widgetId, dashboardArtifactPath, e});
                    importedSuccessfully = false;
                }
            }
            for (GeneratedWidgetConfigs widgetConfigs : dashboardArtifact.getWidgets().getGenerated()) {
                String widgetConfigsId = widgetConfigs.getId();
                try {
                    if (!this.widgetMetadataProvider.isWidgetPresent(widgetConfigsId, WidgetType.GENERATED)) {
                        this.widgetMetadataProvider.addGeneratedWidgetConfigs(widgetConfigs);
                    } else {
                        this.widgetMetadataProvider.updateGeneratedWidgetConfigs(widgetConfigs);
                    }
                    LOGGER.debug("Successfully imported generated widget '{}' from dashboard '{}'.", (Object)widgetConfigsId, (Object)dashboardArtifactPath);
                }
                catch (DashboardException e) {
                    LOGGER.warn("Cannot load generated widget '{}' which is included in the importing dashboard '{}'. Hence, dashboard will be imported partially.", new Object[]{widgetConfigsId, dashboardArtifactPath, e});
                    importedSuccessfully = false;
                }
            }
            DashboardArtifactHandler.markArtifactAsImported(dashboardArtifactPath);
            LOGGER.info("{} imported dashboard '{}' from '{}'.", new Object[]{importedSuccessfully ? "Successfully" : "Partially", dashboard.getUrl(), dashboardArtifactPath});
        }
    }
}

