/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dashboards.core.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.analytics.idp.client.core.api.IdPClient;
import org.wso2.carbon.analytics.idp.client.core.exception.IdPClientException;
import org.wso2.carbon.analytics.idp.client.core.models.Role;
import org.wso2.carbon.analytics.permissions.PermissionProvider;
import org.wso2.carbon.analytics.permissions.bean.Permission;
import org.wso2.carbon.analytics.permissions.exceptions.PermissionException;
import org.wso2.carbon.dashboards.core.DashboardMetadataProvider;
import org.wso2.carbon.dashboards.core.WidgetMetadataProvider;
import org.wso2.carbon.dashboards.core.bean.DashboardConfigurations;
import org.wso2.carbon.dashboards.core.bean.DashboardMetadata;
import org.wso2.carbon.dashboards.core.bean.importer.DashboardArtifact;
import org.wso2.carbon.dashboards.core.bean.importer.WidgetCollection;
import org.wso2.carbon.dashboards.core.bean.importer.WidgetType;
import org.wso2.carbon.dashboards.core.bean.widget.GeneratedWidgetConfigs;
import org.wso2.carbon.dashboards.core.exception.DashboardException;
import org.wso2.carbon.dashboards.core.exception.DashboardRuntimeException;
import org.wso2.carbon.dashboards.core.exception.UnauthorizedException;
import org.wso2.carbon.dashboards.core.internal.DashboardImporter;
import org.wso2.carbon.dashboards.core.internal.WidgetMetadataProviderImpl;
import org.wso2.carbon.dashboards.core.internal.database.DashboardMetadataDao;
import org.wso2.carbon.dashboards.core.internal.database.DashboardMetadataDaoFactory;
import org.wso2.carbon.dashboards.core.internal.roles.provider.RolesProvider;
import org.wso2.carbon.dashboards.core.utils.DashboardUtil;
import org.wso2.carbon.datasource.core.api.DataSourceService;
import org.wso2.carbon.uiserver.api.App;

public class DashboardMetadataProviderImpl
implements DashboardMetadataProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(DashboardMetadataProviderImpl.class);
    private static final String PERMISSION_APP_NAME = "DASH";
    private static final String PERMISSION_SUFFIX_VIEWER = ".viewer";
    private static final String PERMISSION_SUFFIX_EDITOR = ".editor";
    private static final String PERMISSION_SUFFIX_OWNER = ".owner";
    private final DashboardMetadataDao dao;
    private DataSourceService dataSourceService;
    private final DashboardConfigurations dashboardConfigurations;
    private final PermissionProvider permissionProvider;
    private final IdPClient identityClient;
    private WidgetMetadataProvider widgetMetadataProvider;

    public DashboardMetadataProviderImpl(DataSourceService dataSourceService, DashboardConfigurations dashboardConfigurations, PermissionProvider permissionProvider, IdPClient identityClient) {
        try {
            this.dao = DashboardMetadataDaoFactory.createDao(dataSourceService, dashboardConfigurations);
            this.dao.initDashboardTable();
        }
        catch (DashboardException e) {
            throw new DashboardRuntimeException("Cannot create dashboard DAO for DB access.", e);
        }
        this.dataSourceService = dataSourceService;
        this.dashboardConfigurations = dashboardConfigurations;
        this.permissionProvider = permissionProvider;
        this.identityClient = identityClient;
    }

    DashboardMetadataProviderImpl(DashboardMetadataDao dao, DashboardConfigurations dashboardConfigurations, PermissionProvider permissionProvider, IdPClient identityClient) {
        this.dao = dao;
        this.dashboardConfigurations = dashboardConfigurations;
        this.permissionProvider = permissionProvider;
        this.identityClient = identityClient;
    }

    @Override
    public void init(App dashboardApp) {
        this.widgetMetadataProvider = new WidgetMetadataProviderImpl(dashboardApp, this.dataSourceService, this.dashboardConfigurations);
        DashboardImporter dashboardImporter = new DashboardImporter(this, this.widgetMetadataProvider);
        dashboardImporter.importDashboards();
    }

    void setWidgetMetadataProvider(WidgetMetadataProvider widgetMetadataProvider) {
        this.widgetMetadataProvider = widgetMetadataProvider;
    }

    @Override
    public WidgetMetadataProvider getWidgetMetadataProvider() {
        return this.widgetMetadataProvider;
    }

    @Override
    public Optional<DashboardMetadata> get(String dashboardUrl) throws DashboardException {
        return this.dao.get(dashboardUrl);
    }

    @Override
    public Optional<DashboardMetadata> getDashboardByUser(String user, String dashboardUrl, String originComponent) throws DashboardException {
        boolean isAuthorized;
        boolean bl = isAuthorized = originComponent != null ? this.checkPermissions(user, dashboardUrl, originComponent) : this.checkPermissions(user, dashboardUrl);
        if (isAuthorized) {
            return this.get(dashboardUrl);
        }
        throw new UnauthorizedException("Insufficient permissions to retrieve the dashboard with ID" + dashboardUrl);
    }

    @Override
    public Set<DashboardMetadata> getAllByUser(String user) throws DashboardException {
        Set<DashboardMetadata> dashboardList = this.dao.getAll();
        return dashboardList.stream().filter(dashboardMetadata -> {
            if (this.permissionProvider.hasPermission(user, new Permission(PERMISSION_APP_NAME, dashboardMetadata.getUrl() + PERMISSION_SUFFIX_OWNER))) {
                dashboardMetadata.setHasOwnerPermission(true);
                dashboardMetadata.setHasDesignerPermission(true);
                dashboardMetadata.setHasViewerPermission(true);
                return true;
            }
            if (this.permissionProvider.hasPermission(user, new Permission(PERMISSION_APP_NAME, dashboardMetadata.getUrl() + PERMISSION_SUFFIX_EDITOR))) {
                dashboardMetadata.setHasDesignerPermission(true);
                dashboardMetadata.setHasViewerPermission(true);
                return true;
            }
            if (this.permissionProvider.hasPermission(user, new Permission(PERMISSION_APP_NAME, dashboardMetadata.getUrl() + PERMISSION_SUFFIX_VIEWER))) {
                dashboardMetadata.setHasViewerPermission(true);
                return true;
            }
            return false;
        }).collect(Collectors.toSet());
    }

    @Override
    public void add(DashboardMetadata dashboardMetadata) throws DashboardException {
        RolesProvider rolesProvider = new RolesProvider(this.dashboardConfigurations);
        this.dao.add(dashboardMetadata);
        for (Permission permission : this.buildDashboardPermissions(dashboardMetadata.getUrl())) {
            this.permissionProvider.addPermission(permission);
            for (String roleId : rolesProvider.getCreatorRoleIds()) {
                this.permissionProvider.grantPermission(permission, new org.wso2.carbon.analytics.permissions.bean.Role(roleId, ""));
            }
        }
    }

    @Override
    public void add(String user, DashboardMetadata dashboardMetadata) throws DashboardException {
        RolesProvider rolesProvider = new RolesProvider(this.dashboardConfigurations);
        List<String> creatorRoleIds = rolesProvider.getCreatorRoleIds();
        Set filteredRoleIds = creatorRoleIds.stream().filter(role -> this.hasRoles(user, (String)role)).collect(Collectors.toSet());
        if (!filteredRoleIds.isEmpty()) {
            this.dao.add(dashboardMetadata);
            for (Permission permission : this.buildDashboardPermissions(dashboardMetadata.getUrl())) {
                this.permissionProvider.addPermission(permission);
                for (String roleId : rolesProvider.getCreatorRoleIds()) {
                    this.permissionProvider.grantPermission(permission, new org.wso2.carbon.analytics.permissions.bean.Role(roleId, ""));
                }
            }
        } else {
            throw new UnauthorizedException("Insufficient permissions to add dashboards");
        }
    }

    @Override
    public void update(DashboardMetadata dashboardMetadata) throws DashboardException {
        this.dao.update(dashboardMetadata);
    }

    @Override
    public void update(String user, DashboardMetadata dashboardMetadata) throws DashboardException {
        if (!this.permissionProvider.hasPermission(user, new Permission(PERMISSION_APP_NAME, dashboardMetadata.getUrl() + PERMISSION_SUFFIX_OWNER)) && !this.permissionProvider.hasPermission(user, new Permission(PERMISSION_APP_NAME, dashboardMetadata.getUrl() + PERMISSION_SUFFIX_EDITOR))) {
            throw new UnauthorizedException("Insufficient permissions to update the dashboard with ID " + dashboardMetadata.getUrl());
        }
        this.dao.update(dashboardMetadata);
    }

    @Override
    public void delete(String user, String dashboardUrl) throws DashboardException {
        if (this.permissionProvider.hasPermission(user, new Permission(PERMISSION_APP_NAME, dashboardUrl + PERMISSION_SUFFIX_OWNER))) {
            this.dao.delete(dashboardUrl);
            for (Permission permission : this.buildDashboardPermissions(dashboardUrl)) {
                this.permissionProvider.deletePermission(permission);
            }
        } else {
            throw new UnauthorizedException("Insufficient permissions to delete the dashboard with the ID " + dashboardUrl);
        }
    }

    @Override
    public Map<String, List<org.wso2.carbon.analytics.permissions.bean.Role>> getDashboardRoles(String dashboardUrl, String username) throws DashboardException {
        HashMap<String, List<org.wso2.carbon.analytics.permissions.bean.Role>> roles = new HashMap<String, List<org.wso2.carbon.analytics.permissions.bean.Role>>();
        try {
            roles.put("owners", this.permissionProvider.getGrantedRolesOfTenant(new Permission(PERMISSION_APP_NAME, dashboardUrl + PERMISSION_SUFFIX_OWNER), username));
            roles.put("editors", this.permissionProvider.getGrantedRolesOfTenant(new Permission(PERMISSION_APP_NAME, dashboardUrl + PERMISSION_SUFFIX_EDITOR), username));
            roles.put("viewers", this.permissionProvider.getGrantedRolesOfTenant(new Permission(PERMISSION_APP_NAME, dashboardUrl + PERMISSION_SUFFIX_VIEWER), username));
        }
        catch (PermissionException e) {
            throw new DashboardException("Unable to get roles for the dashboard '" + dashboardUrl + "'", e);
        }
        return roles;
    }

    @Override
    public List<Role> getAllRoles(String username) throws DashboardException {
        try {
            return this.identityClient.getAllRolesOfTenant(username);
        }
        catch (IdPClientException e) {
            throw new DashboardException("Unable to get all user roles.", e);
        }
    }

    @Override
    public List<Role> getRolesByUsername(String username) throws DashboardException {
        try {
            return this.identityClient.getUserRoles(username);
        }
        catch (IdPClientException e) {
            throw new DashboardException("Unable to get user roles.", e);
        }
    }

    @Override
    public void updateDashboardRoles(String user, String dashboardUrl, Map<String, List<String>> roleIdMap) throws DashboardException {
        if (!this.permissionProvider.hasPermission(user, new Permission(PERMISSION_APP_NAME, dashboardUrl + PERMISSION_SUFFIX_OWNER))) {
            throw new UnauthorizedException("Insufficient permissions to update roles of the dashboard with ID" + dashboardUrl);
        }
        this.updateDashboardRoles(dashboardUrl, roleIdMap, user);
    }

    @Override
    public void updateDashboardRoles(String dashboardUrl, Map<String, List<String>> roleIdMap, String username) throws DashboardException {
        List allRoles;
        try {
            allRoles = username != null ? this.identityClient.getAllRolesOfTenant(username) : this.identityClient.getAllRoles();
        }
        catch (IdPClientException e) {
            throw new DashboardException("Unable to get all user roles.", e);
        }
        HashMap<String, org.wso2.carbon.analytics.permissions.bean.Role> allRoleMap = new HashMap<String, org.wso2.carbon.analytics.permissions.bean.Role>();
        for (Role role : allRoles) {
            allRoleMap.put(role.getDisplayName(), new org.wso2.carbon.analytics.permissions.bean.Role(role.getId(), role.getDisplayName()));
        }
        Iterator<Map.Entry<String, List<String>>> iterator = roleIdMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, List<String>> entry = iterator.next();
            Permission permission = new Permission(PERMISSION_APP_NAME, dashboardUrl + "." + entry.getKey().toString());
            this.permissionProvider.revokePermission(permission);
            for (String roleId : entry.getValue()) {
                this.permissionProvider.grantPermission(permission, (org.wso2.carbon.analytics.permissions.bean.Role)allRoleMap.get(roleId));
            }
            iterator.remove();
        }
    }

    @Override
    public DashboardArtifact exportDashboard(String dashboardUrl, boolean permissions, String username) throws DashboardException {
        Optional<DashboardMetadata> dashboardMetadataOptional = this.dao.get(dashboardUrl);
        Map<String, List<org.wso2.carbon.analytics.permissions.bean.Role>> dashboardRoles = this.getDashboardRoles(dashboardUrl, username);
        if (!dashboardMetadataOptional.isPresent()) {
            throw new DashboardException("Cannot find the dashboard '" + dashboardUrl + "'");
        }
        DashboardArtifact artifact = new DashboardArtifact();
        DashboardMetadata dashboardMetadata = dashboardMetadataOptional.get();
        artifact.setDashboard(dashboardMetadata);
        Map<WidgetType, Set<String>> widgets = DashboardUtil.findWidgets(dashboardMetadata.getContent());
        Set<GeneratedWidgetConfigs> generatedWidgetConfigs = this.widgetMetadataProvider.getGeneratedWidgetConfigs(widgets.get((Object)WidgetType.GENERATED));
        WidgetCollection widgetCollection = new WidgetCollection();
        widgetCollection.setGenerated(generatedWidgetConfigs);
        widgetCollection.setCustom(widgets.get((Object)WidgetType.CUSTOM));
        artifact.setWidgets(widgetCollection);
        if (permissions) {
            dashboardRoles.forEach((permission, roles) -> {
                List<String> roleNames = roles.stream().map(org.wso2.carbon.analytics.permissions.bean.Role::getName).collect(Collectors.toList());
                artifact.addPermissions((String)permission, roleNames);
            });
        }
        return artifact;
    }

    private List<Permission> buildDashboardPermissions(String dashboardUrl) {
        ArrayList<Permission> permissions = new ArrayList<Permission>();
        permissions.add(new Permission(PERMISSION_APP_NAME, dashboardUrl + PERMISSION_SUFFIX_OWNER));
        permissions.add(new Permission(PERMISSION_APP_NAME, dashboardUrl + PERMISSION_SUFFIX_EDITOR));
        permissions.add(new Permission(PERMISSION_APP_NAME, dashboardUrl + PERMISSION_SUFFIX_VIEWER));
        return permissions;
    }

    private boolean hasRoles(String user, String roleId) {
        try {
            Role adminRole = this.identityClient.getAdminRole();
            return this.identityClient.getUserRoles(user).stream().anyMatch(userRole -> Objects.equals(userRole.getId(), roleId) || Objects.equals(userRole.getId(), adminRole.getId()));
        }
        catch (IdPClientException e) {
            LOGGER.error("Error in retrieving user roles for the user " + user, (Throwable)e);
            return false;
        }
    }

    private boolean checkPermissions(String user, String dashboardUrl, String originComponent) {
        switch (originComponent) {
            case "designer": {
                return this.hasPermission(user, dashboardUrl, PERMISSION_SUFFIX_EDITOR) || this.hasPermission(user, dashboardUrl, PERMISSION_SUFFIX_OWNER);
            }
            case "settings": {
                return this.hasPermission(user, dashboardUrl, PERMISSION_SUFFIX_OWNER);
            }
        }
        return false;
    }

    private boolean checkPermissions(String user, String dashboardUrl) {
        return this.hasPermission(user, dashboardUrl, PERMISSION_SUFFIX_VIEWER) || this.hasPermission(user, dashboardUrl, PERMISSION_SUFFIX_EDITOR) || this.hasPermission(user, dashboardUrl, PERMISSION_SUFFIX_OWNER);
    }

    private boolean hasPermission(String user, String dashboardUrl, String permissionSuffix) {
        return this.permissionProvider.hasPermission(user, new Permission(PERMISSION_APP_NAME, dashboardUrl + permissionSuffix));
    }

    @Override
    public DashboardConfigurations getReportGenerationConfigurations() {
        return this.dashboardConfigurations;
    }

    @Override
    public boolean isCreator(String username) throws DashboardException {
        List userRoles;
        boolean isCreator = false;
        try {
            userRoles = this.identityClient.getUserRoles(username);
        }
        catch (IdPClientException e) {
            throw new DashboardException("Unable to get roles for the username.");
        }
        RolesProvider rolesProvider = new RolesProvider(this.dashboardConfigurations);
        List<String> creatorRoleIds = rolesProvider.getCreatorRoleIds();
        block2: for (Role userRole : userRoles) {
            for (String creatorRoleId : creatorRoleIds) {
                if (!userRole.getId().equalsIgnoreCase(creatorRoleId)) continue;
                isCreator = true;
                continue block2;
            }
        }
        return isCreator;
    }
}

