/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dashboards.core.internal;

import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.analytics.idp.client.core.api.IdPClient;
import org.wso2.carbon.analytics.permissions.PermissionManager;
import org.wso2.carbon.analytics.permissions.PermissionProvider;
import org.wso2.carbon.config.ConfigurationException;
import org.wso2.carbon.config.provider.ConfigProvider;
import org.wso2.carbon.dashboards.core.DashboardMetadataProvider;
import org.wso2.carbon.dashboards.core.bean.DashboardConfigurations;
import org.wso2.carbon.dashboards.core.internal.DashboardMetadataProviderImpl;
import org.wso2.carbon.datasource.core.api.DataSourceService;

@Component(immediate=true)
public class StartupListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(StartupListener.class);
    private DataSourceService dataSourceService;
    private DashboardConfigurations dashboardConfigurations;
    private PermissionProvider permissionProvider;
    private IdPClient idPClient;

    @Reference(service=DataSourceService.class, cardinality=ReferenceCardinality.AT_LEAST_ONE, policy=ReferencePolicy.DYNAMIC, unbind="unsetDataSourceService")
    protected void setDataSourceService(DataSourceService dataSourceService) {
        this.dataSourceService = dataSourceService;
    }

    protected void unsetDataSourceService(DataSourceService dataSourceService) {
        this.dataSourceService = null;
    }

    @Reference(service=ConfigProvider.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetConfigProvider")
    protected void setConfigProvider(ConfigProvider configProvider) {
        try {
            this.dashboardConfigurations = (DashboardConfigurations)configProvider.getConfigurationObject(DashboardConfigurations.class);
        }
        catch (ConfigurationException e) {
            LOGGER.error("Cannot load dashboard configurations from 'deployment.yaml'. Falling-back to defaults.", (Throwable)e);
            this.dashboardConfigurations = new DashboardConfigurations();
        }
    }

    protected void unsetConfigProvider(ConfigProvider configProvider) {
        LOGGER.debug("An instance of class '{}' unregistered as a config provider.", (Object)configProvider.getClass().getName());
    }

    @Reference(service=PermissionManager.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetPermissionManager")
    protected void setPermissionManager(PermissionManager permissionManager) {
        this.permissionProvider = permissionManager.getProvider();
    }

    protected void unsetPermissionManager(PermissionManager permissionManager) {
        this.permissionProvider = null;
    }

    @Reference(service=IdPClient.class, cardinality=ReferenceCardinality.MANDATORY, policy=ReferencePolicy.DYNAMIC, unbind="unsetIdPClient")
    protected void setIdPClient(IdPClient client) {
        this.idPClient = client;
    }

    protected void unsetIdPClient(IdPClient client) {
        this.idPClient = null;
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        DashboardMetadataProviderImpl dashboardMetadataProvider = new DashboardMetadataProviderImpl(this.dataSourceService, this.dashboardConfigurations, this.permissionProvider, this.idPClient);
        bundleContext.registerService(DashboardMetadataProvider.class, (Object)dashboardMetadataProvider, null);
        LOGGER.debug("{} activated.", (Object)this.getClass().getName());
    }

    @Deactivate
    protected void deactivate() {
        LOGGER.debug("{} deactivated.", (Object)this.getClass().getName());
    }
}

