/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dashboards.core.internal;

import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.wso2.carbon.dashboards.core.WidgetMetadataProvider;
import org.wso2.carbon.dashboards.core.bean.DashboardConfigurations;
import org.wso2.carbon.dashboards.core.bean.importer.WidgetType;
import org.wso2.carbon.dashboards.core.bean.widget.GeneratedWidgetConfigs;
import org.wso2.carbon.dashboards.core.bean.widget.WidgetConfigs;
import org.wso2.carbon.dashboards.core.bean.widget.WidgetMetaInfo;
import org.wso2.carbon.dashboards.core.exception.DashboardException;
import org.wso2.carbon.dashboards.core.exception.DashboardRuntimeException;
import org.wso2.carbon.dashboards.core.internal.database.WidgetMetadataDao;
import org.wso2.carbon.dashboards.core.internal.database.WidgetMetadataDaoFactory;
import org.wso2.carbon.dashboards.core.internal.io.WidgetConfigurationReader;
import org.wso2.carbon.datasource.core.api.DataSourceService;
import org.wso2.carbon.uiserver.api.App;

public class WidgetMetadataProviderImpl
implements WidgetMetadataProvider {
    private static final String EXTENSION_TYPE_WIDGETS = "widgets";
    private final App dashboardApp;
    private final WidgetMetadataDao widgetMetadataDao;

    public WidgetMetadataProviderImpl(App dashboardApp, DataSourceService dataSourceService, DashboardConfigurations dashboardConfigurations) {
        this.dashboardApp = dashboardApp;
        try {
            this.widgetMetadataDao = WidgetMetadataDaoFactory.createDao(dataSourceService, dashboardConfigurations);
            this.widgetMetadataDao.initWidgetTable();
        }
        catch (DashboardException e) {
            throw new DashboardRuntimeException("Cannot create widget DAO for DB access.", e);
        }
    }

    WidgetMetadataProviderImpl(App dashboardApp, WidgetMetadataDao dao) {
        this.dashboardApp = dashboardApp;
        this.widgetMetadataDao = dao;
    }

    @Override
    public Optional<WidgetMetaInfo> getWidgetConfiguration(String widgetId) throws DashboardException {
        GeneratedWidgetConfigs generatedWidgetConfigs = this.widgetMetadataDao.getGeneratedWidgetConfigsForId(widgetId);
        if (generatedWidgetConfigs != null) {
            WidgetMetaInfo widgetMetaInfo = new WidgetMetaInfo();
            WidgetConfigs widgetConfigs = new WidgetConfigs();
            widgetConfigs.setChartConfig(generatedWidgetConfigs.getChartConfig());
            widgetConfigs.setProviderConfig(generatedWidgetConfigs.getProviderConfig());
            widgetConfigs.setPubsub(generatedWidgetConfigs.getPubsub());
            widgetConfigs.setGenerated(true);
            widgetConfigs.setMetadata(generatedWidgetConfigs.getMetadata());
            widgetMetaInfo.setVersion(generatedWidgetConfigs.getVersion());
            widgetMetaInfo.setId(generatedWidgetConfigs.getId());
            widgetMetaInfo.setName(generatedWidgetConfigs.getName());
            widgetMetaInfo.setConfigs(widgetConfigs);
            return Optional.of(widgetMetaInfo);
        }
        return this.dashboardApp.getExtension(EXTENSION_TYPE_WIDGETS, widgetId).map(WidgetConfigurationReader::getConfiguration);
    }

    @Override
    public void addGeneratedWidgetConfigs(GeneratedWidgetConfigs generatedWidgetConfigs) throws DashboardException {
        this.widgetMetadataDao.addGeneratedWidgetConfigs(generatedWidgetConfigs);
    }

    @Override
    public void updateGeneratedWidgetConfigs(GeneratedWidgetConfigs generatedWidgetConfigs) throws DashboardException {
        this.widgetMetadataDao.updateGeneratedWidgetConfigs(generatedWidgetConfigs);
    }

    @Override
    public boolean isWidgetPresent(String widgetName) throws DashboardException {
        return this.isWidgetPresent(widgetName, WidgetType.CUSTOM);
    }

    @Override
    public boolean isWidgetPresent(String widgetName, WidgetType widgetType) throws DashboardException {
        switch (widgetType) {
            case CUSTOM: {
                return this.isCustomWidgetPresent(widgetName);
            }
            case GENERATED: {
                return this.isGeneratedWidgetPresent(widgetName);
            }
            case ALL: {
                return this.isCustomWidgetPresent(widgetName) || this.isGeneratedWidgetPresent(widgetName);
            }
        }
        return false;
    }

    private boolean isGeneratedWidgetPresent(String widgetName) throws DashboardException {
        return this.widgetMetadataDao.getGeneratedWidgetIdSet().stream().map(GeneratedWidgetConfigs::getId).anyMatch(name -> name.equals(widgetName));
    }

    private boolean isCustomWidgetPresent(String widgetName) {
        return this.dashboardApp.getExtension(EXTENSION_TYPE_WIDGETS, widgetName).isPresent();
    }

    @Override
    public Set<WidgetMetaInfo> getAllWidgetConfigurations() throws DashboardException {
        Set<WidgetMetaInfo> widgetMetaInfoSet = this.dashboardApp.getExtensions(EXTENSION_TYPE_WIDGETS).stream().map(WidgetConfigurationReader::getConfiguration).collect(Collectors.toSet());
        Set<GeneratedWidgetConfigs> generatedWidgetConfigsSet = this.widgetMetadataDao.getGeneratedWidgetIdSet();
        for (GeneratedWidgetConfigs generatedWidgetConfigs : generatedWidgetConfigsSet) {
            WidgetMetaInfo widgetMetaInfo = new WidgetMetaInfo();
            WidgetConfigs widgetConfigs = new WidgetConfigs();
            widgetMetaInfo.setId(generatedWidgetConfigs.getId());
            widgetMetaInfo.setName(generatedWidgetConfigs.getName());
            widgetConfigs.setPubsub(generatedWidgetConfigs.getPubsub());
            widgetConfigs.setMetadata(generatedWidgetConfigs.getMetadata());
            widgetConfigs.setGenerated(true);
            widgetMetaInfo.setVersion(generatedWidgetConfigs.getVersion());
            widgetMetaInfo.setConfigs(widgetConfigs);
            widgetMetaInfoSet.add(widgetMetaInfo);
        }
        return widgetMetaInfoSet;
    }

    @Override
    public Set<GeneratedWidgetConfigs> getGeneratedWidgetConfigs(Set<String> widgetIds) throws DashboardException {
        return this.widgetMetadataDao.getGeneratedWidgetIdSet().stream().filter(generatedWidgetConfigs -> widgetIds.contains(generatedWidgetConfigs.getId())).collect(Collectors.toSet());
    }

    @Override
    public void delete(String widgetId) throws DashboardException {
        this.widgetMetadataDao.delete(widgetId);
    }
}

