/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dashboards.core.internal.database;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonParseException;
import java.nio.charset.StandardCharsets;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.dashboards.core.bean.DashboardMetadata;
import org.wso2.carbon.dashboards.core.bean.DashboardMetadataContent;
import org.wso2.carbon.dashboards.core.exception.DashboardException;
import org.wso2.carbon.dashboards.core.internal.database.QueryManager;

public class DashboardMetadataDao {
    private static final Logger LOGGER = LoggerFactory.getLogger(DashboardMetadataDao.class);
    private static final Gson GSON = new Gson();
    private static final String COLUMN_DASHBOARD_LANDING_PAGE = "LANDING_PAGE";
    private static final String COLUMN_DASHBOARD_PARENT_ID = "PARENT_ID";
    private static final String COLUMN_DASHBOARD_CONTENT = "CONTENT";
    private static final String COLUMN_DASHBOARD_DESCRIPTION = "DESCRIPTION";
    private static final String COLUMN_DASHBOARD_NAME = "NAME";
    private static final String COLUMN_DASHBOARD_URL = "URL";
    private static final String COLUMN_DASHBOARD_OWNER = "OWNER";
    private final DataSource dataSource;
    private final QueryManager queryManager;

    public DashboardMetadataDao(DataSource dataSource, QueryManager queryManager) {
        this.dataSource = dataSource;
        this.queryManager = queryManager;
    }

    public void initDashboardTable() throws DashboardException {
        if (!this.tableExists("DASHBOARD_RESOURCE")) {
            this.createDashboardResourceTable();
        }
    }

    private void createDashboardResourceTable() throws DashboardException {
        Connection connection = null;
        PreparedStatement ps = null;
        String query = null;
        try {
            connection = this.getConnection();
            connection.setAutoCommit(false);
            query = this.queryManager.getQuery(connection, "create_dashboard_resource_table");
            ps = connection.prepareStatement(query);
            ps.executeUpdate();
            connection.commit();
        }
        catch (SQLException e) {
            try {
                DashboardMetadataDao.rollbackQuietly(connection);
                LOGGER.debug("Failed to execute SQL query {}", query);
                throw new DashboardException("Unable to create the 'DASHBOARD_RESOURCE' table.", e);
            }
            catch (Throwable throwable) {
                DashboardMetadataDao.closeQuietly(connection, ps, null);
                throw throwable;
            }
        }
        DashboardMetadataDao.closeQuietly(connection, ps, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean tableExists(String tableName) {
        boolean bl;
        Connection connection = null;
        PreparedStatement ps = null;
        String query = null;
        try {
            connection = this.getConnection();
            query = this.queryManager.getQuery(connection, "table_check");
            ps = connection.prepareStatement(query.replace("{{TABLE_NAME}}", tableName));
            ps.execute();
            bl = true;
        }
        catch (SQLException e) {
            boolean bl2;
            try {
                DashboardMetadataDao.rollbackQuietly(connection);
                LOGGER.debug("Table '{}' assumed to not exist since its existence check query {} resulted in exception {}.", new Object[]{tableName, query, e.getMessage()});
                bl2 = false;
            }
            catch (Throwable throwable) {
                DashboardMetadataDao.closeQuietly(connection, ps, null);
                throw throwable;
            }
            DashboardMetadataDao.closeQuietly(connection, ps, null);
            return bl2;
        }
        DashboardMetadataDao.closeQuietly(connection, ps, null);
        return bl;
    }

    public void update(DashboardMetadata dashboardMetadata) throws DashboardException {
        Connection connection = null;
        PreparedStatement ps = null;
        String query = null;
        try {
            connection = this.getConnection();
            query = this.queryManager.getQuery(connection, "update_dashboard_content");
            connection.setAutoCommit(false);
            ps = connection.prepareStatement(query);
            ps.setString(1, dashboardMetadata.getName());
            ps.setString(2, dashboardMetadata.getDescription());
            Blob blob = connection.createBlob();
            blob.setBytes(1L, DashboardMetadataDao.toJsonBytes(dashboardMetadata.getContent()));
            ps.setBlob(3, blob);
            ps.setString(4, dashboardMetadata.getParentId());
            ps.setString(5, dashboardMetadata.getLandingPage());
            ps.setString(6, dashboardMetadata.getUrl());
            ps.executeUpdate();
            connection.commit();
        }
        catch (SQLException e) {
            try {
                DashboardMetadataDao.rollbackQuietly(connection);
                LOGGER.debug("Failed to execute SQL query {}", (Object)query);
                throw new DashboardException("Cannot update dashboard " + dashboardMetadata + ".", e);
            }
            catch (Throwable throwable) {
                DashboardMetadataDao.closeQuietly(connection, ps, null);
                throw throwable;
            }
        }
        DashboardMetadataDao.closeQuietly(connection, ps, null);
    }

    public void add(DashboardMetadata dashboardMetadata) throws DashboardException {
        Connection connection = null;
        PreparedStatement ps = null;
        String query = null;
        try {
            connection = this.getConnection();
            query = this.queryManager.getQuery(connection, "add_dashboard");
            connection.setAutoCommit(false);
            ps = connection.prepareStatement(query);
            ps.setString(1, dashboardMetadata.getUrl());
            ps.setString(2, dashboardMetadata.getOwner());
            ps.setString(3, dashboardMetadata.getName());
            ps.setString(4, dashboardMetadata.getDescription());
            ps.setString(5, dashboardMetadata.getParentId());
            ps.setString(6, dashboardMetadata.getLandingPage());
            Blob blob = connection.createBlob();
            blob.setBytes(1L, DashboardMetadataDao.toJsonBytes(dashboardMetadata.getContent()));
            ps.setBlob(7, blob);
            ps.executeUpdate();
            connection.commit();
        }
        catch (SQLException e) {
            try {
                DashboardMetadataDao.rollbackQuietly(connection);
                LOGGER.debug("Failed to execute SQL query {}", (Object)query);
                throw new DashboardException("Cannot create a new dashboard with " + dashboardMetadata + ".", e);
            }
            catch (Throwable throwable) {
                DashboardMetadataDao.closeQuietly(connection, ps, null);
                throw throwable;
            }
        }
        DashboardMetadataDao.closeQuietly(connection, ps, null);
    }

    public void delete(String url) throws DashboardException {
        Connection connection = null;
        PreparedStatement ps = null;
        String query = null;
        try {
            connection = this.getConnection();
            query = this.queryManager.getQuery(connection, "delete_dashboard_by_url");
            connection.setAutoCommit(false);
            ps = connection.prepareStatement(query);
            ps.setString(1, url);
            ps.executeUpdate();
            connection.commit();
        }
        catch (SQLException e) {
            try {
                DashboardMetadataDao.rollbackQuietly(connection);
                LOGGER.debug("Failed to execute SQL query {}", (Object)query);
                throw new DashboardException("Cannot delete dashboard '" + url + "'.", e);
            }
            catch (Throwable throwable) {
                DashboardMetadataDao.closeQuietly(connection, ps, null);
                throw throwable;
            }
        }
        DashboardMetadataDao.closeQuietly(connection, ps, null);
    }

    public Optional<DashboardMetadata> get(String url) throws DashboardException {
        Optional<DashboardMetadata> dashboardMetadata2;
        String query;
        ResultSet result;
        PreparedStatement ps;
        Connection connection;
        block5: {
            connection = null;
            ps = null;
            result = null;
            query = null;
            connection = this.getConnection();
            query = this.queryManager.getQuery(connection, "get_dashboard_by_url");
            ps = connection.prepareStatement(query);
            ps.setString(1, url);
            result = ps.executeQuery();
            if (!result.next()) break block5;
            DashboardMetadata dashboardMetadata2 = DashboardMetadataDao.toDashboardMetadata(result);
            dashboardMetadata2.setContent(DashboardMetadataDao.parseDashboardMetadataContent(result.getBlob(COLUMN_DASHBOARD_CONTENT)));
            Optional<DashboardMetadata> optional = Optional.of(dashboardMetadata2);
            DashboardMetadataDao.closeQuietly(connection, ps, result);
            return optional;
        }
        try {
            dashboardMetadata2 = Optional.empty();
        }
        catch (SQLException e) {
            try {
                LOGGER.debug("Failed to execute SQL query {}", query);
                throw new DashboardException("Cannot retrieve dashboard for URl '" + url + "'.", e);
            }
            catch (Throwable throwable) {
                DashboardMetadataDao.closeQuietly(connection, ps, result);
                throw throwable;
            }
        }
        DashboardMetadataDao.closeQuietly(connection, ps, result);
        return dashboardMetadata2;
    }

    public Set<DashboardMetadata> getAll() throws DashboardException {
        HashSet<DashboardMetadata> dashboardMetadatas = new HashSet<DashboardMetadata>();
        Connection connection = null;
        PreparedStatement ps = null;
        ResultSet results = null;
        String query = null;
        try {
            connection = this.getConnection();
            query = this.queryManager.getQuery(connection, "get_dashboard_metadata_list");
            ps = connection.prepareStatement(query);
            results = ps.executeQuery();
            while (results.next()) {
                dashboardMetadatas.add(DashboardMetadataDao.toDashboardMetadata(results));
            }
        }
        catch (SQLException e) {
            try {
                LOGGER.debug("Failed to execute SQL query {}", query);
                throw new DashboardException("Cannot retrieve dashboards.", e);
            }
            catch (Throwable throwable) {
                DashboardMetadataDao.closeQuietly(connection, ps, results);
                throw throwable;
            }
        }
        DashboardMetadataDao.closeQuietly(connection, ps, results);
        return dashboardMetadatas;
    }

    private Connection getConnection() throws SQLException {
        return this.dataSource.getConnection();
    }

    private static byte[] toJsonBytes(Object dashboardPages) {
        return GSON.toJson(dashboardPages).getBytes(StandardCharsets.UTF_8);
    }

    private static DashboardMetadataContent parseDashboardMetadataContent(Blob blob) throws SQLException {
        String content = new String(blob.getBytes(1L, (int)blob.length()), StandardCharsets.UTF_8);
        try {
            return (DashboardMetadataContent)new Gson().fromJson(content, DashboardMetadataContent.class);
        }
        catch (JsonParseException e) {
            JsonArray pages = (JsonArray)new Gson().fromJson(content, JsonArray.class);
            DashboardMetadataContent dashboardMetadataContent = new DashboardMetadataContent(pages);
            return dashboardMetadataContent;
        }
    }

    private static DashboardMetadata toDashboardMetadata(ResultSet result) throws SQLException {
        DashboardMetadata dashboardMetadata = new DashboardMetadata();
        dashboardMetadata.setName(result.getString(COLUMN_DASHBOARD_NAME));
        dashboardMetadata.setOwner(result.getString(COLUMN_DASHBOARD_OWNER));
        dashboardMetadata.setUrl(result.getString(COLUMN_DASHBOARD_URL));
        dashboardMetadata.setDescription(result.getString(COLUMN_DASHBOARD_DESCRIPTION));
        dashboardMetadata.setParentId(result.getString(COLUMN_DASHBOARD_PARENT_ID));
        dashboardMetadata.setLandingPage(result.getString(COLUMN_DASHBOARD_LANDING_PAGE));
        return dashboardMetadata;
    }

    static void closeQuietly(Connection connection, PreparedStatement preparedStatement, ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException e) {
                LOGGER.error("An error occurred when closing result set.", (Throwable)e);
            }
        }
        if (preparedStatement != null) {
            try {
                preparedStatement.close();
            }
            catch (SQLException e) {
                LOGGER.error("An error occurred when closing prepared statement.", (Throwable)e);
            }
        }
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException e) {
                LOGGER.error("An error occurred when closing DB connection.", (Throwable)e);
            }
        }
    }

    static void rollbackQuietly(Connection connection) {
        if (connection != null) {
            try {
                connection.rollback();
            }
            catch (SQLException e) {
                LOGGER.error("An error occurred when rollbacking DB connection.", (Throwable)e);
            }
        }
    }
}

