/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dashboards.core.internal.database;

import javax.sql.DataSource;
import org.wso2.carbon.dashboards.core.bean.DashboardConfigurations;
import org.wso2.carbon.dashboards.core.exception.DashboardException;
import org.wso2.carbon.dashboards.core.internal.database.DashboardMetadataDao;
import org.wso2.carbon.dashboards.core.internal.database.QueryManager;
import org.wso2.carbon.datasource.core.api.DataSourceService;
import org.wso2.carbon.datasource.core.exception.DataSourceException;

public class DashboardMetadataDaoFactory {
    private static final String DATA_SOURCE_NAME_DASHBOARD = "WSO2_DASHBOARD_DB";

    public static DashboardMetadataDao createDao(DataSourceService dataSourceService, DashboardConfigurations dashboardConfigurations) throws DashboardException {
        DataSource dataSource;
        try {
            dataSource = (DataSource)dataSourceService.getDataSource(DATA_SOURCE_NAME_DASHBOARD);
        }
        catch (DataSourceException e) {
            throw new DashboardException("Cannot find data source named 'WSO2_DASHBOARD_DB'.", e);
        }
        QueryManager queryManager = new QueryManager(dashboardConfigurations);
        return new DashboardMetadataDao(dataSource, queryManager);
    }
}

