/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dashboards.core.internal.database;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.wso2.carbon.dashboards.core.bean.DashboardConfigurations;
import org.wso2.carbon.dashboards.core.exception.DashboardRuntimeException;
import org.wso2.carbon.database.query.manager.QueryProvider;
import org.wso2.carbon.database.query.manager.config.Queries;
import org.wso2.carbon.database.query.manager.exception.QueryMappingNotAvailableException;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.introspector.BeanAccess;

public class QueryManager {
    public static final String DASHBOARD_RESOURCE_TABLE = "DASHBOARD_RESOURCE";
    public static final String WIDGET_RESOURCE_TABLE = "WIDGET_RESOURCE";
    public static final String TABLE_CHECK = "table_check";
    public static final String CREATE_DASHBOARD_RESOURCE_TABLE = "create_dashboard_resource_table";
    public static final String CREATE_WIDGET_RESOURCE_TABLE = "create_widget_resource_table";
    public static final String TABLE_NAME_PLACEHOLDER = "{{TABLE_NAME}}";
    public static final String ADD_DASHBOARD_CONTENT_QUERY = "add_dashboard";
    public static final String ADD_WIDGET_CONFIG_QUERY = "add_widget_config";
    public static final String UPDATE_WIDGET_CONFIG_QUERY = "update_widget_config";
    public static final String GET_WIDGET_CONFIG_QUERY = "get_widget_config";
    public static final String GET_WIDGET_NAME_ID_MAP_QUERY = "get_widget_name_id_map";
    public static final String DELETE_WIDGET_BY_ID = "delete_widget_by_id";
    public static final String GET_DASHBOARD_METADATA_LIST_QUERY = "get_dashboard_metadata_list";
    public static final String GET_DASHBOARD_BY_URL_QUERY = "get_dashboard_by_url";
    public static final String DELETE_DASHBOARD_BY_URL_QUERY = "delete_dashboard_by_url";
    public static final String UPDATE_DASHBOARD_CONTENT_QUERY = "update_dashboard_content";
    public static final String DEFAULT_DB_TYPE = "H2";
    public static final String DEFAULT_DB_VERSION = "default";
    private static final String FILE_SQL_QUERIES = "sql-queries.yaml";
    private final List<Queries> componentQueries;
    private final List<Queries> deploymentQueries;
    private final Map<String, Map<String, String>> queryMap = new HashMap<String, Map<String, String>>();

    public QueryManager(DashboardConfigurations dashboardConfigurations) {
        this.componentQueries = this.readConfigs();
        this.deploymentQueries = dashboardConfigurations.getQueries();
    }

    private List<Queries> readConfigs() {
        List<Queries> queries;
        try (InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(FILE_SQL_QUERIES);){
            if (inputStream == null) {
                throw new DashboardRuntimeException("Cannot find file 'sql-queries.yaml' in class path.");
            }
            Yaml yaml = new Yaml((BaseConstructor)new OsgiClassLoaderConstructor());
            yaml.setBeanAccess(BeanAccess.FIELD);
            queries = ((DashboardConfigurations)yaml.loadAs(inputStream, DashboardConfigurations.class)).getQueries();
        }
        catch (IOException e) {
            throw new DashboardRuntimeException("Cannot read YAML file 'sql-queries.yaml' from classpath.", e);
        }
        catch (Exception e) {
            throw new DashboardRuntimeException("YAML file 'sql-queries.yaml' is invalid.", e);
        }
        return queries;
    }

    public String getQuery(Connection connection, String key) throws SQLException {
        return this.getQuery(connection.getMetaData().getDatabaseProductName(), connection.getMetaData().getDatabaseProductVersion(), key);
    }

    public String getQuery(String dbType, String dbVersion, String key) throws SQLException {
        String query;
        String dbKey = dbType + "_" + dbVersion;
        Map queries = this.queryMap.get(dbKey);
        if (queries == null) {
            try {
                queries = QueryProvider.mergeMapping((String)dbType, (String)dbVersion, this.componentQueries, this.deploymentQueries);
            }
            catch (QueryMappingNotAvailableException e) {
                throw new SQLException("Cannot find database queries for " + dbType + " " + dbVersion + ".", e);
            }
            this.queryMap.put(dbKey, queries);
        }
        if ((query = queries.get(key)) == null) {
            throw new SQLException("Cannot find query for " + key + " in " + dbType + " " + dbVersion + ".");
        }
        return this.queryMap.get(dbKey).get(key);
    }

    private static class OsgiClassLoaderConstructor
    extends Constructor {
        private OsgiClassLoaderConstructor() {
        }

        protected Class<?> getClassForName(String name) throws ClassNotFoundException {
            return Class.forName(name, true, ((Object)((Object)this)).getClass().getClassLoader());
        }
    }
}

