/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dashboards.core.internal.database;

import com.google.gson.Gson;
import java.nio.charset.StandardCharsets;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Set;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.dashboards.core.bean.widget.GeneratedWidgetConfigs;
import org.wso2.carbon.dashboards.core.exception.DashboardException;
import org.wso2.carbon.dashboards.core.internal.database.QueryManager;

public class WidgetMetadataDao {
    private static final Logger LOGGER = LoggerFactory.getLogger(WidgetMetadataDao.class);
    private static final String COLUMN_WIDGET_ID = "WIDGET_ID";
    private static final String COLUMN_WIDGET_NAME = "WIDGET_NAME";
    private static final String COLUMN_WIDGET_CONFIGS = "WIDGET_CONFIGS";
    private final DataSource dataSource;
    private final QueryManager queryManager;
    private static final Gson GSON = new Gson();

    public WidgetMetadataDao(DataSource dataSource, QueryManager queryManager) {
        this.dataSource = dataSource;
        this.queryManager = queryManager;
    }

    public void initWidgetTable() throws DashboardException {
        if (!this.tableExists("WIDGET_RESOURCE")) {
            this.createWidgetResourceTable();
        }
    }

    private void createWidgetResourceTable() throws DashboardException {
        Connection connection = null;
        PreparedStatement ps = null;
        String query = null;
        try {
            connection = this.getConnection();
            connection.setAutoCommit(false);
            query = this.queryManager.getQuery(connection, "create_widget_resource_table");
            ps = connection.prepareStatement(query);
            ps.executeUpdate();
            connection.commit();
        }
        catch (SQLException e) {
            try {
                WidgetMetadataDao.rollbackQuietly(connection);
                LOGGER.debug("Failed to execute SQL query {}", query);
                throw new DashboardException("Unable to create the 'WIDGET_RESOURCE' table.", e);
            }
            catch (Throwable throwable) {
                WidgetMetadataDao.closeQuietly(connection, ps, null);
                throw throwable;
            }
        }
        WidgetMetadataDao.closeQuietly(connection, ps, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tableExists(String tableName) {
        boolean bl;
        Connection connection = null;
        PreparedStatement ps = null;
        String query = null;
        try {
            connection = this.getConnection();
            query = this.queryManager.getQuery(connection, "table_check");
            ps = connection.prepareStatement(query.replace("{{TABLE_NAME}}", tableName));
            bl = ps.execute();
        }
        catch (SQLException e) {
            boolean bl2;
            try {
                WidgetMetadataDao.rollbackQuietly(connection);
                LOGGER.debug("Table '{}' assumed to not exist since its existence check query {} resulted in exception {}.", new Object[]{tableName, query, e.getMessage()});
                bl2 = false;
            }
            catch (Throwable throwable) {
                WidgetMetadataDao.closeQuietly(connection, ps, null);
                throw throwable;
            }
            WidgetMetadataDao.closeQuietly(connection, ps, null);
            return bl2;
        }
        WidgetMetadataDao.closeQuietly(connection, ps, null);
        return bl;
    }

    private Connection getConnection() throws SQLException {
        return this.dataSource.getConnection();
    }

    public void addGeneratedWidgetConfigs(GeneratedWidgetConfigs generatedWidgetConfigs) throws DashboardException {
        Connection connection = null;
        PreparedStatement ps = null;
        String query = null;
        generatedWidgetConfigs.setId(generatedWidgetConfigs.getName().replace(" ", "-"));
        try {
            connection = this.getConnection();
            query = this.queryManager.getQuery(connection, "add_widget_config");
            connection.setAutoCommit(false);
            ps = connection.prepareStatement(query);
            ps.setString(1, generatedWidgetConfigs.getId());
            ps.setString(2, generatedWidgetConfigs.getName());
            Blob blob = connection.createBlob();
            blob.setBytes(1L, WidgetMetadataDao.toJsonBytes(generatedWidgetConfigs));
            ps.setObject(3, blob);
            ps.executeUpdate();
            connection.commit();
        }
        catch (SQLException e) {
            try {
                WidgetMetadataDao.rollbackQuietly(connection);
                LOGGER.debug("Failed to execute SQL query {}", (Object)query);
                throw new DashboardException("Cannot create a new widget with " + generatedWidgetConfigs + ".", e);
            }
            catch (Throwable throwable) {
                WidgetMetadataDao.closeQuietly(connection, ps, null);
                throw throwable;
            }
        }
        WidgetMetadataDao.closeQuietly(connection, ps, null);
    }

    public void updateGeneratedWidgetConfigs(GeneratedWidgetConfigs generatedWidgetConfigs) throws DashboardException {
        Connection connection = null;
        PreparedStatement ps = null;
        String query = null;
        generatedWidgetConfigs.setId(generatedWidgetConfigs.getName().replace(" ", "-"));
        try {
            connection = this.getConnection();
            query = this.queryManager.getQuery(connection, "update_widget_config");
            connection.setAutoCommit(false);
            ps = connection.prepareStatement(query);
            Blob blob = connection.createBlob();
            blob.setBytes(1L, WidgetMetadataDao.toJsonBytes(generatedWidgetConfigs));
            ps.setObject(1, blob);
            ps.setString(2, generatedWidgetConfigs.getId());
            ps.executeUpdate();
            connection.commit();
        }
        catch (SQLException e) {
            try {
                WidgetMetadataDao.rollbackQuietly(connection);
                LOGGER.debug("Failed to execute SQL query {}", (Object)query);
                throw new DashboardException("Cannot update widget with " + generatedWidgetConfigs + ".", e);
            }
            catch (Throwable throwable) {
                WidgetMetadataDao.closeQuietly(connection, ps, null);
                throw throwable;
            }
        }
        WidgetMetadataDao.closeQuietly(connection, ps, null);
    }

    private static byte[] toJsonBytes(Object generatedWidgetConfigs) {
        return GSON.toJson(generatedWidgetConfigs).getBytes(StandardCharsets.UTF_8);
    }

    private static GeneratedWidgetConfigs fromJsonBytes(Blob byteBlob) throws SQLException {
        return (GeneratedWidgetConfigs)GSON.fromJson(new String(byteBlob.getBytes(1L, (int)byteBlob.length()), StandardCharsets.UTF_8), GeneratedWidgetConfigs.class);
    }

    public GeneratedWidgetConfigs getGeneratedWidgetConfigsForId(String widgetId) throws DashboardException {
        ResultSet resultSet;
        PreparedStatement ps;
        Connection connection;
        block4: {
            GeneratedWidgetConfigs generatedWidgetConfigs;
            connection = null;
            ps = null;
            resultSet = null;
            String query = null;
            try {
                connection = this.getConnection();
                query = this.queryManager.getQuery(connection, "get_widget_config");
                ps = connection.prepareStatement(query);
                ps.setString(1, widgetId);
                resultSet = ps.executeQuery();
                if (!resultSet.next()) break block4;
                generatedWidgetConfigs = WidgetMetadataDao.fromJsonBytes(resultSet.getBlob(COLUMN_WIDGET_CONFIGS));
            }
            catch (SQLException e) {
                try {
                    WidgetMetadataDao.rollbackQuietly(connection);
                    LOGGER.debug("Failed to execute SQL query {}", (Object)query);
                    throw new DashboardException("Cannot get widget configuration for widget id  " + widgetId + ".", e);
                }
                catch (Throwable throwable) {
                    WidgetMetadataDao.closeQuietly(connection, ps, resultSet);
                    throw throwable;
                }
            }
            WidgetMetadataDao.closeQuietly(connection, ps, resultSet);
            return generatedWidgetConfigs;
        }
        WidgetMetadataDao.closeQuietly(connection, ps, resultSet);
        return null;
    }

    public Set<GeneratedWidgetConfigs> getGeneratedWidgetIdSet() throws DashboardException {
        HashSet<GeneratedWidgetConfigs> hashSet;
        Connection connection = null;
        PreparedStatement ps = null;
        ResultSet resultSet = null;
        String query = null;
        try {
            connection = this.getConnection();
            query = this.queryManager.getQuery(connection, "get_widget_name_id_map");
            ps = connection.prepareStatement(query);
            resultSet = ps.executeQuery();
            HashSet<GeneratedWidgetConfigs> widgetNameSet = new HashSet<GeneratedWidgetConfigs>();
            while (resultSet.next()) {
                GeneratedWidgetConfigs generatedWidgetConfigs = WidgetMetadataDao.fromJsonBytes(resultSet.getBlob(COLUMN_WIDGET_CONFIGS));
                widgetNameSet.add(generatedWidgetConfigs);
            }
            hashSet = widgetNameSet;
        }
        catch (SQLException e) {
            try {
                WidgetMetadataDao.rollbackQuietly(connection);
                LOGGER.debug("Failed to execute SQL query {}", (Object)query);
                throw new DashboardException("Failed to get widget widget name set.", e);
            }
            catch (Throwable throwable) {
                WidgetMetadataDao.closeQuietly(connection, ps, resultSet);
                throw throwable;
            }
        }
        WidgetMetadataDao.closeQuietly(connection, ps, resultSet);
        return hashSet;
    }

    public void delete(String widgetId) throws DashboardException {
        Connection connection = null;
        PreparedStatement ps = null;
        String query = null;
        try {
            connection = this.getConnection();
            query = this.queryManager.getQuery(connection, "delete_widget_by_id");
            connection.setAutoCommit(false);
            ps = connection.prepareStatement(query);
            ps.setString(1, widgetId);
            ps.executeUpdate();
            connection.commit();
        }
        catch (SQLException e) {
            try {
                WidgetMetadataDao.rollbackQuietly(connection);
                LOGGER.debug("Failed to execute SQL query {}", (Object)query);
                throw new DashboardException("Cannot delete widget id: '" + widgetId + "'.", e);
            }
            catch (Throwable throwable) {
                WidgetMetadataDao.closeQuietly(connection, ps, null);
                throw throwable;
            }
        }
        WidgetMetadataDao.closeQuietly(connection, ps, null);
    }

    static void closeQuietly(Connection connection, PreparedStatement preparedStatement, ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException e) {
                LOGGER.error("An error occurred when closing result set.", (Throwable)e);
            }
        }
        if (preparedStatement != null) {
            try {
                preparedStatement.close();
            }
            catch (SQLException e) {
                LOGGER.error("An error occurred when closing prepared statement.", (Throwable)e);
            }
        }
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException e) {
                LOGGER.error("An error occurred when closing DB connection.", (Throwable)e);
            }
        }
    }

    static void rollbackQuietly(Connection connection) {
        if (connection != null) {
            try {
                connection.rollback();
            }
            catch (SQLException e) {
                LOGGER.error("An error occurred when rollbacking DB connection.", (Throwable)e);
            }
        }
    }
}

