/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dashboards.core.internal.io;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.carbon.dashboards.core.bean.importer.DashboardArtifact;
import org.wso2.carbon.dashboards.core.exception.DashboardException;

public class DashboardArtifactHandler {
    private static final String ARTIFACT_EXTENSION = ".json";
    private static final Gson GSON = new Gson();
    private static final Logger LOGGER = LoggerFactory.getLogger(DashboardArtifactHandler.class);

    public static Map<String, DashboardArtifact> readArtifactsIn(Path directory) throws DashboardException {
        Set filePaths;
        try {
            filePaths = Files.list(directory).filter(DashboardArtifactHandler::isValidArtifact).collect(Collectors.toSet());
        }
        catch (IOException e) {
            throw new DashboardException("Cannot list dashboard artifacts in '" + directory + "'.", e);
        }
        HashMap<String, DashboardArtifact> dashboardArtifacts = new HashMap<String, DashboardArtifact>();
        for (Path filePath : filePaths) {
            try {
                JsonObject root;
                JsonArray pages;
                String fileContent = new String(Files.readAllBytes(filePath), StandardCharsets.UTF_8);
                DashboardArtifact dashboardArtifact = (DashboardArtifact)GSON.fromJson(fileContent, DashboardArtifact.class);
                if (dashboardArtifact.getDashboard().getContent().getPages() == null && !(pages = (root = (JsonObject)GSON.fromJson(fileContent, JsonObject.class)).getAsJsonObject("dashboard").getAsJsonArray("pages")).isJsonNull()) {
                    dashboardArtifact.getDashboard().getContent().setPages(pages);
                }
                dashboardArtifacts.put(filePath.toAbsolutePath().toString(), dashboardArtifact);
            }
            catch (IOException e) {
                throw new DashboardException("Cannot read dashboard artifact '" + filePath + "'.", e);
            }
            catch (JsonSyntaxException e) {
                LOGGER.warn("Dashboard artifact '{}' is invalid and is ignored.", (Object)filePath, (Object)e);
            }
        }
        return dashboardArtifacts;
    }

    private static boolean isValidArtifact(Path filePath) {
        return Files.isRegularFile(filePath, new LinkOption[0]) && DashboardArtifactHandler.getFileName(filePath).endsWith(ARTIFACT_EXTENSION);
    }

    private static String getFileName(Path filePath) {
        Path fileName = filePath.getFileName();
        return fileName == null ? "" : fileName.toString();
    }

    public static void markArtifactAsImported(String artifactFilePath) {
        Path artifactPath = Paths.get(artifactFilePath, new String[0]);
        try {
            Files.move(artifactPath, artifactPath.resolveSibling(DashboardArtifactHandler.getFileName(artifactPath) + ".imported"), new CopyOption[0]);
        }
        catch (IOException e) {
            LOGGER.warn("Cannot mark dashboard artifact '{}' as imported. Hence, it will be re-imported in next server startup.", (Object)artifactFilePath, (Object)e);
        }
    }
}

