/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dashboards.core.internal.io;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.wso2.carbon.dashboards.core.bean.widget.WidgetMetaInfo;
import org.wso2.carbon.dashboards.core.exception.DashboardRuntimeException;
import org.wso2.carbon.uiserver.api.Extension;

public class WidgetConfigurationReader {
    private static final String FILE_NAME_WIDGET_CONFIGURATION = "widgetConf.json";
    private static final Gson GSON = new Gson();

    public static WidgetMetaInfo getConfiguration(Extension widget) throws DashboardRuntimeException {
        Path widgetConfPath = Paths.get(widget.getLeastPriorityPath(), FILE_NAME_WIDGET_CONFIGURATION);
        try {
            String widgetConf = new String(Files.readAllBytes(widgetConfPath), StandardCharsets.UTF_8);
            return (WidgetMetaInfo)GSON.fromJson(widgetConf, WidgetMetaInfo.class);
        }
        catch (IOException e) {
            throw new DashboardRuntimeException("Cannot read configuration file '" + widgetConfPath + "' of widget '" + widget.getName() + "'.");
        }
        catch (JsonSyntaxException e) {
            throw new DashboardRuntimeException("Configuration file '" + widgetConfPath + "' of widget '" + widget.getName() + "' is invalid.");
        }
    }
}

