/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dashboards.core.utils;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.wso2.carbon.dashboards.core.bean.DashboardMetadataContent;
import org.wso2.carbon.dashboards.core.bean.importer.Page;
import org.wso2.carbon.dashboards.core.bean.importer.PageContent;
import org.wso2.carbon.dashboards.core.bean.importer.WidgetType;

public class DashboardUtil {
    private static final String UNIVERSAL_WIDGET = "UniversalWidget";

    public static Map<WidgetType, Set<String>> findWidgets(DashboardMetadataContent dashboardMetadataContent) {
        HashMap<WidgetType, Set<String>> widgets = new HashMap<WidgetType, Set<String>>();
        widgets.put(WidgetType.GENERATED, new HashSet());
        widgets.put(WidgetType.CUSTOM, new HashSet());
        Gson gson = new Gson();
        for (JsonElement element : dashboardMetadataContent.getPages()) {
            Page page = (Page)gson.fromJson(element, Page.class);
            DashboardUtil.findWidgets(page.getContent(), widgets);
        }
        return widgets;
    }

    public static void findWidgets(Set<PageContent> contents, Map<WidgetType, Set<String>> widgets) {
        for (PageContent content : contents) {
            if (content.getComponent() != null) {
                if (UNIVERSAL_WIDGET.equals(content.getComponent())) {
                    widgets.get((Object)WidgetType.GENERATED).add((String)content.getProps().get("widgetID"));
                } else {
                    widgets.get((Object)WidgetType.CUSTOM).add(content.getComponent());
                }
            }
            if (content.getContent() == null) continue;
            DashboardUtil.findWidgets(content.getContent(), widgets);
        }
    }
}

