DROP TABLE IF EXISTS DASHBOARD_RESOURCE;
CREATE TABLE IF NOT EXISTS DASHBOARD_RESOURCE (
  ID                INTEGER      NOT NULL AUTO_INCREMENT,
  URL               VARCHAR(100) NOT NULL,
  OWNER             VARCHAR(100) NOT NULL,
  NAME              VARCHAR(256) NOT NULL,
  DESCRIPTION       VARCHAR(1000),
  PARENT_ID         INTEGER      NOT NULL,
  LANDING_PAGE      VARCHAR(100),
  CONTENT           LONGBLOB,
  CONSTRAINT PK_DASHBOARD_RESOURCE PRIMARY KEY (URL,OWNER),
  UNIQUE (ID)
);

DROP TABLE IF EXISTS WIDGET_RESOURCE;
CREATE TABLE IF NOT EXISTS WIDGET_RESOURCE (
  WIDGET_ID                   VARCHAR(255) NOT NULL,
  WIDGET_NAME                 VARCHAR(255) NOT NULL,
  WIDGET_CONFIGS              LONGBLOB,
  CONSTRAINT PK_WIDGET_RESOURCE PRIMARY KEY (WIDGET_ID, WIDGET_NAME),
  UNIQUE (WIDGET_ID, WIDGET_NAME)
);