/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.dashboard.shindig.extensions;

import com.google.common.base.Strings;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletResponse;
import org.apache.shindig.common.servlet.HttpUtil;
import org.apache.shindig.gadgets.servlet.GadgetRenderingServlet;
import org.apache.shindig.gadgets.uri.UriCommon;
import org.apache.shindig.gadgets.uri.UriStatus;
import org.wso2.carbon.dashboard.shindig.extensions.WSO2Renderer;

public class WSO2GadgetRenderingServlet
extends GadgetRenderingServlet {
    private static final long serialVersionUID = -5634040113214794888L;
    private static final int DEFAULT_CACHE_TTL = 300;
    private static final String classname = WSO2GadgetRenderingServlet.class.getName();
    private static final Logger LOG = Logger.getLogger(classname, "org.apache.shindig.common.logging.i18n.resource");

    @Inject
    public void setRenderer(WSO2Renderer renderer) {
        this.checkInitialized();
        this.renderer = renderer;
    }

    protected void onOkRenderingResultsStatus(GadgetRenderingServlet.PostGadgetRenderingParams params) throws IOException {
        UriStatus urlStatus = params.getUrlStatus();
        HttpServletResponse resp = params.getResponse();
        if (params.getContext().getIgnoreCache() || urlStatus == UriStatus.INVALID_VERSION) {
            HttpUtil.setCachingHeaders((HttpServletResponse)resp, (int)0);
        } else if (urlStatus == UriStatus.VALID_VERSIONED) {
            HttpUtil.setCachingHeaders((HttpServletResponse)resp, (boolean)true);
        } else {
            int ttl;
            block7: {
                ttl = 300;
                String ttlStr = params.getRequest().getParameter(UriCommon.Param.REFRESH.getKey());
                if (!Strings.isNullOrEmpty((String)ttlStr)) {
                    try {
                        ttl = Integer.parseInt(ttlStr);
                    }
                    catch (NumberFormatException e) {
                        if (!LOG.isLoggable(Level.INFO)) break block7;
                        LOG.logp(Level.INFO, classname, "onOkRenderingResultsStatus", "malformedTtlValue", new Object[]{ttlStr});
                    }
                }
            }
            HttpUtil.setCachingHeaders((HttpServletResponse)resp, (int)ttl, (boolean)true);
        }
        resp.getWriter().print(this.getContentWithFinishedLoadingTrigger(params.getResults().getContent()));
    }

    private String getContentWithFinishedLoadingTrigger(String gadgetContent) {
        if (!gadgetContent.contains("wso2.gadgets.controls.finishedLoadingGadget()")) {
            String[] contents = gadgetContent.split("<script>gadgets\\.util\\.runOnLoadHandlers\\(\\);</script>");
            return contents[0] + "<script>wso2.gadgets.controls.finishedLoadingGadget();gadgets.util.runOnLoadHandlers();</script>" + contents[1];
        }
        return gadgetContent;
    }
}

